/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.util.xml;

import java.io.Serializable;
import java.nio.CharBuffer;
import org.xml.sax.Locator;

public class MyLocator
implements Locator,
Serializable {
    private static final long serialVersionUID = 1L;
    int lineNumber = 1;
    int columnNumber = 1;
    int absPosition = 0;

    public MyLocator() {
    }

    public MyLocator(MyLocator orig) {
        this.assign(orig);
    }

    @Override
    public int getColumnNumber() {
        return this.columnNumber;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return null;
    }

    public int getAbsPosition() {
        return this.absPosition;
    }

    void advance(char c) {
        ++this.absPosition;
        if (c == '\n') {
            ++this.lineNumber;
            this.columnNumber = 1;
        } else {
            ++this.columnNumber;
        }
    }

    void advance(CharBuffer buff, int start, int end) {
        int i = start;
        this.absPosition += end - start;
        while (i != end) {
            if (buff.get(i++) != '\n') continue;
            start = i;
            ++this.lineNumber;
            this.columnNumber = 1;
        }
        if (end != start) {
            this.columnNumber += i - start;
        }
    }

    void advance(char[] buff, int start, int end) {
        int i = start;
        this.absPosition += end - start;
        while (i != end) {
            if (buff[i++] != '\n') continue;
            start = i;
            ++this.lineNumber;
            this.columnNumber = 1;
        }
        if (end != start) {
            this.columnNumber += i - start;
        }
    }

    void advanceChars(int numberOfChars) {
        this.columnNumber += numberOfChars;
        this.absPosition += numberOfChars;
    }

    void assign(MyLocator newValue) {
        this.columnNumber = newValue.columnNumber;
        this.lineNumber = newValue.lineNumber;
        this.absPosition = newValue.absPosition;
    }
}

