/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.util.xml;

import java.nio.charset.Charset;

public class ByteOrderMarkDetector {
    private static final BOM[] BOMS = new BOM[]{new BOM(new byte[]{-17, -69, -65}, true, "UTF-8"), new BOM(new byte[]{0, 0, -2, -1}, true, "UTF-32BE"), new BOM(new byte[]{-1, -2, 0, 0}, true, "UTF-32LE"), new BOM(new byte[]{-2, -1}, true, "UTF-16BE"), new BOM(new byte[]{-1, -2}, true, "UTF-16LE"), new BOM(new byte[]{0, 0, 0, 60}, false, "UTF-32BE"), new BOM(new byte[]{60, 0, 0, 0}, false, "UTF-32LE"), new BOM(new byte[]{0, 60, 0, 63}, false, "UTF-16BE"), new BOM(new byte[]{60, 0, 63, 0}, false, "UTF-16LE"), new BOM(new byte[]{76, 111, -89, -108}, false, "IBM-037")};
    private Charset found;
    private BOM bomFound;
    private byte[] header = new byte[4];
    private int writePos = 0;

    public boolean nextByte(byte b) {
        if (this.writePos >= this.header.length) {
            throw new IllegalStateException("No additional byte expected");
        }
        this.header[this.writePos++] = b;
        if (this.writePos < this.header.length) {
            return true;
        }
        for (BOM bom : BOMS) {
            int i;
            for (i = 0; i < bom.header.length && bom.header[i] == this.header[i]; ++i) {
            }
            if (i != bom.header.length) continue;
            this.found = Charset.forName(bom.charset);
            if (bom.ignoreHeader) {
                this.bomFound = bom;
                byte[] newHeader = new byte[4 - bom.header.length];
                System.arraycopy(this.header, bom.header.length, newHeader, 0, newHeader.length);
                this.header = newHeader;
            }
            return false;
        }
        this.found = Charset.forName("UTF-8");
        return false;
    }

    public Charset getFound() {
        return this.found;
    }

    public BOM getBomFound() {
        return this.bomFound;
    }

    public byte[] getReplay() {
        return this.header;
    }

    static class BOM {
        final byte[] header;
        final boolean ignoreHeader;
        final String charset;

        private BOM(byte[] header, boolean ignoreHeader, String charset) {
            this.header = header;
            this.ignoreHeader = ignoreHeader;
            this.charset = charset;
        }
    }
}

