/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.util;

import de.businesslogics.io.ComparingOutputStream;
import de.businesslogics.io.NullOutputStream;
import de.businesslogics.io.Streams;
import de.businesslogics.util.HexTool;
import de.businesslogics.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URLDecoder;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SystemUtils {
    private static final String[][] pdfCommands = new String[][]{{"cmd", "/C", "{0}"}, {"gpdf", "{0}"}, {"xpdf", "{0}"}, {"kpdf", "{0}"}, {"acroread", "{0}"}};
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{([\\p{Graph}&&[^${}]]+)\\}");

    public static <E> E[] getReversedArray(E[] array) {
        if (array != null) {
            Object[] toReturn = (Object[])array.clone();
            for (int i = 0; i < array.length; ++i) {
                toReturn[i] = array[array.length - 1 - i];
            }
            return toReturn;
        }
        return null;
    }

    public static <E> List<E> getReversedList(List<E> list) {
        if (list != null) {
            ArrayList<E> reversedList = new ArrayList<E>();
            reversedList.addAll(list);
            Collections.reverse(reversedList);
            return reversedList;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean filesAreEqual(File file1, File file2) {
        boolean bl;
        FileInputStream in1 = null;
        FileInputStream in2 = null;
        try {
            if (file1.length() != file2.length()) {
                boolean bl2 = false;
                return bl2;
            }
            in1 = new FileInputStream(file1);
            in2 = new FileInputStream(file2);
            ComparingOutputStream.compare(in1, in2);
            bl = true;
            SystemUtils.close(in1);
        }
        catch (Exception e) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            SystemUtils.close(in1);
            SystemUtils.close(in2);
        }
        SystemUtils.close(in2);
        return bl;
    }

    public static void deleteFile(File file) {
        boolean succeeded;
        if (file.exists() && !(succeeded = file.delete())) {
            file.deleteOnExit();
        }
    }

    public static void renameFile(File original, File target) throws IOException {
        boolean succeeded = original.renameTo(target);
        if (!succeeded) {
            SystemUtils.copyFile(original, target);
            succeeded = original.delete();
            if (!succeeded) {
                original.deleteOnExit();
            }
        }
    }

    public static void copyFile(File original, File target) throws IOException {
        FileInputStream in = new FileInputStream(original);
        SystemUtils.copyStream(in, target, true);
    }

    public static void copyStream(InputStream in, File target, boolean closeStream) throws IOException {
        boolean deleteOnError = !target.exists() || target.canWrite();
        try {
            FileOutputStream out = new FileOutputStream(target);
            try {
                Streams.copy(in, out);
            }
            catch (IOException ioe) {
                SystemUtils.close(out);
                if (deleteOnError) {
                    target.delete();
                }
                throw ioe;
            }
        }
        catch (IOException ioe) {
            if (closeStream) {
                SystemUtils.close(in);
            }
            throw ioe;
        }
    }

    public static String calculateHash(InputStream input, String algorithm) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        DigestInputStream dig = new DigestInputStream(input, digest);
        Streams.copy(dig, new NullOutputStream(), true);
        return HexTool.toHex(dig.getMessageDigest().digest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String calculateHash(File file, String algorithm) throws IOException, NoSuchAlgorithmException {
        String string;
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            string = SystemUtils.calculateHash(in, algorithm);
        }
        catch (Throwable throwable) {
            SystemUtils.close(in);
            throw throwable;
        }
        SystemUtils.close(in);
        return string;
    }

    public static String calculateMD5Hash(InputStream input) throws IOException, NoSuchAlgorithmException {
        return SystemUtils.calculateHash(input, "MD5");
    }

    public static String calculateMD5Hash(File file) throws IOException, NoSuchAlgorithmException {
        return SystemUtils.calculateHash(file, "MD5");
    }

    public static void close(AutoCloseable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void autoClose(AutoCloseable resource) {
        try {
            if (resource != null) {
                resource.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static File locateJarDir(Class<?> c) {
        File f;
        String rn = "/" + c.getName().replace('.', '/') + ".class";
        String s = c.getResource(rn).getPath();
        if ((s = s.substring(0, s.length() - rn.length())).startsWith("file:")) {
            s = URLDecoder.decode(s);
            s = s.substring(5);
        }
        if (s.endsWith("!")) {
            s = s.substring(0, s.length() - 1);
        }
        if ((f = new File(s)).isDirectory()) {
            return f;
        }
        return f.getParentFile();
    }

    public static boolean deleteRecursive(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        File[] dirList = dir.listFiles();
        for (int i = 0; i < dirList.length; ++i) {
            File f = dirList[i];
            if (!f.isDirectory() ? f.delete() : SystemUtils.deleteRecursive(f)) continue;
            return false;
        }
        return dir.delete();
    }

    public static Process tryExecs(String[][] messageFormats, Object[] params, File workDir) {
        Runtime runtime = Runtime.getRuntime();
        for (int i = 0; i < messageFormats.length; ++i) {
            String[] commands = new String[messageFormats[i].length];
            for (int j = 0; j < commands.length; ++j) {
                commands[j] = MessageFormat.format(messageFormats[i][j], params);
            }
            try {
                return runtime.exec(commands, null, workDir);
            }
            catch (IOException iOException) {
                continue;
            }
        }
        return null;
    }

    public static Process printPDF(File f) {
        return SystemUtils.tryExecs(pdfCommands, new Object[]{f}, new File("."));
    }

    public static void throwRuntimeException(Throwable e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new RuntimeException(e);
    }

    public static String toFilename(String name) {
        String s;
        if (name == null) {
            return null;
        }
        int i = ((String)(name = StringUtils.trimRight((String)name))).indexOf(46);
        if (i < 0) {
            i = ((String)name).length();
        }
        if (i == 3) {
            String s2 = ((String)name).substring(0, 3).toUpperCase();
            if (s2.equals("AUX") || s2.equals("CON") || s2.equals("NUL") || s2.equals("PRN")) {
                name = ((String)name).substring(0, 3) + "_" + ((String)name).substring(3);
            }
        } else if (i == 4 && Character.isDigit(((String)name).charAt(3)) && ((s = ((String)name).substring(0, 3).toUpperCase()).equals("COM") || s.equals("LPT"))) {
            name = ((String)name).substring(0, 4) + "_" + ((String)name).substring(4);
        }
        return ((String)name).replace('?', '_').replace('<', '_').replace('>', '_').replace(':', '_').replace('|', '_').replace('*', '_').replace('/', '_').replace('\\', '_').replace('\"', '_');
    }

    private static int extractGenericTypeIndex(Class<?> parameterizedType, String typeName) {
        TypeVariable<Class<?>>[] genericTypes = parameterizedType.getTypeParameters();
        for (int i = 0; i < genericTypes.length; ++i) {
            if (!genericTypes[i].getName().equals(typeName)) continue;
            return i;
        }
        throw new RuntimeException("No type " + typeName + " found on " + String.valueOf(parameterizedType));
    }

    private static Type extractGenericInterfaceType(Class<?> inspect, Class<?> iClazz, int iIndex) {
        ParameterizedType pt;
        Class superClass;
        Type t;
        Type[] gis;
        for (Type gi : gis = inspect.getGenericInterfaces()) {
            Class up;
            if (!(gi instanceof ParameterizedType)) continue;
            ParameterizedType pt2 = (ParameterizedType)gi;
            if (pt2.getRawType().equals(iClazz)) {
                return pt2.getActualTypeArguments()[iIndex];
            }
            Type t2 = pt2.getRawType();
            if (!(t2 instanceof Class) || (t2 = SystemUtils.extractGenericInterfaceType(up = (Class)t2, iClazz, iIndex)) == null) continue;
            if (t2 instanceof Class) {
                return t2;
            }
            TypeVariable tv = (TypeVariable)t2;
            return pt2.getActualTypeArguments()[SystemUtils.extractGenericTypeIndex(up, tv.getName())];
        }
        Type up = inspect.getGenericSuperclass();
        while (up instanceof Class) {
            up = ((Class)up).getGenericSuperclass();
        }
        if (up instanceof ParameterizedType && (t = SystemUtils.extractGenericInterfaceType(superClass = (Class)(pt = (ParameterizedType)up).getRawType(), iClazz, iIndex)) != null) {
            if (t instanceof Class) {
                return t;
            }
            TypeVariable tv = (TypeVariable)t;
            return pt.getActualTypeArguments()[SystemUtils.extractGenericTypeIndex(superClass, tv.getName())];
        }
        return null;
    }

    public static Class<?> extractGenericInterfaceType(Class<?> inspect, Class<?> iClazz, String name) {
        int i = SystemUtils.extractGenericTypeIndex(iClazz, name);
        return (Class)SystemUtils.extractGenericInterfaceType(inspect, iClazz, i);
    }

    public static String expandNetworkDrive(String filePath) {
        if (filePath == null || filePath.length() < 2 || filePath.charAt(1) != ':') {
            return filePath;
        }
        try {
            Runtime runTime = Runtime.getRuntime();
            Process process = runTime.exec("net use");
            InputStream inStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String line = null;
            while (null != (line = bufferedReader.readLine())) {
                String[] components = line.split("\\s+");
                if (components.length <= 2 || !components[1].equalsIgnoreCase(filePath.substring(0, 2))) continue;
                return filePath.replace(filePath.substring(0, 2), components[2]);
            }
            return filePath;
        }
        catch (IOException io) {
            return filePath;
        }
    }

    public static Properties resolvePropertiesValues(Properties originalProperties) {
        Properties toReturn = new Properties();
        for (Map.Entry<Object, Object> property : originalProperties.entrySet()) {
            if (property.getValue() instanceof String) {
                toReturn.put(property.getKey(), SystemUtils.resolve((String)property.getValue()));
                continue;
            }
            toReturn.put(property.getKey(), property.getValue());
        }
        return toReturn;
    }

    private static String resolve(String prop) {
        Matcher m = VARIABLE_PATTERN.matcher(prop);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String variable = m.group(1);
            String value = System.getProperty(variable, System.getenv(variable));
            m.appendReplacement(sb, null == value ? "" : Matcher.quoteReplacement(value));
        }
        m.appendTail(sb);
        return sb.toString();
    }
}

