/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.util;

import de.businesslogics.util.PaymentUtils;
import de.businesslogics.validation.RegularExpressions;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;

public class StringUtils {
    private static long BYTE = 1L;
    private static long KiB = BYTE << 10;
    private static long MiB = KiB << 10;
    private static long GiB = MiB << 10;
    private static long TiB = GiB << 10;
    private static long PiB = TiB << 10;
    private static long EiB = PiB << 10;

    private StringUtils() {
    }

    public static boolean isContainedInArray(String str, String[] sArr) {
        if (sArr != null) {
            for (String s : sArr) {
                if ((s == null || !s.equals(str)) && (s != null || str != null)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getElement(String[] sArr, int index) {
        if (sArr != null && sArr.length >= index + 1) {
            return sArr[index];
        }
        return null;
    }

    public static boolean containsOnly(String string, char[] allowed) {
        int i;
        if (allowed == null) {
            throw new IllegalArgumentException("allowed is null");
        }
        if (string == null) {
            return true;
        }
        HashSet<Character> checkChars = new HashSet<Character>(allowed.length);
        for (i = 0; i < allowed.length; ++i) {
            checkChars.add(Character.valueOf(allowed[i]));
        }
        for (i = 0; i < string.length(); ++i) {
            if (checkChars.contains(Character.valueOf(string.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public static String asString(Object[] array) {
        if (array == null) {
            return "null";
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < array.length - 1; ++i) {
            buffer.append(array[i] == null ? "null" : array[i].toString());
            buffer.append(", ");
        }
        if (array.length > 0) {
            buffer.append(array[array.length - 1].toString());
        }
        return buffer.toString();
    }

    public static String[] formatSwiftArray(String[] sArr, int maxCountLines, int maxLineLength) {
        if (sArr == null || sArr.length == 0) {
            return sArr;
        }
        ArrayList<String> lines = new ArrayList<String>();
        for (String s : sArr) {
            if (s == null || s.isEmpty()) continue;
            lines.add(s);
        }
        sArr = lines.toArray(new String[0]);
        return StringUtils.addSpaceWhenLineStartsWithMinus(sArr, maxCountLines, maxLineLength);
    }

    public static String[] addSpaceWhenLineStartsWithMinus(String[] lines, int maxCountLines, int maxLineLength) {
        if (lines == null || lines.length == 0) {
            return lines;
        }
        ArrayList<Object> toReturn = new ArrayList<Object>();
        Object line = null;
        Object lastCharsFromPreviousLine = null;
        for (int i = 0; i < lines.length; ++i) {
            line = lastCharsFromPreviousLine != null ? lastCharsFromPreviousLine + lines[i] : lines[i];
            if (((String)line).startsWith("-")) {
                line = " " + (String)line;
            }
            if (((String)line).length() > maxLineLength) {
                toReturn.add(((String)line).substring(0, maxLineLength));
                lastCharsFromPreviousLine = ((String)line).substring(maxLineLength);
                continue;
            }
            toReturn.add(line);
            lastCharsFromPreviousLine = null;
        }
        if (lastCharsFromPreviousLine != null && toReturn.size() < maxCountLines) {
            if (((String)lastCharsFromPreviousLine).startsWith("-")) {
                lastCharsFromPreviousLine = " " + (String)lastCharsFromPreviousLine;
            }
            if (((String)lastCharsFromPreviousLine).length() > maxLineLength) {
                toReturn.add(((String)lastCharsFromPreviousLine).substring(0, maxLineLength));
            } else {
                toReturn.add(lastCharsFromPreviousLine);
            }
        }
        return toReturn.toArray(new String[0]);
    }

    public static String[] getStringArrayFromString(String s, int length) {
        if (s == null || length <= 0) {
            return null;
        }
        if (s.isEmpty()) {
            return new String[]{""};
        }
        int arrayLength = (s.length() - 1) / length + 1;
        String[] sArr = new String[arrayLength];
        int startPos = 0;
        for (int i = 0; i < arrayLength - 1; ++i) {
            sArr[i] = s.substring(startPos, startPos + length);
            startPos += length;
        }
        sArr[arrayLength - 1] = s.substring(startPos);
        return sArr;
    }

    public static String[] getStringArrayFromStringWithCRLF(String s, int length) {
        if (s == null || length <= 0) {
            return null;
        }
        if (s.isEmpty()) {
            return new String[]{""};
        }
        ArrayList sList = new ArrayList();
        StringTokenizer st = new StringTokenizer(s, "\r\n");
        while (st.hasMoreTokens()) {
            String[] sArr = StringUtils.getStringArrayFromString(st.nextToken(), length);
            Collections.addAll(sList, sArr);
        }
        return sList.toArray(new String[sList.size()]);
    }

    public static String[] getStringArrayFromString(String s, String delimiter) {
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return new String[]{""};
        }
        if (delimiter == null || delimiter.isEmpty()) {
            return new String[]{s};
        }
        ArrayList<String> sList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, delimiter);
        while (st.hasMoreTokens()) {
            sList.add(st.nextToken());
        }
        return sList.toArray(new String[sList.size()]);
    }

    public static int[] getIntArrayFromString(String s) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        ArrayList<String> sList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            sList.add(st.nextToken());
        }
        int count = sList.size();
        int[] integers = new int[count];
        for (int i = 0; i < count; ++i) {
            try {
                integers[i] = Integer.parseInt((String)sList.get(i));
                continue;
            }
            catch (Exception e) {
                return null;
            }
        }
        return integers;
    }

    public static String getStringFromStringArray(String[] sArr) {
        if (sArr == null || sArr.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sArr.length; ++i) {
            if (sArr[i] == null) continue;
            sb.append(sArr[i]);
        }
        return sb.toString();
    }

    public static String getStringFromStringArray(String[] sArr, String separator) {
        if (sArr == null || sArr.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sArr.length - 1; ++i) {
            if (sArr[i] == null) continue;
            sb.append(sArr[i]);
            if (separator == null) continue;
            sb.append(separator);
        }
        sb.append(sArr[sArr.length - 1]);
        return sb.toString();
    }

    public static String getStringFromStringList(List<String> sList, String separator) {
        if (sList == null || sList.isEmpty()) {
            return "";
        }
        int size = sList.size();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size - 1; ++i) {
            sb.append(sList.get(i));
            if (separator == null) continue;
            sb.append(separator);
        }
        sb.append(sList.get(size - 1));
        return sb.toString();
    }

    public static String getContentBetweenTags(String s, String openingTag, String closingTag) {
        int closingTagPos;
        if (s == null) {
            return null;
        }
        int index = s.indexOf(openingTag);
        if (index >= 0 && (closingTagPos = s.indexOf(closingTag, index += openingTag.length())) >= 0) {
            return s.substring(index, closingTagPos);
        }
        return null;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static boolean allEmpty(String ... strings) {
        for (String string : strings) {
            if (StringUtils.isEmpty(string)) continue;
            return false;
        }
        return true;
    }

    public static String checkNullAndTrim(String string) {
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    public static boolean valuesDiffer(String string1, String string2) {
        return !StringUtils.checkNullAndTrim(string1).equals(StringUtils.checkNullAndTrim(string2));
    }

    public static String fillUpFromLeft(String s, char c, int targetLength) {
        return StringUtils.fillUp(s, c, targetLength, false);
    }

    public static String fillUpFromRight(String s, char c, int targetLength) {
        return StringUtils.fillUp(s, c, targetLength, true);
    }

    private static String fillUp(String s, char c, int targetLength, boolean fromRight) {
        if (s != null) {
            StringBuilder sb = new StringBuilder(targetLength);
            if (fromRight) {
                sb.append(s);
                while (sb.length() < targetLength) {
                    sb.append(c);
                }
            } else {
                for (int countCharsToAdd = targetLength - s.length(); countCharsToAdd > 0; --countCharsToAdd) {
                    sb.append(c);
                }
                sb.append(s);
            }
            return sb.toString();
        }
        return null;
    }

    public static String removeLeadingChars(String s, char c) {
        if (s != null) {
            while (!s.isEmpty() && s.charAt(0) == c) {
                s = s.substring(1);
            }
        }
        return s;
    }

    public static byte[] getBytes(String s, Charset charset) {
        CharsetEncoder encoder = charset.newEncoder();
        CharBuffer cb = CharBuffer.wrap(s);
        try {
            ByteBuffer bb = encoder.encode(cb);
            byte[] toReturn = new byte[bb.remaining()];
            bb.get(toReturn);
            return toReturn;
        }
        catch (CharacterCodingException cce) {
            throw new RuntimeException(cce);
        }
    }

    public static String toString(byte[] src, int offset, int length, Charset charset) {
        CharsetDecoder decoder = charset.newDecoder();
        ByteBuffer bb = ByteBuffer.wrap(src, offset, length);
        try {
            return decoder.decode(bb).toString();
        }
        catch (CharacterCodingException cce) {
            throw new RuntimeException(cce);
        }
    }

    public static String toString(byte[] src, Charset charset) {
        return StringUtils.toString(src, 0, src.length, charset);
    }

    public static String maxLength(String s, int maxLength) {
        if (s == null || s.length() <= maxLength) {
            return s;
        }
        return s.substring(0, maxLength);
    }

    public static String[] getArrayWithFixedLength(String[] input, int length, String defaultString) {
        Object[] output = new String[length];
        if (input == null) {
            Arrays.fill(output, defaultString);
        } else if (input.length < length) {
            System.arraycopy(input, 0, output, 0, input.length);
            for (int i = input.length; i < length; ++i) {
                output[i] = defaultString;
            }
        } else {
            System.arraycopy(input, 0, output, 0, length);
        }
        return output;
    }

    public static String trimRight(String name) {
        int l;
        if (name == null) {
            return null;
        }
        for (l = name.length(); l > 0 && Character.isWhitespace(name.charAt(l - 1)); --l) {
        }
        return name.substring(0, l);
    }

    public static String convertToValidFileName(String s) {
        return StringUtils.convertToValidFileName(s, '_');
    }

    public static String convertToValidFileName(String s, char substitutionChar) {
        if (s != null) {
            s = s.replace('/', substitutionChar);
            s = s.replace('\\', substitutionChar);
            s = s.replace(':', substitutionChar);
            s = s.replace('\"', substitutionChar);
        }
        return s;
    }

    public static String toString(BigDecimal value, Locale locale, int minFractionDigits, boolean useGrouping) {
        if (value == null) {
            return null;
        }
        int signum = value.signum();
        value = value.abs();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
        int scale = value.scale();
        if (scale > 0) {
            value = value.movePointRight(scale);
        } else {
            scale = 0;
        }
        StringBuilder sb = new StringBuilder(value.toBigIntegerExact().toString());
        while (scale < minFractionDigits) {
            ++scale;
            sb.append('0');
        }
        while (sb.length() < scale + 1) {
            sb.insert(0, '0');
        }
        int p = sb.length() - scale;
        if (scale > 0) {
            sb.insert(p, symbols.getDecimalSeparator());
        }
        if (useGrouping) {
            p -= 3;
            while (p > 0) {
                sb.insert(p, symbols.getGroupingSeparator());
                p -= 3;
            }
        }
        if (signum < 0) {
            sb.insert(0, '-');
        }
        return sb.toString();
    }

    public static String shorten(String in, int maxLength) {
        if (in == null) {
            return null;
        }
        if (in.length() <= maxLength) {
            return in;
        }
        return in.substring(0, maxLength);
    }

    public static String trimAndUpperCase(String s) {
        if ((s = StringUtils.trim(s)) != null) {
            return s.toUpperCase();
        }
        return null;
    }

    public static String trim(String s) {
        if (s != null) {
            return s.trim();
        }
        return null;
    }

    public static String removeAllWhitespace(String s) {
        if (s != null) {
            return s.replaceAll("\\s", "").trim();
        }
        return null;
    }

    public static boolean check(String toTest, RegularExpressions regexp) {
        return regexp.getPattern().matcher(toTest).matches();
    }

    public static String capitalize(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private static String formatSize(long size, long divider, String unitName, Locale locale) {
        return PaymentUtils.formatBigDecimal(new BigDecimal((double)size / (double)divider), locale, 2) + " " + unitName;
    }

    public static String toHumanReadableBinaryPrefixes(long size, Locale locale) {
        if (size < 0L) {
            throw new IllegalArgumentException("Invalid file size: " + size);
        }
        if (size >= EiB) {
            return StringUtils.formatSize(size, EiB, "EiB", locale);
        }
        if (size >= PiB) {
            return StringUtils.formatSize(size, PiB, "PiB", locale);
        }
        if (size >= TiB) {
            return StringUtils.formatSize(size, TiB, "TiB", locale);
        }
        if (size >= GiB) {
            return StringUtils.formatSize(size, GiB, "GiB", locale);
        }
        if (size >= MiB) {
            return StringUtils.formatSize(size, MiB, "MiB", locale);
        }
        if (size >= KiB) {
            return StringUtils.formatSize(size, KiB, "KiB", locale);
        }
        return StringUtils.formatSize(size, BYTE, "Bytes", locale);
    }
}

