/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.util;

import de.businesslogics.gui.ConfigProperty;
import de.businesslogics.gui.Configurable;
import de.businesslogics.gui.Cryptor;
import de.businesslogics.gui.NoCryptor;
import de.businesslogics.task.Substitution;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PropertyUtil {
    protected static Logger LOGGER = Logger.getLogger(PropertyUtil.class.getName());

    private static void setProperty(Object o, String property, String value, boolean encrypted) {
        try {
            Class<?> type;
            Class<?> c = o.getClass();
            Field f = c.getField(property);
            if (encrypted) {
                ConfigProperty cp = f.getAnnotation(ConfigProperty.class);
                Class<? extends Cryptor> cryptorClass = cp.cryptor();
                value = cryptorClass.newInstance().decrypt(c, f, value);
            }
            if ((type = f.getType()).isEnum()) {
                Object v;
                if (value != null && value.length() > 0) {
                    Method m = type.getMethod("valueOf", String.class);
                    v = m.invoke(null, value);
                } else {
                    v = null;
                }
                f.set(o, v);
            } else if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                f.set(o, Boolean.valueOf(value));
            } else if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
                f.set(o, Byte.valueOf(value));
            } else if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                f.set(o, Integer.valueOf(value));
            } else if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                f.set(o, value == null ? null : Long.valueOf(value));
            } else {
                f.set(o, value);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Property not found", e);
        }
    }

    public static void setState(Object o, String state) {
        if (state == null) {
            return;
        }
        try {
            if (state.startsWith("#")) {
                Class<?> c = o.getClass();
                Configurable cr = c.getAnnotation(Configurable.class);
                Class<? extends Cryptor> cryptorClass = cr.cryptor();
                state = cryptorClass.newInstance().decrypt(c, null, state.substring(1));
            }
            int pos = 0;
            while (state.length() > pos) {
                String value;
                boolean encrypted;
                char c;
                int il = state.indexOf(64, pos);
                String property = state.substring(pos, il);
                int l = 0;
                int ir = il;
                while ((c = state.charAt(++ir)) >= '0' && c <= '9') {
                    l = l * 10 + (c - 48);
                }
                boolean bl = encrypted = c == '#';
                if (!encrypted && c != '@') {
                    throw new IllegalArgumentException("Number terminated by " + c);
                }
                if (ir == il + 1) {
                    value = null;
                    pos = ir + 1;
                } else {
                    pos = ir + 1 + l;
                    value = state.substring(ir + 1, pos);
                }
                PropertyUtil.setProperty(o, property, value, encrypted);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getValue(String state, String name) {
        if (state == null) {
            return null;
        }
        int pos = 0;
        while (state.length() > pos) {
            try {
                String value;
                int il = state.indexOf(64, pos);
                String property = state.substring(pos, il);
                int ir = state.indexOf(64, il + 1);
                if (ir == il + 1) {
                    value = null;
                    pos = ir + 1;
                } else {
                    int l = Integer.valueOf(state.substring(il + 1, ir));
                    pos = ir + 1 + l;
                    value = state.substring(ir + 1, pos);
                }
                if (!property.equals(name)) continue;
                return value;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static String getState(Object o) {
        if (o == null) {
            return "";
        }
        Class<?> c = o.getClass();
        StringBuilder state = new StringBuilder();
        try {
            Class<? extends Cryptor> cryptorClass;
            for (Field f : c.getFields()) {
                ConfigProperty cp = f.getAnnotation(ConfigProperty.class);
                if (cp == null) continue;
                String name = f.getName();
                Object value = f.get(o);
                state.append(name);
                String s = value == null ? null : value.toString();
                Class<? extends Cryptor> cryptorClass2 = cp.cryptor();
                char endChar = '@';
                if (!NoCryptor.class.equals(cryptorClass2)) {
                    s = cryptorClass2.newInstance().encrypt(c, f, s);
                    endChar = '#';
                }
                if (s != null) {
                    state.append('@');
                    state.append(s.length());
                    state.append(endChar);
                    state.append(s);
                    continue;
                }
                state.append('@').append(endChar);
            }
            Object s = state.toString();
            Configurable cr = c.getAnnotation(Configurable.class);
            if (cr != null && !NoCryptor.class.equals(cryptorClass = cr.cryptor())) {
                s = "#" + cryptorClass.newInstance().encrypt(c, null, (String)s);
            }
            return s;
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getProperty(Object o, String property, boolean useDefault, Object def) {
        int pos = 0;
        while (pos < property.length()) {
            Class<?> c = o.getClass();
            int i = pos;
            Method m = null;
            while (++i < property.length()) {
                char ch = property.charAt(i);
                if (ch == '(') {
                    int end = property.indexOf(41, i + 1);
                    if (end < 0) {
                        throw new IllegalArgumentException("Right parenthesis missing in " + property.substring(pos));
                    }
                    String key = property.substring(i + 1, end);
                    m = PropertyUtil.mkGetter(property, pos, i, c, String.class);
                    try {
                        o = m.invoke(o, key);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                    i = end + 1;
                    if (i >= property.length() || property.charAt(i) == '.') break;
                    throw new IllegalArgumentException("Dot expected after parenthesis");
                }
                if (ch != '.') continue;
                break;
            }
            if (m == null) {
                m = PropertyUtil.mkGetter(property, pos, i, c, new Class[0]);
                try {
                    o = m.invoke(o, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (o == null) {
                if (useDefault) {
                    return def;
                }
                if (property.length() > 0) {
                    throw new IllegalArgumentException("Property " + property.substring(pos, i) + " of class " + c.getName() + " is null.");
                }
            }
            pos = i + 1;
        }
        return o;
    }

    private static Method mkGetter(String s, int start, int end, Class<?> c, Class<?> ... methodArgs) {
        Object methodName = end > start ? "get" + Character.toUpperCase(s.charAt(start)) + s.substring(start + 1, end) : "get";
        try {
            return c.getMethod((String)methodName, methodArgs);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No getter for property " + s.substring(start, end) + " in class " + c.getName());
        }
    }

    public static Map<String, String> readProperties(String input, Substitution substitution) {
        if (StringUtils.isEmpty(input)) {
            return Collections.emptyMap();
        }
        Properties properties = new Properties();
        try {
            properties.load(new StringReader(input));
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected exception loading variables input '" + input + "'", e);
        }
        if (properties.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> toReturn = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = String.valueOf(entry.getKey());
            String value = String.valueOf(entry.getValue());
            if (substitution == null) {
                toReturn.put(key, value);
                continue;
            }
            toReturn.put(substitution.substitute(key), substitution.substitute(value));
        }
        return Collections.unmodifiableMap(toReturn);
    }
}

