/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.util;

import de.businesslogics.iban.IbanUtil;
import de.businesslogics.util.Currency;
import de.businesslogics.util.StringUtils;
import de.businesslogics.validation.RegularExpressions;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public class PaymentUtils {
    private static final Pattern BIC_PATTERN = RegularExpressions.BIC.getPattern();
    private static final Pattern BLZ_PATTERN = RegularExpressions.GERMAN_BANK_CODE.getPattern();
    private static final Pattern GERMAN_ACCOUNT_NUMBER = RegularExpressions.GERMAN_ACCOUNT_NUMBER.getPattern();
    private static Map<Locale, Map<String, String>> countryNameMap;
    private static final char[] CFONB_CHARS;
    private static final char[] SEPA_CHARS;
    private static final char[] SEPA_AND_DTAUS_CHARS;
    private static final char[] SEPA_FOREIGN_CHARS;

    public static String formatAmount(BigDecimal amount, java.util.Currency currency) {
        return PaymentUtils.formatAmount(amount, currency, Locale.getDefault());
    }

    public static String formatAmount(BigDecimal amount, Currency currency) {
        return PaymentUtils.formatAmount(amount, currency, Locale.getDefault());
    }

    public static String formatAmount(BigDecimal amount, java.util.Currency currency, Locale l) {
        Currency blCurrency = null;
        if (currency != null) {
            blCurrency = Currency.getInstance(currency.getCurrencyCode());
        }
        return PaymentUtils.formatAmount(amount, blCurrency, currency == null ? 2 : currency.getDefaultFractionDigits(), l);
    }

    public static String formatAmount(BigDecimal amount, Currency currency, Locale l) {
        if (amount == null) {
            return "";
        }
        return PaymentUtils.formatAmount(amount, currency, currency == null ? 2 : currency.getDefaultFractionDigits(), l);
    }

    public static String formatAmount(BigDecimal amount, java.util.Currency currency, int fractionDigits) {
        Currency blCurrency = null;
        if (currency != null) {
            blCurrency = Currency.getInstance(currency.getCurrencyCode());
        }
        return PaymentUtils.formatAmount(amount, blCurrency, fractionDigits, Locale.getDefault());
    }

    public static String formatAmount(BigDecimal amount, Currency currency, int fractionDigits, Locale l) {
        if (amount == null) {
            return "";
        }
        NumberFormat nf = NumberFormat.getNumberInstance(l);
        nf.setMinimumFractionDigits(fractionDigits);
        Object s = nf.format(amount);
        if (currency != null) {
            s = (String)s + " " + currency.getCurrencyCode();
        }
        return s;
    }

    public static String convertAmount(BigDecimal bg) {
        StringBuilder temp = new StringBuilder(bg.toString());
        int index = temp.lastIndexOf(".");
        if (index != -1) {
            temp.setCharAt(index, ',');
        } else {
            temp.append(',');
        }
        return temp.toString();
    }

    public static String removeInvalidBigDecimalValues(String amount, Locale locale) {
        if (amount.startsWith("-")) {
            return "-" + PaymentUtils.removeNonBigDecimalValues(amount.substring(1), locale);
        }
        return PaymentUtils.removeNonBigDecimalValues(amount, locale);
    }

    public static String removeNonBigDecimalValues(String amount, Locale locale) {
        DecimalFormat nf = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        char sep = nf.getDecimalFormatSymbols().getDecimalSeparator();
        StringBuilder b = new StringBuilder(amount.length());
        for (int i = 0; i < amount.length(); ++i) {
            char c = amount.charAt(i);
            if (!Character.isDigit(c) && sep != c) continue;
            b.append(c);
        }
        return b.toString();
    }

    public static BigDecimal parseAmount(String amount, Locale locale) {
        DecimalFormat nf = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        char c = nf.getDecimalFormatSymbols().getDecimalSeparator();
        char x = nf.getDecimalFormatSymbols().getGroupingSeparator();
        amount = amount.replaceAll("\\" + x, "");
        amount = amount.replace(c, '.');
        return new BigDecimal(amount);
    }

    public static String formatBigDecimal(BigDecimal amount, Locale locale, int fraction) {
        DecimalFormat nf = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        if (amount == null) {
            return "";
        }
        amount = amount.setScale(fraction, 4);
        nf.setMaximumFractionDigits(fraction);
        nf.setMinimumFractionDigits(fraction);
        return nf.format(amount);
    }

    public static String formatExchangeRate(BigDecimal amount, Locale locale) {
        int maxNumberOfDecimalPlaces = 10;
        String s = PaymentUtils.formatBigDecimal(amount, locale, maxNumberOfDecimalPlaces);
        int origLength = s.length();
        while (s.endsWith("0")) {
            s = s.substring(0, s.length() - 1);
        }
        if (s.length() == origLength - maxNumberOfDecimalPlaces && s.length() > 1) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static char[] prefillWithZeros(int length, int toFill) {
        char[] temp = Integer.toString(toFill).toCharArray();
        char[] filled = new char[length];
        for (int i = 0; i < length; ++i) {
            filled[i] = 48;
        }
        System.arraycopy(temp, 0, filled, length - temp.length, temp.length);
        return filled;
    }

    public static boolean isRibValid(String rib) {
        StringBuilder extendedRib = new StringBuilder(rib.length());
        for (char currentChar : rib.toCharArray()) {
            int currentCharValue = Character.digit(currentChar, 36);
            extendedRib.append(currentCharValue < 10 ? currentCharValue : (currentCharValue + (int)StrictMath.pow(2.0, (double)(currentCharValue - 10) / 9.0)) % 10);
        }
        return new BigDecimal(extendedRib.toString()).remainder(new BigDecimal(97)).intValue() == 0;
    }

    public static int calculateRibKey(String bankCode, String branchCode, String accNumber) {
        int b = Integer.parseInt(bankCode);
        int g = Integer.parseInt(branchCode);
        long c = Long.parseLong(PaymentUtils.convertCharsToDigits(accNumber));
        return (int)(97L - ((long)(89 * b + 15 * g) + 3L * c) % 97L);
    }

    public static String getRib(String bankCode, String branchCode, String accNumber, String ribKey, char separator) {
        StringBuffer sb = new StringBuffer();
        sb.append(bankCode);
        sb.append(separator);
        sb.append(branchCode);
        sb.append(separator);
        sb.append(accNumber);
        sb.append(separator);
        if (ribKey == null || ribKey.trim().length() == 0) {
            int key = PaymentUtils.calculateRibKey(bankCode, branchCode, accNumber);
            if (key < 10) {
                sb.append('0');
            }
            sb.append(key);
        } else {
            sb.append(ribKey);
        }
        return sb.toString();
    }

    public static String getRib(String bankCode, String branchCode, String accNumber) {
        StringBuilder sb = new StringBuilder();
        if (bankCode.length() < 5) {
            bankCode = StringUtils.fillUpFromLeft(bankCode, '0', 5);
        }
        sb.append(bankCode);
        if (branchCode.length() < 5) {
            branchCode = StringUtils.fillUpFromLeft(bankCode, '0', 5);
        }
        sb.append(branchCode);
        if (accNumber.length() < 11) {
            accNumber = StringUtils.fillUpFromLeft(accNumber, '0', 11);
        }
        sb.append(accNumber);
        int key = PaymentUtils.calculateRibKey(bankCode, branchCode, accNumber);
        if (key < 10) {
            sb.append('0');
        }
        sb.append(key);
        return sb.toString();
    }

    private static String convertCharsToDigits(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            sb.append(PaymentUtils.convertCharToDigit(s.charAt(i)));
        }
        return sb.toString();
    }

    private static int convertCharToDigit(char c) {
        int currentCharValue = Character.digit(c, 36);
        if (currentCharValue < 10) {
            return currentCharValue;
        }
        return (currentCharValue + (int)StrictMath.pow(2.0, (double)(currentCharValue - 10) / 9.0)) % 10;
    }

    public static String getCFONBString(String s, int maxLength) {
        if (s == null) {
            return null;
        }
        s = s.toUpperCase();
        s = PaymentUtils.replaceFrenchUppercaseCharacters(s);
        if ((s = PaymentUtils.replaceInvalidCharsByBlanks(s, CFONB_CHARS)).length() > maxLength) {
            return s.substring(0, maxLength);
        }
        return s;
    }

    public static String getSEPAStringForGUI(String s, int maxLength) {
        if (s == null) {
            return null;
        }
        s = PaymentUtils.replaceFrenchUppercaseCharacters(s);
        s = PaymentUtils.replaceFrenchLowercaseCharacters(s);
        s = PaymentUtils.replaceInvalidCharsByBlanks(s, SEPA_AND_DTAUS_CHARS);
        return PaymentUtils.getStringWithValidLength(s, maxLength);
    }

    public static String getSEPAForeignStringForGUI(String s, int maxLength) {
        if (s == null) {
            return null;
        }
        s = PaymentUtils.replaceGermanUmlauts(s);
        s = PaymentUtils.replaceFrenchUppercaseCharacters(s);
        s = PaymentUtils.replaceFrenchLowercaseCharacters(s);
        s = PaymentUtils.replaceInvalidCharsByBlanks(s, SEPA_FOREIGN_CHARS);
        return PaymentUtils.getStringWithValidLength(s, maxLength);
    }

    public static String getExtendedSEPAString(String s, int maxLength) {
        if (s == null) {
            return null;
        }
        s = PaymentUtils.replaceInvalidCharsByBlanks(s, SEPA_AND_DTAUS_CHARS);
        return PaymentUtils.getStringWithValidLength(s, maxLength);
    }

    public static String getBaseSEPAString(String s, int maxLength) {
        if (s == null) {
            return null;
        }
        s = PaymentUtils.replaceGermanUmlauts(s);
        s = PaymentUtils.replaceInvalidCharsByBlanks(s, SEPA_CHARS);
        return PaymentUtils.getStringWithValidLength(s, maxLength);
    }

    public static String getSWIFTString(String s, int maxLength) {
        return PaymentUtils.getBaseSEPAString(s, maxLength);
    }

    private static String getStringWithValidLength(String s, int maxLength) {
        if (s.length() > maxLength) {
            return s.substring(0, maxLength);
        }
        return s;
    }

    private static String replaceInvalidCharsByBlanks(String s, char[] validCharacters) {
        for (int i = 0; i < s.length(); ++i) {
            if (Arrays.binarySearch(validCharacters, s.charAt(i)) >= 0) continue;
            s = s.replace(s.charAt(i), ' ');
        }
        return s;
    }

    public static String containsNonSepaChar(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Arrays.binarySearch(SEPA_CHARS, s.charAt(i)) >= 0) continue;
            return String.valueOf(s.charAt(i));
        }
        return null;
    }

    public static String containsNonSepaAndDtausChar(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Arrays.binarySearch(SEPA_AND_DTAUS_CHARS, s.charAt(i)) >= 0) continue;
            return String.valueOf(s.charAt(i));
        }
        return null;
    }

    public static String containsNonSepaForeignChar(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Arrays.binarySearch(SEPA_FOREIGN_CHARS, s.charAt(i)) >= 0) continue;
            return String.valueOf(s.charAt(i));
        }
        return null;
    }

    private static String replaceGermanUmlauts(String s) {
        s = s.replaceAll("\u00c4", "AE");
        s = s.replaceAll("\u00e4", "ae");
        s = s.replaceAll("\u00d6", "OE");
        s = s.replaceAll("\u00f6", "oe");
        s = s.replaceAll("\u00dc", "UE");
        s = s.replaceAll("\u00fc", "ue");
        s = s.replaceAll("\u00df", "ss");
        return s;
    }

    private static String replaceFrenchUppercaseCharacters(String s) {
        s = s.replaceAll("\u00c1", "A");
        s = s.replaceAll("\u00c0", "A");
        s = s.replaceAll("\u00c2", "A");
        s = s.replaceAll("\u00c6", "AE");
        s = s.replaceAll("\u00c7", "C");
        s = s.replaceAll("\u00c9", "E");
        s = s.replaceAll("\u00c8", "E");
        s = s.replaceAll("\u00ca", "E");
        s = s.replaceAll("\u00cb", "E");
        s = s.replaceAll("\u00cd", "I");
        s = s.replaceAll("\u00cc", "I");
        s = s.replaceAll("\u00ce", "I");
        s = s.replaceAll("\u00cf", "I");
        s = s.replaceAll("\u00d3", "O");
        s = s.replaceAll("\u00d2", "O");
        s = s.replaceAll("\u00d4", "O");
        s = s.replaceAll("\u0152", "OE");
        s = s.replaceAll("\u00da", "U");
        s = s.replaceAll("\u00d9", "U");
        s = s.replaceAll("\u00db", "U");
        s = s.replaceAll("\u0178", "Y");
        return s;
    }

    private static String replaceFrenchLowercaseCharacters(String s) {
        s = s.replaceAll("\u00e1", "a");
        s = s.replaceAll("\u00e0", "a");
        s = s.replaceAll("\u00e2", "a");
        s = s.replaceAll("\u00e6", "ae");
        s = s.replaceAll("\u00e7", "c");
        s = s.replaceAll("\u00e9", "e");
        s = s.replaceAll("\u00e8", "e");
        s = s.replaceAll("\u00ea", "e");
        s = s.replaceAll("\u00eb", "e");
        s = s.replaceAll("\u00ed", "i");
        s = s.replaceAll("\u00ec", "i");
        s = s.replaceAll("\u00ee", "i");
        s = s.replaceAll("\u00ef", "i");
        s = s.replaceAll("\u00f3", "o");
        s = s.replaceAll("\u00f2", "o");
        s = s.replaceAll("\u00f4", "o");
        s = s.replaceAll("\u0153", "oe");
        s = s.replaceAll("\u00fa", "u");
        s = s.replaceAll("\u00f9", "u");
        s = s.replaceAll("\u00fb", "u");
        s = s.replaceAll("\u00ff", "y");
        return s;
    }

    @Deprecated
    public static String getCountryName(String countryCode) {
        return PaymentUtils.getCountryName(countryCode, Locale.getDefault());
    }

    @Deprecated
    public static String getCountryName(String countryCode, Locale locale) {
        String countryName;
        if (countryCode == null) {
            return null;
        }
        if (countryNameMap == null) {
            countryNameMap = new HashMap<Locale, Map<String, String>>();
        }
        if (!countryNameMap.containsKey(locale)) {
            HashMap<String, String> tmp = new HashMap<String, String>();
            for (String isoCode : Locale.getISOCountries()) {
                String name = new Locale(isoCode, isoCode).getDisplayCountry(locale);
                tmp.put(isoCode, name);
            }
            countryNameMap.put(locale, tmp);
        }
        return (countryName = countryNameMap.get(locale).get(countryCode)) != null ? countryName : countryCode;
    }

    public static boolean isGermanAccountNumber(String accountNumber) {
        return PaymentUtils.matchesPattern(accountNumber, GERMAN_ACCOUNT_NUMBER);
    }

    public static boolean isGermanBLZ(String bankCode) {
        return PaymentUtils.matchesPattern(bankCode, BLZ_PATTERN);
    }

    public static boolean isBIC(String bankCode) {
        return PaymentUtils.matchesPattern(bankCode, BIC_PATTERN);
    }

    private static boolean matchesPattern(String s, Pattern pattern) {
        return s != null && pattern.matcher(s).matches();
    }

    public static boolean isBundesbank(String iban) {
        if (iban != null && iban.startsWith("DE") && iban.length() >= 22) {
            return iban.charAt(7) == '0';
        }
        return false;
    }

    public static boolean isISO11649CreditorReference(String reference) {
        return IbanUtil.isISO11649Reference(reference);
    }

    public static boolean isSwissQRReference(String reference) {
        if (reference == null || !RegularExpressions.SWISS_REFERENCE_NUMBER.matches(reference)) {
            return false;
        }
        int countDigits = reference.length();
        if (countDigits > 0) {
            int checkDigit = Character.getNumericValue(reference.charAt(countDigits - 1));
            int expectedCheckDigit = PaymentUtils.calculateMod10CheckDigit(reference);
            return expectedCheckDigit == checkDigit;
        }
        return false;
    }

    private static int calculateMod10CheckDigit(String reference) {
        int[] numberArray = new int[]{0, 9, 4, 6, 8, 2, 7, 1, 3, 5};
        int carryOver = 0;
        for (int i = 0; i < reference.length() - 1; ++i) {
            int digit = Character.getNumericValue(reference.charAt(i));
            carryOver = numberArray[(carryOver + digit) % 10];
        }
        return 10 - carryOver % 10;
    }

    public static void main(String[] args) {
        String bankCode = "30478";
        String branchCode = "00013";
        String accNumber = "05382911001";
        int ribKey = PaymentUtils.calculateRibKey(bankCode, branchCode, accNumber);
        System.out.println("Bank code = '" + bankCode + "' Branch code = '" + branchCode + "' Account number = '" + accNumber);
        System.out.println("RibKey = " + ribKey);
        String rib = PaymentUtils.getRib(bankCode, branchCode, accNumber);
        System.out.println("RIB = " + rib);
        System.out.println("German Amounts");
        System.out.println(PaymentUtils.formatAmount(new BigDecimal("-47.11"), java.util.Currency.getInstance("EUR"), Locale.GERMAN));
        System.out.println(PaymentUtils.formatAmount(new BigDecimal("-47.11"), Currency.getInstance("EUR"), Locale.GERMAN));
        System.out.println(PaymentUtils.formatAmount(new BigDecimal("-47.11"), java.util.Currency.getInstance("EUR"), Locale.GERMANY));
        System.out.println(PaymentUtils.formatAmount(new BigDecimal("-47.11"), Currency.getInstance("EUR"), Locale.GERMANY));
        System.out.println(PaymentUtils.formatAmount(new BigDecimal("-47.11"), java.util.Currency.getInstance("EUR")));
        System.out.println(PaymentUtils.formatAmount(new BigDecimal("-47.11"), Currency.getInstance("EUR")));
        System.out.println("English Amounts");
        System.out.println(PaymentUtils.formatAmount(new BigDecimal("-47.11"), java.util.Currency.getInstance("EUR"), Locale.ENGLISH));
        System.out.println(PaymentUtils.formatAmount(new BigDecimal("-47.11"), Currency.getInstance("EUR"), Locale.ENGLISH));
        System.out.println(PaymentUtils.formatAmount(new BigDecimal("-47.11"), java.util.Currency.getInstance("EUR"), Locale.UK));
        System.out.println(PaymentUtils.formatAmount(new BigDecimal("-47.11"), Currency.getInstance("EUR"), Locale.UK));
        System.out.println(PaymentUtils.formatAmount(new BigDecimal("-47.11"), java.util.Currency.getInstance("EUR"), Locale.US));
        System.out.println(PaymentUtils.formatAmount(new BigDecimal("-47.11"), Currency.getInstance("EUR"), Locale.US));
    }

    static {
        CFONB_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', ' ', '.', '-', '/', '(', ')', '*'};
        SEPA_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', ' ', '.', '-', '/', '(', ')', '+', ',', '?', ':', '\''};
        SEPA_AND_DTAUS_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', ' ', '.', '-', '/', '(', ')', '+', ',', '?', ':', '\'', '\u00c4', '\u00e4', '\u00d6', '\u00f6', '\u00dc', '\u00fc', '\u00df', '&', '*', '$', '%'};
        SEPA_FOREIGN_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', ' ', '.', '-', '/', '(', ')', '+', ',', '?', ':', '\'', '&', '<', '>', '@'};
        Arrays.sort(CFONB_CHARS);
        Arrays.sort(SEPA_CHARS);
        Arrays.sort(SEPA_AND_DTAUS_CHARS);
        Arrays.sort(SEPA_FOREIGN_CHARS);
    }
}

