/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.util;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.xml.sax.SAXException;

public class LogUtils {
    private static final Class<?> servletException;
    private static final Method rootCauseMethod;
    private static final Class<?> facesException;
    private static final Method facesCauseMethod;

    public static void logp(Object c, Level level, String methodName, String message, Throwable t) {
        String className = c == null ? "na" : (c instanceof Class ? ((Class)c).getName() : c.getClass().getName());
        Logger logger = Logger.getLogger(className);
        LogUtils.logp(logger, level, className, methodName, message, t);
    }

    public static void logp(Logger logger, Level level, String className, String methodName, String message, Throwable t) {
        if (t != null) {
            LogUtils.logCause(logger, className, methodName, t);
        }
        logger.logp(level, className, methodName, message, t);
    }

    private static void logCause(Logger logger, String className, String methodName, Throwable t) {
        Throwable cause = LogUtils.getCause(t);
        if (cause == null) {
            return;
        }
        LogUtils.logCause(logger, className, methodName, cause);
        logger.logp(Level.FINER, className, methodName, "Cause of the next exception", cause);
    }

    public static Throwable getCause(Throwable t) {
        Throwable cause = t.getCause();
        if (cause != null) {
            return cause;
        }
        if (t instanceof SAXException && (cause = ((SAXException)t).getException()) != null) {
            return cause;
        }
        if (servletException != null && servletException.isInstance(t)) {
            try {
                cause = (Throwable)rootCauseMethod.invoke((Object)t, (Object[])null);
                if (cause != null) {
                    return cause;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (facesException != null && facesException.isInstance(t)) {
            try {
                cause = (Throwable)facesCauseMethod.invoke((Object)t, (Object[])null);
                if (cause != null) {
                    return cause;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isCauseRecord(LogRecord record) {
        return record.getThrown() != null && Level.FINER.equals(record.getLevel()) && "Cause of the next exception".equals(record.getMessage());
    }

    static {
        Method m;
        Class<?> c;
        try {
            c = Class.forName("jakarta.servlet.ServletException");
            m = c.getDeclaredMethod("getRootCause", null);
        }
        catch (Exception e) {
            c = null;
            m = null;
        }
        servletException = c;
        rootCauseMethod = m;
        try {
            c = Class.forName("jakarta.faces.FacesException");
            m = c.getDeclaredMethod("getCause", null);
        }
        catch (Exception e) {
            c = null;
            m = null;
        }
        facesException = c;
        facesCauseMethod = m;
    }
}

