/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.util;

import java.io.IOException;
import java.io.OutputStream;

public class HexTool {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private HexTool() {
    }

    public static int charValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Not a number '" + c + "'");
    }

    public static byte[] fromHex(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Hex string must not be null!");
        }
        if (s.length() % 2 != 0) {
            throw new IllegalArgumentException("Odd number of hex digits");
        }
        byte[] b = new byte[s.length() / 2];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)(HexTool.charValue(s.charAt(i * 2)) << 4 | HexTool.charValue(s.charAt(i * 2 + 1)));
        }
        return b;
    }

    public static String toHex(byte[] bytes, int offset, int length, boolean withBlanks) {
        if (bytes == null) {
            return "null";
        }
        if (offset + length > bytes.length) {
            length = bytes.length - offset;
        }
        int size = length * 2;
        if (withBlanks) {
            size += length - 1;
        }
        char[] c = new char[size];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            int b = bytes[offset + i] & 0xFF;
            c[j++] = DIGITS[b >> 4];
            c[j++] = DIGITS[b & 0xF];
            if (!withBlanks || i >= length - 1) continue;
            c[j++] = 32;
        }
        return new String(c);
    }

    public static String toHex(byte[] bytes, int offset, int length) {
        return HexTool.toHex(bytes, offset, length, false);
    }

    public static String toHex(byte[] bytes, boolean withBlanks) {
        if (bytes == null) {
            return "null";
        }
        return HexTool.toHex(bytes, 0, bytes.length, withBlanks);
    }

    public static String toHex(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        return HexTool.toHex(bytes, 0, bytes.length);
    }

    public static void printHex(byte[] bytes, OutputStream out) throws IOException {
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            out.write(DIGITS[b >> 4]);
            out.write(DIGITS[b & 0xF]);
        }
    }

    public static byte[] stripZeros(byte[] input) {
        int i;
        for (i = 0; i < input.length && input[i] == 0; ++i) {
        }
        if (i == 0) {
            return input;
        }
        byte[] toReturn = new byte[input.length - i];
        System.arraycopy(input, i, toReturn, 0, toReturn.length);
        return toReturn;
    }

    public static int hashCode(byte[] b) {
        int toReturn = 0;
        int i = b.length;
        while (--i >= 0) {
            toReturn = (toReturn << 8) + i + b[i];
        }
        return toReturn;
    }

    public static boolean equals(byte[] a, int aOffset, byte[] b, int bOffset, int length) {
        length += aOffset;
        while (aOffset < length) {
            if (a[aOffset++] == b[bOffset++]) continue;
            return false;
        }
        return true;
    }
}

