/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.util;

import java.util.Calendar;
import java.util.Date;

public final class DateUtils {
    private DateUtils() {
    }

    public static Date deleteTime(Date newDate) {
        if (newDate == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(newDate);
        Calendar toReturn = Calendar.getInstance();
        toReturn.clear();
        toReturn.set(cal.get(1), cal.get(2), cal.get(5));
        return toReturn.getTime();
    }

    public static Date addTime(Date newDate) {
        if (newDate == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(newDate);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static Date resetTimeStamp(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        DateUtils.resetTimeStamp(cal);
        return cal.getTime();
    }

    public static Date getCurrentDateWithoutTimeStamp() {
        return DateUtils.getCurrentCalendarWithoutTimeStamp().getTime();
    }

    public static Calendar getCurrentCalendarWithoutTimeStamp() {
        Calendar cal = Calendar.getInstance();
        DateUtils.resetTimeStamp(cal);
        return cal;
    }

    private static void resetTimeStamp(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    public static Calendar getEasterSunday(int year) {
        int k = year / 100;
        int m = 15 + (3 * k + 3) / 4 - (8 * k + 13) / 25;
        int s = 2 - (3 * k + 3) / 4;
        int a = year % 19;
        int d = (19 * a + m) % 30;
        int r = d / 29 + (d / 28 - d / 29) * a / 11;
        int og = 21 + d - r;
        int sz = 7 - (year + year / 4 + s) % 7;
        int oe = 7 - (og - sz) % 7;
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(year, 2, og + oe);
        return c;
    }

    public static boolean doFitDayOfMonths(Calendar c1, Calendar c2) {
        boolean doDaysFit = false;
        int dayOfC1Month = c1.get(5);
        int dayOfC2Month = c2.get(5);
        int lastDayOfC1Month = DateUtils.getLastDayOfMonth(c1);
        int lastDayOfC2Month = DateUtils.getLastDayOfMonth(c2);
        if (dayOfC1Month == dayOfC2Month) {
            doDaysFit = true;
        } else if (dayOfC1Month == lastDayOfC1Month) {
            if (dayOfC2Month == lastDayOfC2Month) {
                doDaysFit = true;
            } else if (dayOfC2Month >= dayOfC1Month) {
                doDaysFit = true;
            }
        } else if (dayOfC2Month == lastDayOfC2Month && dayOfC2Month <= dayOfC1Month) {
            doDaysFit = true;
        }
        return doDaysFit;
    }

    public static boolean isLeapYear(int year) {
        if (year % 4 > 0) {
            return false;
        }
        return year % 100 != 0 || year % 400 == 0;
    }

    public static int getLastDayOfMonth(Calendar c) {
        switch (c.get(2)) {
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: {
                if (DateUtils.isLeapYear(c.get(1))) {
                    return 29;
                }
                return 28;
            }
        }
        return 31;
    }

    public static Calendar getTargetDay(Calendar c) {
        while (DateUtils.isTargetHoliday(c)) {
            c.add(5, 1);
        }
        return c;
    }

    public static Calendar getMonthUltimoTargetDay(Calendar c) {
        c.set(5, DateUtils.getLastDayOfMonth(c));
        while (DateUtils.isTargetHoliday(c)) {
            c.add(5, -1);
        }
        return c;
    }

    public static Calendar getQuarterUltimoTargetDay(Calendar c) {
        switch (c.get(2)) {
            case 0: 
            case 1: {
                c.set(5, 1);
                c.set(2, 2);
                break;
            }
            case 3: 
            case 4: {
                c.set(5, 1);
                c.set(2, 5);
                break;
            }
            case 6: 
            case 7: {
                c.set(5, 1);
                c.set(2, 8);
                break;
            }
            case 9: 
            case 10: {
                c.set(5, 1);
                c.set(2, 11);
                break;
            }
        }
        c.set(5, DateUtils.getLastDayOfMonth(c));
        while (DateUtils.isTargetHoliday(c)) {
            c.add(5, -1);
        }
        return c;
    }

    public static Calendar getYearsUltimoTargetDay(Calendar c) {
        c.set(2, 11);
        c.set(5, 31);
        while (DateUtils.isTargetHoliday(c)) {
            c.add(5, -1);
        }
        return c;
    }

    public static Calendar addWorkingDays(Calendar in, int days) {
        int forward = 0;
        while (forward < days) {
            in.add(5, 1);
            if (DateUtils.isTargetHoliday(in)) continue;
            ++forward;
        }
        return in;
    }

    public static Calendar getNextWorkingDay(Calendar in) {
        while (DateUtils.isTargetHoliday(in)) {
            in.add(5, 1);
        }
        return in;
    }

    public static Calendar getPreviousWorkingDay(Calendar in) {
        while (DateUtils.isTargetHoliday(in)) {
            in.add(5, -1);
        }
        return in;
    }

    public static boolean isTargetHoliday(Calendar c) {
        if (c.get(7) == 7 || c.get(7) == 1) {
            return true;
        }
        if (c.get(5) == 1 && c.get(2) == 0) {
            return true;
        }
        Calendar easterSunday = DateUtils.getEasterSunday(c.get(1));
        if (easterSunday.get(6) - 2 == c.get(6)) {
            return true;
        }
        if (easterSunday.get(6) + 1 == c.get(6)) {
            return true;
        }
        if (c.get(5) == 1 && c.get(2) == 4) {
            return true;
        }
        return c.get(2) == 11 && (c.get(5) == 25 || c.get(5) == 26);
    }

    public static boolean isSameDay(Calendar c1, Calendar c2) {
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.get(6) == c2.get(6) && c1.get(1) == c2.get(1) && c1.get(0) == c2.get(0);
    }

    public static boolean isSameDay(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return false;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(d1);
        int e = c.get(0);
        int y = c.get(1);
        int d = c.get(6);
        c.setTime(d2);
        return d == c.get(6) && y == c.get(1) && e == c.get(0);
    }
}

