/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Currency
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<String, Currency> INSTANCES = new HashMap<String, Currency>();
    private static final Set<Currency> INTERNAL_CURRENCIES = new HashSet<Currency>();
    private static final Set<Currency> PUBLIC_CURRENCIES;
    private final String currencyCode;
    private final transient int defaultFractionDigits;

    public static Set<Currency> getAvailableCurrencies() {
        return PUBLIC_CURRENCIES;
    }

    public static Currency getInstance(String currencyCode) {
        if (currencyCode == null) {
            return null;
        }
        Currency toReturn = INSTANCES.get(currencyCode);
        if (toReturn != null) {
            return toReturn;
        }
        throw new IllegalArgumentException(currencyCode);
    }

    public static Currency getOrCreateInstance(String currencyCode) {
        Currency toReturn = INSTANCES.get(currencyCode);
        if (toReturn != null) {
            return toReturn;
        }
        return Currency.addCurrency(currencyCode, 2);
    }

    private static Currency addCurrency(String currencyCode, int fractionDigits) {
        if (currencyCode.trim().length() != 3) {
            throw new IllegalArgumentException(currencyCode);
        }
        Currency newCurrency = new Currency(currencyCode, fractionDigits);
        Currency oldCurrency = INSTANCES.put(currencyCode, newCurrency);
        if (oldCurrency != null) {
            INTERNAL_CURRENCIES.remove(oldCurrency);
        }
        INTERNAL_CURRENCIES.add(newCurrency);
        return newCurrency;
    }

    private Currency(String currencyCode, int fractionDigits) {
        this.currencyCode = currencyCode;
        this.defaultFractionDigits = fractionDigits;
    }

    public String toString() {
        return this.currencyCode;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public int getDefaultFractionDigits() {
        return this.defaultFractionDigits;
    }

    private Object readResolve() {
        return Currency.getInstance(this.currencyCode);
    }

    static {
        Set<java.util.Currency> currencies = java.util.Currency.getAvailableCurrencies();
        for (java.util.Currency cur : currencies) {
            Currency.addCurrency(cur.getCurrencyCode(), cur.getDefaultFractionDigits());
        }
        Currency.addCurrency("CNH", 2);
        PUBLIC_CURRENCIES = Collections.unmodifiableSet(INTERNAL_CURRENCIES);
    }
}

