/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ChangeAwareProperties
extends Properties {
    public static final long serialVersionUID = 1L;
    protected boolean changed = false;

    @Override
    public void load(InputStream is) throws IOException {
        super.load(is);
        this.changed = false;
    }

    @Override
    public Object setProperty(String key, String value) {
        Object toReturn = super.setProperty(key, value);
        this.changed |= !value.equals(toReturn);
        return toReturn;
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        Object toReturn = super.put(key, value);
        this.changed |= value == null ? toReturn != null : !value.equals(toReturn);
        return toReturn;
    }

    @Override
    public synchronized Object remove(Object key) {
        Object toReturn = super.remove(key);
        this.changed |= toReturn != null;
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void store(File f, String header) throws IOException {
        if (!this.changed) {
            return;
        }
        FileOutputStream fos = new FileOutputStream(f);
        try {
            super.store(fos, header);
            this.changed = false;
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException iOException) {}
        }
    }

    public int getInt(String key) {
        return Integer.parseInt(this.getProperty(key));
    }

    public int getInt(String key, int fallback) {
        String s = this.getProperty(key);
        if (s == null) {
            return fallback;
        }
        return Integer.parseInt(s);
    }

    public void setInt(String key, int value) {
        this.setProperty(key, Integer.toString(value));
    }

    public boolean getBoolean(String key) {
        return Boolean.parseBoolean(this.getProperty(key));
    }

    public boolean getBoolean(String key, boolean fallback) {
        String s = this.getProperty(key);
        if (s == null) {
            return fallback;
        }
        return Boolean.parseBoolean(s);
    }

    public void setBoolean(String key, boolean value) {
        this.setProperty(key, Boolean.toString(value));
    }

    public boolean isChanged() {
        return this.changed;
    }
}

