/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.util;

import java.io.ByteArrayOutputStream;
import java.util.Arrays;

public class Base64Util {
    private static final char[] ALPHABET = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] BITS = new byte[128];

    public static String encode(byte[] value) {
        int i = 0;
        StringBuilder sb = new StringBuilder();
        while (i < value.length) {
            int b = value[i] & 0xFF;
            sb.append(ALPHABET[b >> 2]);
            if (++i < value.length) {
                int n = (b & 3) << 4;
                b = value[i] & 0xFF;
                sb.append(ALPHABET[n | b >> 4]);
                if (++i < value.length) {
                    int n2 = (b & 0xF) << 2;
                    b = value[i] & 0xFF;
                    sb.append(ALPHABET[n2 | b >> 6]);
                    sb.append(ALPHABET[b & 0x3F]);
                    ++i;
                    continue;
                }
                sb.append(ALPHABET[(b & 0xF) << 2]);
                sb.append('=');
                continue;
            }
            sb.append(ALPHABET[(b & 3) << 4]);
            sb.append("==");
        }
        return sb.toString();
    }

    public static byte[] decode(String in) {
        int bufferPos = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        char[] buffer = new char[4];
        for (char c : in.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            if (c >= '\u0080' || BITS[c] == 64 && (c != '=' || bufferPos < 2)) {
                throw new IllegalArgumentException("Illegal base64 character: " + c);
            }
            buffer[bufferPos++] = c;
            if (bufferPos == -1) {
                throw new IllegalArgumentException("Unexpected base64 input");
            }
            if (bufferPos != 4) continue;
            bufferPos = 0;
            byte b1 = BITS[buffer[1]];
            bos.write(BITS[buffer[0]] << 2 | (b1 & 0x30) >> 4);
            if (buffer[2] != '=') {
                byte b2 = BITS[buffer[2]];
                bos.write((b1 & 0xF) << 4 | (b2 & 0x3C) >> 2);
                if (buffer[3] != '=') {
                    bos.write((b2 & 3) << 6 | BITS[buffer[3]]);
                    continue;
                }
                if ((b2 & 3) != 0) {
                    throw new IllegalArgumentException("Illegal padding");
                }
                bufferPos = -1;
                continue;
            }
            if ((b1 & 0xF) != 0 || buffer[3] != '=') {
                throw new IllegalArgumentException("Illegal padding");
            }
            bufferPos = -1;
        }
        return bos.toByteArray();
    }

    static {
        Arrays.fill(BITS, (byte)64);
        byte i = (byte)ALPHABET.length;
        while ((i = (byte)(i - 1)) >= 0) {
            Base64Util.BITS[Base64Util.ALPHABET[i]] = i;
        }
    }
}

