/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.task;

import de.businesslogics.util.PropertyUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Substitution {
    private static final Pattern DATE_MODIFIER_PATTERN = Pattern.compile("([+\\-])([\\d]+)([y,M,W,d,h,H,m,s,S])");
    private static final Map<Character, Integer> DATE_PATTERN_TO_CALENDAR_FIELD = new HashMap<Character, Integer>();
    private static final Logger LOGGER;
    private final HashMap<String, Object> placeHolders = new HashMap();
    private final HashMap<String, VariableSubstitution> variablePlaceHolders = new HashMap();
    protected MatchResult matcher;
    private String def;
    private boolean fortify;

    public Substitution() {
        this.variablePlaceHolders.put("DATE", new DateSubstitution());
    }

    public Substitution(Date date) {
        this.variablePlaceHolders.put("DATE", new DateSubstitution(date));
    }

    public Substitution(Substitution s) {
        this.placeHolders.putAll(s.placeHolders);
        this.variablePlaceHolders.putAll(s.variablePlaceHolders);
        this.matcher = s.matcher;
    }

    public void setMatcher(MatchResult m) {
        this.matcher = m;
    }

    public void addPlaceHolder(String key, Object value) {
        this.placeHolders.put(key, value);
    }

    public Map<String, Object> getPlaceHolders() {
        return Collections.unmodifiableMap(this.placeHolders);
    }

    public void addLateSubstitution(String key, String rawMessage) {
        this.addPlaceHolder(key, new LateSubstitution(rawMessage, this));
    }

    public void addDatePlaceHolder(String key, Date value) {
        this.variablePlaceHolders.put(key, new DateSubstitution(value));
    }

    public void addVariablePlaceHolder(String key, VariableSubstitution value) {
        this.variablePlaceHolders.put(key, value);
    }

    public Object getPlaceHolder(String key) {
        return this.placeHolders.get(key);
    }

    public String substitute(String rawMessage) {
        if (rawMessage == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(rawMessage.length());
        for (int i = 0; i < rawMessage.length(); ++i) {
            char c = rawMessage.charAt(i);
            if (c == '$' && i < rawMessage.length() - 1) {
                if ((c = rawMessage.charAt(++i)) == '$') {
                    sb.append(c);
                    continue;
                }
                if (c != '(') {
                    sb.append('$').append(c);
                    continue;
                }
                int first = i + 1;
                String tmp = this.replaceToken(rawMessage.substring(first, i = this.skipToken(rawMessage, i)));
                if (tmp == null) continue;
                sb.append(tmp);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String secretSubstitution(String rawMessage) {
        boolean oldFortify = this.fortify;
        this.fortify = true;
        try {
            String string = this.substitute(rawMessage);
            return string;
        }
        finally {
            this.fortify = oldFortify;
        }
    }

    protected int skipToken(String rawMessage, int i) {
        assert (rawMessage.charAt(i) == '(');
        ++i;
        int level = 1;
        while (level != 0) {
            try {
                char c = rawMessage.charAt(++i);
                if (c == '(') {
                    ++level;
                    continue;
                }
                if (c != ')') continue;
                --level;
            }
            catch (StringIndexOutOfBoundsException e) {
                if (this.fortify) {
                    throw e;
                }
                throw new IllegalArgumentException("Raw message " + rawMessage + " is probably not well formed!");
            }
        }
        return i;
    }

    public void fortify() {
        this.fortify = true;
    }

    protected String replaceToken(String t) {
        Object o;
        int w;
        String origT = t;
        if (t.startsWith("CHR ")) {
            return String.valueOf((char)Integer.parseInt(t.substring(4)));
        }
        if (t.startsWith("DEFAULT ")) {
            this.def = t.substring(8);
            return "";
        }
        String property = null;
        int i = t.indexOf(46);
        if (i > 0 && ((w = t.indexOf(32)) < 0 || w > i)) {
            property = t.substring(i + 1);
            t = t.substring(0, i);
        }
        if ((o = this.placeHolders.get(t)) == null) {
            String[] keyAndModifier;
            VariableSubstitution vs;
            String[] dt;
            if (this.matcher != null) {
                try {
                    int m = Integer.parseInt(t);
                    return this.matcher.group(m);
                }
                catch (NumberFormatException m) {
                    // empty catch block
                }
            }
            if ((dt = origT.split(" ", 2)).length == 2 && (vs = this.variablePlaceHolders.get((keyAndModifier = Substitution.parseVariableModifier(dt[0].trim()))[0])) != null) {
                if (keyAndModifier.length == 2) {
                    return vs.getValue(keyAndModifier[1], dt[1].trim());
                }
                return vs.getValue(null, dt[1].trim());
            }
        } else if (property != null) {
            o = PropertyUtil.getProperty(o, property, this.def != null, this.def);
        }
        if (o == null) {
            o = System.getProperty("de.businesslogics.task.Substitution." + origT);
        }
        if (o == null) {
            if (this.def == null) {
                if (!this.fortify) {
                    LOGGER.warning("No replacement for " + origT + " found!");
                }
                o = "$(" + origT + ")";
            } else {
                if (!this.fortify) {
                    LOGGER.fine("No replacement for " + origT + " found!");
                }
                o = this.def;
            }
        }
        return o.toString();
    }

    private static String[] parseVariableModifier(String keyAndModifier) {
        int tildeIndex;
        int minusIndex;
        int plusIndex = keyAndModifier.indexOf(43);
        if (plusIndex + (minusIndex = keyAndModifier.indexOf(45)) + (tildeIndex = keyAndModifier.indexOf(126)) == -3) {
            return new String[]{keyAndModifier};
        }
        int modifierStart = keyAndModifier.length();
        if (plusIndex >= 0) {
            modifierStart = Math.min(modifierStart, plusIndex);
        }
        if (minusIndex >= 0) {
            modifierStart = Math.min(modifierStart, minusIndex);
        }
        if (tildeIndex >= 0) {
            modifierStart = Math.min(modifierStart, tildeIndex);
        }
        return new String[]{keyAndModifier.substring(0, modifierStart), keyAndModifier.substring(modifierStart)};
    }

    protected static Date modifyDate(Date inputDate, String dateModifiers) {
        Matcher dmMatcher = DATE_MODIFIER_PATTERN.matcher(dateModifiers);
        Calendar toReturn = Calendar.getInstance();
        toReturn.setTime(inputDate);
        boolean matched = false;
        while (dmMatcher.find()) {
            String group = dmMatcher.group();
            Matcher innerMatcher = DATE_MODIFIER_PATTERN.matcher(group);
            if (!innerMatcher.matches() || innerMatcher.groupCount() != 3) {
                throw new IllegalArgumentException("Illegal date modifier. Define like \"-1y+2d\". Wrong format \"" + group + "\" in \"" + dateModifiers + "\"");
            }
            String sign = innerMatcher.group(1);
            Object number = "+".equals(sign) ? innerMatcher.group(2) : "-" + innerMatcher.group(2);
            int change = Integer.valueOf((String)number);
            int calendarField = Substitution.getCalendarField(innerMatcher.group(3));
            toReturn.add(calendarField, change);
            matched = true;
        }
        if (!matched) {
            throw new IllegalArgumentException("Illegal date modifier '" + dateModifiers + "'. Define like \"-1y+2d\".");
        }
        return toReturn.getTime();
    }

    private static int getCalendarField(String patternChar) {
        if (patternChar.length() != 1) {
            throw new IllegalArgumentException("Only single pattern characters allowed: " + patternChar);
        }
        Integer toReturn = DATE_PATTERN_TO_CALENDAR_FIELD.get(Character.valueOf(patternChar.charAt(0)));
        if (toReturn == null) {
            throw new IllegalArgumentException("Illegal pattern character: " + patternChar);
        }
        return toReturn;
    }

    public void setDefault(String def) {
        this.def = def;
    }

    public static void main(String[] args) {
        Substitution sub = new Substitution();
        System.out.println(sub.substitute("$(DATE-10d FIRST_OF_PREVIOUS_MONTH)"));
    }

    static {
        DATE_PATTERN_TO_CALENDAR_FIELD.put(Character.valueOf('y'), 1);
        DATE_PATTERN_TO_CALENDAR_FIELD.put(Character.valueOf('M'), 2);
        DATE_PATTERN_TO_CALENDAR_FIELD.put(Character.valueOf('W'), 3);
        DATE_PATTERN_TO_CALENDAR_FIELD.put(Character.valueOf('d'), 5);
        DATE_PATTERN_TO_CALENDAR_FIELD.put(Character.valueOf('h'), 10);
        DATE_PATTERN_TO_CALENDAR_FIELD.put(Character.valueOf('H'), 10);
        DATE_PATTERN_TO_CALENDAR_FIELD.put(Character.valueOf('m'), 12);
        DATE_PATTERN_TO_CALENDAR_FIELD.put(Character.valueOf('s'), 13);
        DATE_PATTERN_TO_CALENDAR_FIELD.put(Character.valueOf('S'), 14);
        LOGGER = Logger.getLogger(Substitution.class.getName());
    }

    public static class DateSubstitution
    implements VariableSubstitution {
        private final Date date;

        public DateSubstitution() {
            this(new Date());
        }

        public DateSubstitution(Date date) {
            this.date = date;
        }

        protected SimpleDateFormat getSimpleDateformat(String value) {
            return new SimpleDateFormat(value);
        }

        @Override
        public String getValue(String modifier, String value) {
            Date myDate = this.date;
            String constant = null;
            if (value.startsWith("FIRST_OF") || value.startsWith("LAST_OF")) {
                String[] constantAndFormat = value.split(" ", 2);
                constant = constantAndFormat[0];
                value = constantAndFormat.length == 2 ? constantAndFormat[1] : "yyyy-MM-dd";
            }
            SimpleDateFormat sdf = this.getSimpleDateformat(value);
            if (modifier != null) {
                myDate = Substitution.modifyDate(myDate, modifier);
            }
            if (constant != null) {
                Calendar newDate = Calendar.getInstance();
                newDate.setTime(myDate);
                String[] sub = constant.split("_");
                if (sub.length != 4) {
                    return sdf.format(myDate);
                }
                if (sub[2].equals("PREVIOUS")) {
                    if (sub[3].equals("YEAR")) {
                        newDate.add(1, -1);
                    }
                    if (sub[3].equals("MONTH")) {
                        newDate.add(2, -1);
                    }
                }
                if (sub[0].equals("FIRST")) {
                    if (sub[3].equals("YEAR")) {
                        newDate.set(2, newDate.getActualMinimum(2));
                    }
                    newDate.set(5, 1);
                }
                if (sub[0].equals("LAST")) {
                    if (sub[3].equals("YEAR")) {
                        newDate.set(2, newDate.getActualMaximum(2));
                    }
                    newDate.set(5, newDate.getActualMaximum(5));
                }
                myDate = newDate.getTime();
            }
            return sdf.format(myDate);
        }
    }

    private static class LateSubstitution
    implements SerializableSubstitutionValue {
        private static final long serialVersionUID = 1L;
        private final String rawMessage;
        private transient Substitution substitution;

        private LateSubstitution(String rawMessage, Substitution substitution) {
            this.rawMessage = rawMessage;
            this.substitution = substitution;
        }

        public String toString() {
            return this.substitution.substitute(this.rawMessage);
        }

        @Override
        public Object readReplace(Substitution s) {
            this.substitution = s;
            return this;
        }
    }

    public static interface VariableSubstitution {
        public String getValue(String var1, String var2);
    }

    public static class UTCDateSubstitution
    extends DateSubstitution {
        @Override
        protected SimpleDateFormat getSimpleDateformat(String value) {
            SimpleDateFormat sdf = new SimpleDateFormat(value);
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            return sdf;
        }
    }

    public static interface SerializableSubstitutionValue
    extends Serializable {
        public Object readReplace(Substitution var1);
    }
}

