/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.task;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class CronBitSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(CronBitSet.class.getName());
    private int field;
    List<CronInterval> intervals = new ArrayList<CronInterval>();
    private static final OverlapComparator OVERLAP_COMPARATOR = new OverlapComparator();
    private static final FromComparator FROM_COMPARATOR = new FromComparator();
    private static final int OK = 0;
    private static final int TRY_AGAIN = 1;
    private static final int FINAL_FAILURE = 2;

    public CronBitSet() {
    }

    public CronBitSet(String fromString, int field) {
        this.setFromString(fromString);
        this.setField(field);
    }

    public void setFromString(String fromString) {
        this.clearAll();
        StringTokenizer st = new StringTokenizer(fromString, ",");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            int i = s.indexOf(45);
            if (i >= 0) {
                int from = i == 0 ? Integer.MIN_VALUE : Integer.parseInt(s.substring(0, i).trim());
                int to = i == s.length() - 1 ? Integer.MAX_VALUE : Integer.parseInt(s.substring(i + 1).trim());
                this.set(from, to);
                continue;
            }
            this.set(Integer.parseInt(s.trim()));
        }
    }

    public int getField() {
        return this.field;
    }

    public void setField(int field) {
        this.field = field;
    }

    public void clearAll() {
        this.intervals.clear();
    }

    public boolean get(int bit) {
        CronInterval ci = new CronInterval(bit, bit);
        int index = Collections.binarySearch(this.intervals, ci, OVERLAP_COMPARATOR);
        return index >= 0;
    }

    public void clear(int bit) {
        CronInterval ci = new CronInterval(bit, bit);
        int index = Collections.binarySearch(this.intervals, ci, OVERLAP_COMPARATOR);
        if (index < 0) {
            return;
        }
        ci = this.intervals.get(index);
        if (ci.to == ci.from) {
            this.intervals.remove(index);
            return;
        }
        if (ci.to == bit) {
            --ci.to;
            return;
        }
        if (ci.from == bit) {
            ++ci.from;
            return;
        }
        CronInterval newCi = new CronInterval(ci.from, bit - 1);
        ci.from = bit + 1;
        this.intervals.add(index, newCi);
    }

    public void set(int bit) {
        this.set(bit, bit);
    }

    public void set(int fromBit, int toBit) {
        CronInterval ci = new CronInterval(fromBit, toBit);
        int index = Collections.binarySearch(this.intervals, ci, FROM_COMPARATOR);
        if (index < 0) {
            index = -index - 1;
        }
        this.intervals.add(index, ci);
        while (index + 1 < this.intervals.size() && ci.merge(this.intervals.get(index + 1))) {
            this.intervals.remove(index + 1);
        }
        while (index > 0) {
            CronInterval ciOld;
            if (!ci.merge(ciOld = this.intervals.get(--index))) {
                return;
            }
            this.intervals.remove(index);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.intervals.size(); ++i) {
            if (i != 0) {
                sb.append(',');
            }
            sb.append(this.intervals.get(i));
        }
        return sb.toString();
    }

    public int nextSetBit(int fromIndex) {
        CronInterval ci = new CronInterval(fromIndex, fromIndex);
        int index = Collections.binarySearch(this.intervals, ci, OVERLAP_COMPARATOR);
        if (index >= 0) {
            return fromIndex;
        }
        if ((index = -index - 1) >= this.intervals.size()) {
            return -1;
        }
        return this.intervals.get((int)index).from;
    }

    public static Calendar getNextRun(Calendar earliestStart, CronBitSet ... bitSets) {
        if (earliestStart.get(14) != 0) {
            earliestStart.set(14, 0);
            earliestStart.add(13, 1);
        }
        if (earliestStart.get(13) != 0) {
            earliestStart.set(13, 0);
            earliestStart.add(12, 1);
        }
        return CronBitSet.getNextRun(earliestStart, 0, bitSets) == 0 ? earliestStart : null;
    }

    private static int getNextRun(Calendar earliestStart, int searchLevel, CronBitSet[] bitSets) {
        int i;
        int possible;
        CronBitSet bitSet = bitSets[searchLevel];
        int field = bitSet.getField();
        boolean fullRun = earliestStart.get(field) == earliestStart.getMinimum(field) && earliestStart.getActualMaximum(field) == earliestStart.getMaximum(field);
        for (int sf = searchLevel + 1; fullRun && sf < bitSets.length; ++sf) {
            int sff = bitSets[sf].getField();
            fullRun = earliestStart.get(sff) == earliestStart.getMinimum(sff);
        }
        do {
            int subResult;
            int i2;
            int now;
            if ((possible = bitSet.nextSetBit(now = earliestStart.get(field))) < 0 || possible > earliestStart.getActualMaximum(field)) {
                if (field == 1 || fullRun || searchLevel != 0) break;
                earliestStart.add(field, earliestStart.getActualMaximum(field) - now + 1);
                for (i2 = searchLevel + 1; i2 < bitSets.length; ++i2) {
                    earliestStart.set(bitSets[i2].getField(), earliestStart.getActualMinimum(bitSets[i2].getField()));
                }
                fullRun = earliestStart.getActualMaximum(field) == earliestStart.getMaximum(field);
                possible = 0;
                continue;
            }
            if (possible > earliestStart.getActualMaximum(field)) continue;
            if (possible != now) {
                for (i2 = searchLevel + 1; i2 < bitSets.length; ++i2) {
                    earliestStart.set(bitSets[i2].getField(), earliestStart.getActualMinimum(bitSets[i2].getField()));
                }
                if (field == 7) {
                    earliestStart.add(field, possible - now);
                } else {
                    earliestStart.set(field, possible);
                }
            }
            if (searchLevel == bitSets.length - 1) {
                return 0;
            }
            if (field == 2 && earliestStart.getActualMaximum(5) != 29) {
                fullRun = false;
            }
            if ((subResult = CronBitSet.getNextRun(earliestStart, searchLevel + 1, bitSets)) != 1) {
                return subResult;
            }
            if (possible == earliestStart.getActualMaximum(field) && (fullRun || searchLevel != 0)) break;
            earliestStart.add(field, 1);
            for (i = searchLevel + 1; i < bitSets.length; ++i) {
                earliestStart.set(bitSets[i].getField(), earliestStart.getActualMinimum(bitSets[i].getField()));
            }
        } while (possible >= 0);
        if (searchLevel == 0 || fullRun) {
            StringBuilder sb = new StringBuilder("No execution date found for bitsets:");
            for (i = 0; i < bitSets.length; ++i) {
                sb.append(' ');
                sb.append(bitSets[i].getField());
                sb.append(":[");
                sb.append(bitSets[i]);
                sb.append("]");
            }
            LOGGER.warning(sb.toString());
            return 2;
        }
        return 1;
    }

    private static class CronInterval
    implements Serializable {
        private static final long serialVersionUID = 1L;
        int from;
        int to;

        CronInterval(int from, int to) {
            if (from > to) {
                throw new IllegalArgumentException(from + ">" + to);
            }
            this.from = from;
            this.to = to;
        }

        boolean merge(CronInterval ci) {
            if (this.from <= ci.from) {
                if (this.to < ci.from - 1) {
                    return false;
                }
            } else {
                if (ci.to < this.from - 1) {
                    return false;
                }
                this.from = ci.from;
            }
            this.to = Math.max(this.to, ci.to);
            return true;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof CronInterval)) {
                return false;
            }
            CronInterval ci = (CronInterval)obj;
            return this.from == ci.from && this.to == ci.to;
        }

        public int hashCode() {
            return this.from ^ Integer.rotateLeft(this.to, 16);
        }

        public String toString() {
            if (this.from == this.to) {
                return Integer.toString(this.from);
            }
            return Integer.toString(this.from) + "-" + Integer.toString(this.to);
        }
    }

    private static class OverlapComparator
    implements Comparator<CronInterval>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private OverlapComparator() {
        }

        @Override
        public int compare(CronInterval o1, CronInterval o2) {
            if (o1.to < o2.from) {
                return -1;
            }
            if (o2.to < o1.from) {
                return 1;
            }
            return 0;
        }
    }

    private static class FromComparator
    implements Comparator<CronInterval>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private FromComparator() {
        }

        @Override
        public int compare(CronInterval o1, CronInterval o2) {
            return o1.from - o2.from;
        }
    }
}

