/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.security.jce;

import de.businesslogics.bouncycastle.crypto.digests.RIPEMD160Digest;
import java.security.MessageDigest;
import java.security.MessageDigestSpi;

public class RIPEMD160_BCS
extends MessageDigestSpi {
    private final RIPEMD160Digest md = new RIPEMD160Digest();

    @Override
    protected byte[] engineDigest() {
        byte[] toReturn = new byte[20];
        this.md.doFinal(toReturn, 0);
        return toReturn;
    }

    @Override
    protected void engineReset() {
        this.md.reset();
    }

    @Override
    protected void engineUpdate(byte input) {
        if (input != 10 && input != 13 && input != 26) {
            this.md.update(input);
        }
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        len += offset;
        while (offset < len) {
            byte b;
            int i;
            for (i = offset; i < len && (b = input[i]) != 10 && b != 13 && b != 26; ++i) {
            }
            if (i > offset) {
                this.md.update(input, offset, i - offset);
            }
            for (offset = i + 1; offset < len && ((b = input[offset]) == 10 || b == 13 || b == 26); ++offset) {
            }
        }
    }

    public MessageDigest getMessageDigest() {
        return new DigestWrapper();
    }

    private class DigestWrapper
    extends MessageDigest {
        public DigestWrapper() {
            super("RIPEMD160/BCS");
        }

        @Override
        protected void engineUpdate(byte input) {
            RIPEMD160_BCS.this.engineUpdate(input);
        }

        @Override
        protected void engineUpdate(byte[] input, int offset, int len) {
            RIPEMD160_BCS.this.engineUpdate(input, offset, len);
        }

        @Override
        protected byte[] engineDigest() {
            return RIPEMD160_BCS.this.engineDigest();
        }

        @Override
        protected void engineReset() {
            RIPEMD160_BCS.this.engineReset();
        }
    }
}

