/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.security.jce;

import de.businesslogics.bouncycastle.crypto.digests.RIPEMD160Digest;
import de.businesslogics.security.jce.BcsSignature;
import de.businesslogics.security.jce.RIPEMD160_BCS;
import de.businesslogics.security.jce.SHA256_BCS;
import de.businesslogics.util.SystemUtils;
import de.businesslogics.zkasecurity.DirectSecurity;
import de.businesslogics.zkasecurity.KeyFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAKeyGenParameterSpec;
import java.security.spec.RSAPublicKeySpec;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class Provider
extends java.security.Provider {
    public static final RSAKeyGenParameterSpec A004_KEYGEN_PARAMETER = new RSAKeyGenParameterSpec(1024, new BigInteger("010001", 16));
    private static final long serialVersionUID = -93837045264446106L;

    public Provider() {
        super("bcs", 1.0, "bcs specific cryptographic functions");
        this.put("MessageDigest.RIPEMD160/BCS", RIPEMD160_BCS.class.getName());
        this.put("MessageDigest.SHA-256/BCS", SHA256_BCS.class.getName());
        this.put("Signature.BCS", BcsSignature.class.getName());
    }

    public static byte[] getExponent(RSAPublicKey pubKey) {
        return Provider.scale(pubKey.getPublicExponent().toByteArray(), 128);
    }

    public static byte[] getRipeMdHash(RSAPublicKey pubKey) {
        RIPEMD160Digest md = new RIPEMD160Digest();
        md.update(Provider.scale(pubKey.getPublicExponent().toByteArray(), 128), 0, 128);
        md.update(Provider.scale(pubKey.getModulus().toByteArray(), 128), 0, 128);
        byte[] toReturn = new byte[20];
        md.doFinal(toReturn, 0);
        return toReturn;
    }

    public static byte[] getModulus(RSAPublicKey pubKey) {
        return Provider.scale(pubKey.getModulus().toByteArray(), 128);
    }

    public static void addProvider() {
        Security.addProvider(new Provider());
    }

    public static RSAPublicKey buildKey(byte[] mod, byte[] exp) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        return Provider.buildKey(new BigInteger(1, mod), new BigInteger(1, exp));
    }

    public static RSAPublicKey buildKey(BigInteger mod, BigInteger exp) throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeySpecException {
        if (mod == null || exp == null) {
            return null;
        }
        KeyFactory f = DirectSecurity.getRSAKeyFactory();
        return (RSAPublicKey)f.generatePublic(new RSAPublicKeySpec(mod, exp));
    }

    public static byte[] buildSignatureFile(byte[] signature, String orderType, String userId, String filename, Date fileCreation, Date signatureCreation) {
        byte[] toReturn = new byte[512];
        boolean a004 = false;
        for (int i = 0; i < 32; ++i) {
            if (signature[i] == 0) continue;
            a004 = true;
        }
        if (a004) {
            toReturn[0] = 65;
            toReturn[1] = 48;
            toReturn[2] = 48;
            toReturn[3] = 52;
            toReturn[4] = 49;
            toReturn[5] = 48;
            toReturn[6] = 50;
            toReturn[7] = 52;
        } else {
            toReturn[0] = 65;
            toReturn[1] = 48;
            toReturn[2] = 48;
            toReturn[3] = 51;
            toReturn[4] = 48;
            toReturn[5] = 55;
            toReturn[6] = 54;
            toReturn[7] = 56;
        }
        byte[] order = orderType.getBytes();
        Arrays.fill(toReturn, 8, 11, (byte)32);
        System.arraycopy(order, 0, toReturn, 8, Math.min(3, order.length));
        Arrays.fill(toReturn, 11, 139, (byte)0);
        System.arraycopy(signature, 0, toReturn, 139 - signature.length, signature.length);
        byte[] user = userId.getBytes();
        Arrays.fill(toReturn, 139, 147, (byte)32);
        System.arraycopy(user, 0, toReturn, 139, Math.min(8, user.length));
        byte[] file = filename.getBytes();
        Arrays.fill(toReturn, 147, 275, (byte)32);
        System.arraycopy(file, 0, toReturn, 147, Math.min(128, file.length));
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd HHmmss ");
        byte[] ftime = df.format(fileCreation).getBytes();
        System.arraycopy(ftime, 0, toReturn, 275, 16);
        byte[] stime = df.format(signatureCreation).getBytes();
        System.arraycopy(stime, 0, toReturn, 291, 16);
        Arrays.fill(toReturn, 307, toReturn.length, (byte)0);
        return toReturn;
    }

    public static byte[] scale(byte[] in, int len) {
        if (in.length == len) {
            return in;
        }
        if (in.length < len) {
            byte[] out = new byte[len];
            Arrays.fill(out, 0, len - in.length, (byte)0);
            System.arraycopy(in, 0, out, len - in.length, in.length);
            return out;
        }
        byte[] out = new byte[len];
        System.arraycopy(in, in.length - len, out, 0, len);
        for (int i = 0; i < in.length - len; ++i) {
            if (in[i] == 0) continue;
            throw new RuntimeException("found a non zero byte");
        }
        return out;
    }

    public static boolean equals(byte[] first, byte[] second) {
        int diff = first.length - second.length;
        if (diff < 0) {
            byte[] b = first;
            first = second;
            second = b;
            diff = -diff;
        }
        int i = diff;
        while (--i >= 0) {
            if (first[i] == 0) continue;
            return false;
        }
        for (i = 0; i < second.length; ++i) {
            if (first[diff++] == second[i]) continue;
            return false;
        }
        return true;
    }

    public static List<X509Certificate> convertX509Data(byte[] b) {
        if (b == null) {
            return null;
        }
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>(1);
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(b);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            while (bis.available() > 0) {
                Certificate c = cf.generateCertificate(bis);
                certificates.add((X509Certificate)c);
            }
        }
        catch (Exception e) {
            SystemUtils.throwRuntimeException(e);
        }
        if (certificates.isEmpty()) {
            return null;
        }
        return certificates;
    }

    public static byte[] convertX509Data(List<X509Certificate> certificates) {
        if (certificates == null || certificates.isEmpty()) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            for (X509Certificate c : certificates) {
                bos.write(c.getEncoded());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return bos.toByteArray();
    }

    public static byte[] getHash(X509Certificate cert) throws GeneralSecurityException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        return digest.digest(cert.getEncoded());
    }
}

