/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.security.jce;

import de.businesslogics.bouncycastle.crypto.DataLengthException;
import de.businesslogics.crypto.BCRSANopaddingCipher;
import de.businesslogics.security.jce.Provider;
import de.businesslogics.security.jce.RIPEMD160_BCS;
import de.businesslogics.util.HexTool;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import java.util.Date;

public class BcsSignature
extends SignatureSpi {
    private Date timestamp;
    private BcsHashValues hashes = null;
    private BcsParameterSpec parameter = null;
    private MessageDigest md = null;
    private RSAPrivateKey privateKey = null;
    private RSAPublicKey publicKey = null;

    @Override
    public Object engineGetParameter(String param) {
        if (param.equals("timestamp")) {
            return this.timestamp;
        }
        return this.parameter;
    }

    @Override
    public void engineInitSign(PrivateKey _privateKey) throws InvalidKeyException {
        if (!(_privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException("the given private key must be a RSA private key!");
        }
        this.privateKey = (RSAPrivateKey)_privateKey;
        if (this.privateKey.getPrivateExponent().bitLength() > 768) {
            this.md = new RIPEMD160_BCS().getMessageDigest();
        }
    }

    @Override
    public void engineInitVerify(PublicKey _publicKey) throws InvalidKeyException {
        if (!(_publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException("the given public key must be a RSA public key!");
        }
        this.publicKey = (RSAPublicKey)_publicKey;
        this.md = new RIPEMD160_BCS().getMessageDigest();
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec param) throws InvalidAlgorithmParameterException {
        if (!(param instanceof BcsHashValues)) {
            throw new InvalidAlgorithmParameterException("only instances of BcsSignature.BcsHashValues are allowed!");
        }
        this.hashes = (BcsHashValues)param;
        this.md = null;
    }

    @Override
    protected void engineSetParameter(String param, Object value) {
        throw new InvalidParameterException("No parameters");
    }

    @Override
    public byte[] engineSign() throws SignatureException {
        byte[] hash = this.md.digest();
        this.timestamp = new Date();
        this.parameter = new A004Parameter(hash, this.appRandom);
        try {
            BCRSANopaddingCipher rsa = new BCRSANopaddingCipher();
            rsa.init(1, this.privateKey);
            return Provider.scale(rsa.doFinal(this.parameter.getDsi()), 128);
        }
        catch (GeneralSecurityException security) {
            SignatureException s = new SignatureException("error during RSA");
            s.initCause(security);
            throw s;
        }
    }

    @Override
    public void engineUpdate(byte b) {
        this.md.update(b);
    }

    @Override
    public void engineUpdate(byte[] u, int off, int len) {
        this.md.update(u, off, len);
    }

    @Override
    public boolean engineVerify(byte[] sigBytes) throws SignatureException {
        byte[] hash = null;
        hash = this.md != null ? this.md.digest() : this.hashes.getA004();
        byte[] dsi = null;
        try {
            BCRSANopaddingCipher rsa = new BCRSANopaddingCipher();
            rsa.init(2, this.publicKey);
            dsi = rsa.doFinal(sigBytes);
        }
        catch (GeneralSecurityException security) {
            SignatureException s = new SignatureException("error during RSA");
            s.initCause(security);
            throw s;
        }
        this.parameter = new A004Parameter(dsi);
        return Arrays.equals(hash, this.parameter.getHash());
    }

    public static boolean verify(byte[] signature, RSAPublicKey key, byte[] a004Hash) throws SignatureException {
        try {
            BCRSANopaddingCipher rsa = new BCRSANopaddingCipher();
            rsa.init(2, key);
            byte[] dsi = rsa.doFinal(signature);
            byte[] h = new A004Parameter(dsi).getHash();
            return Arrays.equals(h, a004Hash);
        }
        catch (SignatureException se) {
            throw se;
        }
        catch (RuntimeException e) {
            SignatureException se = new SignatureException();
            se.initCause(e);
            throw se;
        }
        catch (GeneralSecurityException gse) {
            SignatureException se = new SignatureException();
            se.initCause(gse);
            throw se;
        }
    }

    public static byte[] verify2(byte[] signature, RSAPublicKey key, byte[] a004Hash) throws SignatureException {
        try {
            BCRSANopaddingCipher rsa = new BCRSANopaddingCipher();
            rsa.init(2, key);
            byte[] dsi = rsa.doFinal(signature);
            byte[] h = new A004Parameter(dsi).getHash();
            if (Arrays.equals(h, a004Hash)) {
                return dsi;
            }
            throw new SignatureException("DSI=" + HexTool.toHex(dsi) + "\nripemd=" + HexTool.toHex(a004Hash));
        }
        catch (DataLengthException dle) {
            SignatureException se = new SignatureException(dle.toString());
            se.initCause(dle);
            throw se;
        }
        catch (SignatureException se) {
            throw se;
        }
        catch (GeneralSecurityException gse) {
            SignatureException se = new SignatureException(gse.toString());
            se.initCause(gse);
            throw se;
        }
    }

    public static class BcsHashValues
    implements AlgorithmParameterSpec {
        private final byte[] a003;
        private final byte[] a004;

        public BcsHashValues(byte[] a003, byte[] a004) {
            this.a003 = a003;
            this.a004 = a004;
        }

        public byte[] getA003() {
            return this.a003;
        }

        public byte[] getA004() {
            return this.a004;
        }
    }

    public static interface BcsParameterSpec
    extends AlgorithmParameterSpec {
        public byte[] getDsi();

        public byte[] getHash();
    }

    public static class A004Parameter
    implements BcsParameterSpec {
        private final byte[] dsi;
        private final byte[] hash;

        public A004Parameter(byte[] hash, SecureRandom random) {
            this.dsi = new byte[128];
            this.dsi[0] = 96;
            for (int i = 1; i <= 97; ++i) {
                this.dsi[i] = 0;
            }
            this.dsi[98] = 1;
            byte[] rnd = new byte[8];
            if (random == null) {
                try {
                    random = SecureRandom.getInstance("SHA1PRNG");
                    random.setSeed(System.currentTimeMillis());
                }
                catch (NoSuchAlgorithmException noAlg) {
                    throw new RuntimeException("Should always be there", noAlg);
                }
            }
            random.nextBytes(rnd);
            System.arraycopy(rnd, 0, this.dsi, 99, 8);
            System.arraycopy(hash, 0, this.dsi, 107, 20);
            this.dsi[127] = -68;
            this.hash = hash;
        }

        public A004Parameter(byte[] dsi) throws SignatureException {
            this.dsi = dsi;
            if (dsi[0] != 96) {
                throw new SignatureException("a004 dsi does not start with 0x60");
            }
            if ((dsi[127] & 0xFF) != 188) {
                throw new SignatureException("a004 dsi does not end with 0xbc");
            }
            for (int i = 1; i < 98; ++i) {
                if (dsi[i] == 0) continue;
                throw new SignatureException("a004 dsi paddingfield does not has 0 bits");
            }
            if (dsi[98] != 1) {
                throw new SignatureException("a004 dsi paddingfield does not end with 1 bit");
            }
            this.hash = new byte[20];
            System.arraycopy(dsi, 107, this.hash, 0, 20);
        }

        @Override
        public byte[] getDsi() {
            return this.dsi;
        }

        @Override
        public byte[] getHash() {
            return this.hash;
        }
    }
}

