/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.security.jce;

import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public abstract class BLTrustManager
implements X509TrustManager {
    private static final Logger LOGGER = Logger.getLogger(BLTrustManager.class.getName());
    protected static final char[] PASSWORD = "XAqGlC6RhdC56mZ+ftLB".toCharArray();
    private File storage = null;
    protected X509TrustManager mgr = null;
    private X509TrustManager defaultManager = null;

    public BLTrustManager(File input) throws IOException, GeneralSecurityException {
        this.storage = input;
        KeyStore ks = this.getKeyStore();
        TrustManagerFactory f = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        f.init(ks);
        this.mgr = (X509TrustManager)f.getTrustManagers()[0];
        f = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        f.init((KeyStore)null);
        this.defaultManager = (X509TrustManager)f.getTrustManagers()[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore getKeyStore() throws IOException, GeneralSecurityException {
        FileInputStream in = null;
        char[] pwdToUse = PASSWORD;
        if (this.storage == null || !this.storage.exists()) {
            return null;
        }
        in = new FileInputStream(this.storage);
        try {
            KeyStore ks = KeyStore.getInstance("jks");
            ks.load(in, pwdToUse);
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (IOException io) {
            LOGGER.log(Level.FINE, "can not load keystore", io);
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            KeyStore keyStore = null;
            return keyStore;
        }
        finally {
            SystemUtils.close(in);
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.defaultManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.defaultManager.checkServerTrusted(chain, authType);
        }
        catch (CertificateException ex0) {
            try {
                this.mgr.checkServerTrusted(chain, authType);
            }
            catch (CertificateException ex) {
                try {
                    if (!this.askUser(chain, authType)) {
                        LOGGER.log(Level.FINE, "user rejected certificate");
                        throw ex;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LOGGER.log(Level.FINE, "exception occurred during certificate check", e);
                    throw ex;
                }
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultManager.getAcceptedIssuers();
    }

    protected abstract boolean askUser(X509Certificate[] var1, String var2) throws IOException, GeneralSecurityException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void addCertificates(X509Certificate[] chain, String authType) throws IOException, GeneralSecurityException {
        KeyStore ks = this.getKeyStore();
        if (ks == null) {
            ks = KeyStore.getInstance("jks");
            ks.load(null, PASSWORD);
        }
        int i = 0;
        for (int j = 0; j < chain.length; ++j) {
            ks.setCertificateEntry(chain[i].getSubjectDN().toString(), chain[i]);
        }
        this.storage.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(this.storage);){
            ks.store(out, PASSWORD);
        }
        TrustManagerFactory f = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        f.init(ks);
        this.mgr = (X509TrustManager)f.getTrustManagers()[0];
    }
}

