/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.persistence;

import de.businesslogics.util.HexTool;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class Dialect {
    private final String dateFormat;
    private final HashMap<Integer, TreeMap<Long, String>> types = new HashMap();

    protected Dialect(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public abstract String[] modifyColumn(String var1, String var2, String var3, boolean var4, String var5, boolean var6);

    public abstract String[] dropIndexOn(String var1, String var2);

    public abstract String[] dropUniqueConstraint(String var1, String var2);

    public abstract String[] dropForeignKey(String var1, String var2);

    public abstract String[] renameColumn(String var1, String var2, String var3, String var4, boolean var5);

    public String dropTable(String tableName) {
        return "DROP TABLE " + tableName;
    }

    public final String getType(int type) {
        return this.getType(type, 0L);
    }

    public final String getType(int type, long length) {
        TreeMap<Long, String> lm = this.types.get(type);
        if (lm == null) {
            throw new IllegalArgumentException("No mapping for type " + type);
        }
        Map.Entry<Long, String> me = lm.ceilingEntry(length);
        if (me == null) {
            throw new IllegalArgumentException("No mapping for type " + type + " with length " + length);
        }
        String toReturn = me.getValue();
        toReturn = toReturn.replace("$l", Long.toString(length));
        return toReturn;
    }

    protected final void registerType(int type, String template) {
        this.registerType(type, Long.MAX_VALUE, template);
    }

    protected final void registerType(int type, long maxLength, String template) {
        Integer i = type;
        TreeMap<Long, String> lm = this.types.get(i);
        if (lm == null) {
            lm = new TreeMap();
            this.types.put(i, lm);
        }
        lm.put(maxLength, template);
    }

    public abstract String renameTable(String var1, String var2);

    public String addSetIdentityInsert(String sql) {
        if (!sql.toLowerCase().startsWith("insert into ") || sql.indexOf(32, 12) < 13) {
            throw new RuntimeException("Statement must start with 'insert into <tablename> '");
        }
        return sql;
    }

    public String formatTimestamp(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(this.dateFormat);
        return sdf.format(date);
    }

    public String getInsertAutoGenKey() {
        return null;
    }

    public String[] renameIndex(String table, String oldIndexName, String newIndexName, String[] columns) {
        String[] drop = this.dropIndexOn(oldIndexName, table);
        String[] toReturn = new String[drop.length + 1];
        System.arraycopy(drop, 0, toReturn, 0, drop.length);
        StringBuilder sb = new StringBuilder("CREATE INDEX ").append(newIndexName).append(" ON ").append(table).append(" (").append(columns[0]);
        for (int i = 1; i < columns.length; ++i) {
            sb.append(',').append(columns[i]);
        }
        toReturn[drop.length] = sb.append(')').toString();
        return toReturn;
    }

    public String getSchema(Connection c) throws SQLException {
        try {
            return c.getSchema();
        }
        catch (AbstractMethodError ame) {
            Class<?> cl = c.getClass();
            try {
                Method m = cl.getMethod("getUnderlyingConnection", new Class[0]);
                c = (Connection)m.invoke((Object)c, new Object[0]);
            }
            catch (Exception e) {
                throw ame;
            }
            return c.getSchema();
        }
    }

    public String getCatalog(Connection c) throws SQLException {
        return c.getCatalog();
    }

    public String[] renameForeignKey(String table, String matchingFK, String oldIndexName, String fkName, String[] myColumns, String referredTable, String[] referredColumns) {
        int j;
        ArrayList<String> toReturn = new ArrayList<String>();
        for (String s : this.dropForeignKey(table, matchingFK)) {
            toReturn.add(s);
        }
        if (oldIndexName != null) {
            for (String s : this.dropIndexOn(oldIndexName, table)) {
                toReturn.add(s);
            }
        }
        StringBuilder sb = new StringBuilder("ALTER TABLE ").append(table).append(" ADD CONSTRAINT ").append(fkName).append(" FOREIGN KEY (").append(myColumns[0]);
        for (j = 1; j < myColumns.length; ++j) {
            sb.append(',').append(myColumns[j]);
        }
        sb.append(") REFERENCES ").append(referredTable).append('(').append(referredColumns[0]);
        for (j = 1; j < referredColumns.length; ++j) {
            sb.append(',').append(referredColumns[j]);
        }
        sb.append(')');
        toReturn.add(sb.toString());
        return toReturn.toArray(new String[toReturn.size()]);
    }

    @Deprecated
    public String dropPrimaryKey(String table) {
        throw new RuntimeException(this.getClass().getCanonicalName() + ".dropPrimaryKey() Not yet implemented");
    }

    @Deprecated
    public void dropPrimaryKey(Connection c, String table) throws SQLException {
        try (Statement s = c.createStatement();){
            s.executeUpdate(this.dropPrimaryKey(table));
        }
    }

    public String getLiteralBoolean(boolean b) {
        return b ? "1" : "0";
    }

    public String toLiteralSqlValue(int type, Object o) {
        switch (type) {
            case 16: {
                return this.getLiteralBoolean((Boolean)o);
            }
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return o.toString();
            }
            case 93: {
                return this.formatTimestamp((Date)o);
            }
            case 12: {
                String s = (String)o;
                StringBuilder sb = new StringBuilder(s.length() + 2);
                sb.append('\'');
                for (int i = 0; i < s.length(); ++i) {
                    char c = s.charAt(i);
                    if (c == '\'') {
                        sb.append('\'');
                    }
                    sb.append(c);
                }
                sb.append('\'');
                return sb.toString();
            }
            case 2004: {
                return "0x" + HexTool.toHex((byte[])o);
            }
        }
        throw new RuntimeException("No mapping for type " + type + " (" + o.getClass().getName() + ")");
    }

    public String dropView(String view) {
        return "DROP VIEW " + view;
    }

    public String charLength(String column) {
        return "CHAR_LENGTH(" + column + ")";
    }

    public String substring(String column, int start, int length) {
        return "SUBSTRING(" + column + "," + start + "," + length + ")";
    }

    public PreparedStatement getPreparedStatementReturningId(Connection con, String sql) throws SQLException {
        return con.prepareStatement(sql, 1);
    }

    public List<String> getSequenceNames(Connection con) throws SQLException {
        return null;
    }

    public void setFetchSize(Statement s, int fetchSize) throws SQLException {
        s.setFetchSize(fetchSize);
    }
}

