/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.persistence;

import de.businesslogics.persistence.Dialect;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class DBType
extends Enum<DBType> {
    public static final /* enum */ DBType DERBY = new DBType("BOOLEAN", "SMALLINT", "SMALLINT", "INTEGER", "BIGINT", "DATE", "TIMESTAMP", "ADD COLUMN", " GENERATED BY DEFAULT AS IDENTITY", "", new DerbyDialect(), true);
    public static final /* enum */ DBType MYSQL = new DBType("BIT", "TINYINT", "SMALLINT", "INTEGER", "BIGINT", "DATE", "DATETIME", "ADD COLUMN", " NOT NULL AUTO_INCREMENT", " Engine=InnoDB", new MySQLDialect(), true);
    public static final /* enum */ DBType MARIADB = new DBType("BIT", "TINYINT", "SMALLINT", "INTEGER", "BIGINT", "DATE", "DATETIME", "ADD COLUMN", " NOT NULL AUTO_INCREMENT", " Engine=InnoDB", new MySQLDialect(), true);
    public static final /* enum */ DBType ORACLE = new DBType("NUMBER(1,0)", "NUMBER(3,0)", "NUMBER(5,0)", "NUMBER(10,0)", "NUMBER(19,0)", "DATE", "TIMESTAMP", "ADD", " NOT NULL", "", new OracleDialect(), false);
    public static final /* enum */ DBType DB2 = new DBType("SMALLINT", "SMALLINT", "SMALLINT", "INTEGER", "BIGINT", "DATE", "TIMESTAMP", "ADD COLUMN", " generated by default as identity", "", new Db2Dialect(), false);
    public static final /* enum */ DBType DB2_AS400 = new DBType("SMALLINT", "SMALLINT", "SMALLINT", "INTEGER", "BIGINT", "DATE", "TIMESTAMP", "ADD COLUMN", " generated by default as identity", "", new Db2AS400Dialect(), false);
    public static final /* enum */ DBType HSQL = new DBType("BIT", "TINYINT", "SMALLINT", "INTEGER", "BIGINT", "DATE", "TIMESTAMP", "ADD COLUMN", " generated by default as identity (start with 1)", "", new HsqlDialect(), true);
    public static final /* enum */ DBType HSQL2 = new DBType("BIT", "TINYINT", "SMALLINT", "INTEGER", "BIGINT", "DATE", "TIMESTAMP", "ADD COLUMN", " generated by default as identity (start with 1)", "", new Hsql2Dialect(), true);
    public static final /* enum */ DBType H2 = new DBType("BOOLEAN", "TINYINT", "SMALLINT", "INTEGER", "BIGINT", "DATE", "TIMESTAMP", "ADD", " NOT NULL", "", new H2Dialect(), true);
    public static final /* enum */ DBType MSSQL = new DBType("TINYINT", "SMALLINT", "SMALLINT", "INT", "NUMERIC(19,0)", "DATETIME", "DATETIME", "ADD", " identity not null", "", new MssqlDialect(), false);
    public static final /* enum */ DBType PSQL = new DBType("BOOL", "INT2", "INT2", "INT4", "INT8", "DATE", "TIMESTAMP", "ADD COLUMN", " NOT NULL", "", new PSQLDialect(), false);
    private static final String MARIADB_IDENTIFIER = "MARIADB";
    private static final String POSTGRESQL_IDENTIFIER = "POSTGRESQL";
    private static final String HSQL_IDENTIFIER = "HSQL";
    private static final String H2_IDENTIFIER = "H2";
    private static final String DB2_IDENTIFIER = "DB2";
    private static final String DB2_AS400_IDENTIFIER = "AS/400";
    private static final String MYSQL_IDENTIFIER = "MYSQL";
    private static final String ORACLE_IDENTIFIER = "ORACLE";
    private static final String MSSQL_IDENTIFIER = "MICROSOFT SQL SERVER";
    @Deprecated
    public final String booleanType;
    public final String byteType;
    public final String shortType;
    public final String integerType;
    public final String longType;
    public final String timestampType;
    public final String addColumn;
    @Deprecated
    public final String autoPkString;
    public final String engineString;
    public final Dialect dialect;
    public final String dateType;
    public final boolean fkImpliesIndex;
    private static final /* synthetic */ DBType[] $VALUES;

    public static DBType[] values() {
        return (DBType[])$VALUES.clone();
    }

    public static DBType valueOf(String name) {
        return Enum.valueOf(DBType.class, name);
    }

    private DBType(String booleanType, String byteType, String shortType, String integerType, String longType, String dateType, String timestampType, String addColumn, String autoPkString, String engineString, Dialect dialect, boolean fkImpliesIndex) {
        this.booleanType = booleanType;
        this.byteType = byteType;
        this.shortType = shortType;
        this.integerType = integerType;
        this.longType = longType;
        this.dateType = dateType;
        this.timestampType = timestampType;
        this.addColumn = addColumn;
        this.autoPkString = autoPkString;
        this.engineString = engineString;
        this.dialect = dialect;
        this.fkImpliesIndex = fkImpliesIndex;
    }

    @Deprecated
    public String getVarchar(int length) {
        if (this == ORACLE) {
            return length > 4000 ? "CLOB" : "VARCHAR2(" + length + ")";
        }
        return "VARCHAR(" + length + ")";
    }

    public String getVarcharColumn(int length) {
        assert (length <= 8000) : "MSSQL can only handle 8000 characters";
        if (this == ORACLE) {
            return length > 4000 ? "CLOB" : "VARCHAR2(" + length + " char)";
        }
        if (this == DB2) {
            return "VARGRAPHIC(" + length + ")";
        }
        return "VARCHAR(" + length + ")";
    }

    public static DBType getInstance(Connection c) throws SQLException {
        DatabaseMetaData md = c.getMetaData();
        String dbProductName = md.getDatabaseProductName().toUpperCase();
        if (dbProductName.contains(MYSQL_IDENTIFIER) || dbProductName.contains(MARIADB_IDENTIFIER)) {
            return MYSQL;
        }
        if (dbProductName.contains(DB2_IDENTIFIER)) {
            if (dbProductName.contains(DB2_AS400_IDENTIFIER)) {
                return DB2_AS400;
            }
            return DB2;
        }
        if (dbProductName.contains(HSQL_IDENTIFIER)) {
            return md.getDatabaseMajorVersion() >= 2 ? HSQL2 : HSQL;
        }
        if (dbProductName.contains(H2_IDENTIFIER)) {
            return H2;
        }
        if (dbProductName.contains(ORACLE_IDENTIFIER)) {
            return ORACLE;
        }
        if (dbProductName.contains(MSSQL_IDENTIFIER)) {
            return MSSQL;
        }
        if (dbProductName.contains(POSTGRESQL_IDENTIFIER)) {
            return PSQL;
        }
        throw new IllegalStateException("Unknown database type: '" + md.getDatabaseProductName() + "'");
    }

    public static DBType getInstance(String driverClass) {
        if (driverClass.equals("com.mysql.jdbc.Driver") || driverClass.equals("com.mysql.cj.jdbc.Driver")) {
            return MYSQL;
        }
        if (driverClass.equals("oracle.jdbc.driver.OracleDriver")) {
            return ORACLE;
        }
        if (driverClass.equals("com.microsoft.sqlserver.jdbc.SQLServerDriver")) {
            return MSSQL;
        }
        if (driverClass.equals("org.h2.Driver")) {
            return H2;
        }
        if (driverClass.equals("org.apache.derby.jdbc.EmbeddedDriver") || driverClass.equals("org.apache.derby.jdbc.ClientDriver")) {
            return DERBY;
        }
        if (driverClass.equalsIgnoreCase("db2")) {
            return DB2;
        }
        if (driverClass.equalsIgnoreCase("db2as400")) {
            return DB2_AS400;
        }
        if (driverClass.equalsIgnoreCase("mysql") || driverClass.equalsIgnoreCase("mysql5")) {
            return MYSQL;
        }
        if (driverClass.equalsIgnoreCase("hypersonic") || driverClass.equalsIgnoreCase("hsql")) {
            return HSQL;
        }
        if (driverClass.equalsIgnoreCase("hsql2")) {
            return HSQL2;
        }
        if (driverClass.equalsIgnoreCase("mssql")) {
            return MSSQL;
        }
        if (driverClass.equalsIgnoreCase("oracle")) {
            return ORACLE;
        }
        if (driverClass.equalsIgnoreCase("psql")) {
            return PSQL;
        }
        if (driverClass.equalsIgnoreCase("derby")) {
            return DERBY;
        }
        throw new RuntimeException("Unknown driver class " + driverClass);
    }

    private static /* synthetic */ DBType[] $values() {
        return new DBType[]{DERBY, MYSQL, MARIADB, ORACLE, DB2, DB2_AS400, HSQL, HSQL2, H2, MSSQL, PSQL};
    }

    static {
        $VALUES = DBType.$values();
    }

    private static class DerbyDialect
    extends Dialect {
        protected DerbyDialect() {
            super("''yyyy-MM-dd HH:mm:ss''");
            this.registerType(-7, "smallint");
            this.registerType(-5, "bigint");
            this.registerType(5, "smallint");
            this.registerType(-6, "smallint");
            this.registerType(4, "integer");
            this.registerType(1, "char(1)");
            this.registerType(12, "varchar($l)");
            this.registerType(6, "float");
            this.registerType(8, "double");
            this.registerType(91, "date");
            this.registerType(92, "time");
            this.registerType(93, "timestamp");
            this.registerType(-3, "varchar($l) for bit data");
            this.registerType(2, "numeric($p,$s)");
            this.registerType(2004, "blob($l)");
            this.registerType(2005, "clob($l)");
        }

        @Override
        public String[] modifyColumn(String tableName, String columnName, String oldType, boolean oldNotNull, String newType, boolean newNotNull) {
            return null;
        }

        @Override
        public String[] dropIndexOn(String indexName, String tableName) {
            return new String[]{"DROP INDEX " + indexName};
        }

        @Override
        public String[] dropForeignKey(String table, String foreignKeyName) {
            return new String[]{"ALTER TABLE " + table + " DROP CONSTRAINT " + foreignKeyName};
        }

        @Override
        public String[] dropUniqueConstraint(String table, String constraintName) {
            return new String[]{"ALTER TABLE " + table + " DROP CONSTRAINT " + constraintName};
        }

        @Override
        public String[] renameColumn(String tableName, String oldColumnName, String newColumnName, String dataType, boolean notNull) {
            throw new RuntimeException("TODO: implement");
        }

        @Override
        public String renameTable(String oldName, String newName) {
            return "RENAME TABLE " + oldName + " TO " + newName;
        }
    }

    private static class MySQLDialect
    extends Dialect {
        MySQLDialect() {
            super("''yyyy-MM-dd HH:mm:ss''");
            this.registerType(-7, "bit");
            this.registerType(-5, "bigint");
            this.registerType(16, "boolean");
            this.registerType(5, "smallint");
            this.registerType(-6, "tinyint");
            this.registerType(4, "integer");
            this.registerType(1, "char(1)");
            this.registerType(6, "float");
            this.registerType(8, "double precision");
            this.registerType(91, "date");
            this.registerType(92, "time");
            this.registerType(93, "datetime");
            this.registerType(-3, "longblob");
            this.registerType(-3, 0xFFFFFFL, "mediumblob");
            this.registerType(-3, 65535L, "blob");
            this.registerType(-3, 255L, "tinyblob");
            this.registerType(2, "numeric($p,$s)");
            this.registerType(2004, "longblob");
            this.registerType(2004, 0xFFFFFFL, "mediumblob");
            this.registerType(2004, 65535L, "blob");
            this.registerType(2005, "longtext");
            this.registerType(2005, 0xFFFFFFL, "mediumtext");
            this.registerType(2005, 65535L, "text");
            this.registerType(12, "longtext");
            this.registerType(12, 0xFFFFFFL, "mediumtext");
            this.registerType(12, 65535L, "varchar($l)");
        }

        @Override
        public String[] dropIndexOn(String indexName, String tableName) {
            return new String[]{"DROP INDEX " + indexName + " ON " + tableName};
        }

        @Override
        public String[] dropUniqueConstraint(String table, String constraintName) {
            return new String[]{"DROP INDEX " + constraintName + " ON " + table};
        }

        @Override
        public String[] dropForeignKey(String table, String foreignKeyName) {
            return new String[]{"ALTER TABLE " + table + " DROP FOREIGN KEY " + foreignKeyName};
        }

        @Override
        public String[] modifyColumn(String tableName, String columnName, String oldType, boolean oldNotNull, String newType, boolean newNotNull) {
            StringBuilder sb = new StringBuilder("ALTER TABLE ");
            sb.append(tableName);
            sb.append(" MODIFY COLUMN ");
            sb.append(columnName);
            sb.append(' ');
            sb.append(newType);
            if (newNotNull) {
                sb.append(" NOT NULL");
            }
            return new String[]{sb.toString()};
        }

        @Override
        public String[] renameColumn(String tableName, String oldColumnName, String newColumnName, String dataType, boolean notNull) {
            StringBuilder sb = new StringBuilder("ALTER TABLE ").append(tableName).append(" CHANGE COLUMN ").append(oldColumnName).append(' ').append(newColumnName).append(' ').append(dataType);
            if (notNull) {
                sb.append(" NOT NULL");
            }
            return new String[]{sb.toString()};
        }

        @Override
        public String[] renameForeignKey(String table, String matchingFK, String oldIndex, String fkName, String[] myColumns, String referredTable, String[] referredColumns) {
            String[] toReturn = new String[oldIndex != null ? 3 : 2];
            int idx = 0;
            toReturn[idx++] = this.dropForeignKey(table, matchingFK)[0];
            if (oldIndex != null) {
                toReturn[idx++] = this.dropIndexOn(oldIndex, table)[0];
            }
            toReturn[idx] = this.addForeignKey(table, fkName, myColumns, referredTable, referredColumns)[0];
            return toReturn;
        }

        private String[] addForeignKey(String table, String fkName, String[] myColumns, String referredTable, String[] referredColumns) {
            StringBuilder sb = new StringBuilder();
            String myColumnsList = String.join((CharSequence)",", myColumns);
            String referredColumnsList = String.join((CharSequence)",", referredColumns);
            sb.append("ALTER TABLE ").append(table).append(" ADD CONSTRAINT ").append(fkName).append(" FOREIGN KEY (").append(myColumnsList).append(")").append(" REFERENCES ").append(referredTable).append('(').append(referredColumnsList).append(')');
            return new String[]{sb.toString()};
        }

        @Override
        public String renameTable(String oldName, String newName) {
            return "RENAME TABLE " + oldName + " TO " + newName;
        }

        @Override
        public String getCatalog(Connection c) throws SQLException {
            try (Statement s = c.createStatement();){
                String string;
                block12: {
                    ResultSet rs = s.executeQuery("SELECT DATABASE()");
                    try {
                        String string2 = string = rs.next() ? rs.getString(1) : null;
                        if (rs == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return string;
            }
        }

        @Override
        public String dropView(String view) {
            return "DROP VIEW IF EXISTS " + view;
        }

        @Override
        public void setFetchSize(Statement s, int fetchSize) throws SQLException {
            DatabaseMetaData md = s.getConnection().getMetaData();
            if (!md.getDriverName().toLowerCase(Locale.ROOT).contains("mariadb") || md.getDriverMajorVersion() < 2) {
                s.setFetchSize(Integer.MIN_VALUE);
                return;
            }
            s.setFetchSize(fetchSize);
        }
    }

    private static class OracleDialect
    extends Dialect {
        OracleDialect() {
            super("'timestamp'''yyyy-MM-dd HH:mm:ss''");
            this.registerType(1, "char(1 char)");
            this.registerType(12, 4000L, "varchar2($l char)");
            this.registerType(12, "long");
            this.registerType(-7, "number(1,0)");
            this.registerType(-5, "number(19,0)");
            this.registerType(16, "number(1,0)");
            this.registerType(5, "number(5,0)");
            this.registerType(-6, "number(3,0)");
            this.registerType(4, "number(10,0)");
            this.registerType(6, "float");
            this.registerType(8, "double precision");
            this.registerType(2, "number($p,$s)");
            this.registerType(3, "number($p,$s)");
            this.registerType(91, "date");
            this.registerType(92, "date");
            this.registerType(93, "timestamp");
            this.registerType(-3, 256L, "raw($l)");
            this.registerType(-3, "blob");
            this.registerType(2004, "blob");
            this.registerType(2005, "clob");
        }

        @Override
        public String[] dropIndexOn(String indexName, String tableName) {
            return new String[]{"DROP INDEX " + indexName};
        }

        @Override
        public String[] dropUniqueConstraint(String table, String constraintName) {
            return new String[]{"ALTER TABLE " + table + " DROP CONSTRAINT " + constraintName};
        }

        @Override
        public String[] dropForeignKey(String table, String foreignKeyName) {
            return new String[]{"ALTER TABLE " + table + " DROP CONSTRAINT " + foreignKeyName};
        }

        @Override
        public String dropTable(String tableName) {
            return "DROP TABLE " + tableName + " PURGE";
        }

        @Override
        public String getInsertAutoGenKey() {
            return "hibernate_sequence.NEXTVAL";
        }

        @Override
        public String[] modifyColumn(String tableName, String columnName, String oldType, boolean oldNotNull, String newType, boolean newNotNull) {
            if (oldType.equals(newType) && oldNotNull == newNotNull) {
                return null;
            }
            StringBuilder sb = new StringBuilder("ALTER TABLE ");
            sb.append(tableName);
            sb.append(" MODIFY ");
            sb.append(columnName);
            sb.append(' ');
            sb.append(newType);
            if (newNotNull != oldNotNull) {
                if (newNotNull) {
                    sb.append(" NOT");
                }
                sb.append(" NULL");
            }
            return new String[]{sb.toString()};
        }

        @Override
        public String[] renameColumn(String tableName, String oldColumnName, String newColumnName, String dataType, boolean notNull) {
            return new String[]{"ALTER TABLE " + tableName + " RENAME COLUMN " + oldColumnName + " TO " + newColumnName};
        }

        @Override
        public String renameTable(String oldName, String newName) {
            return "RENAME " + oldName + " TO " + newName;
        }

        @Override
        public String[] renameIndex(String table, String oldIndexName, String newIndexName, String[] columns) {
            return new String[]{"ALTER INDEX " + oldIndexName + " RENAME TO " + newIndexName};
        }

        @Override
        public String[] renameForeignKey(String table, String matchingFK, String oldIndexName, String fkName, String[] myColumns, String referredTable, String[] referredColumns) {
            return new String[]{"ALTER TABLE " + table + " RENAME CONSTRAINT " + matchingFK + " TO " + fkName};
        }

        @Override
        public String getSchema(Connection c) throws SQLException {
            return c.getMetaData().getUserName().toUpperCase();
        }

        @Override
        public String charLength(String column) {
            return "LENGTH(" + column + ")";
        }

        @Override
        public String substring(String column, int start, int length) {
            return "SUBSTR(" + column + "," + start + "," + length + ")";
        }

        @Override
        public PreparedStatement getPreparedStatementReturningId(Connection con, String sql) throws SQLException {
            return con.prepareStatement(sql, new String[]{"id"});
        }

        @Override
        public List<String> getSequenceNames(Connection con) throws SQLException {
            ArrayList<String> toReturn = new ArrayList<String>();
            try (Statement s = con.createStatement();
                 ResultSet rs = s.executeQuery("SELECT sequence_name FROM user_sequences");){
                while (rs.next()) {
                    toReturn.add(rs.getString(1));
                }
            }
            return toReturn;
        }
    }

    private static class Db2Dialect
    extends Db2AS400Dialect {
        public Db2Dialect() {
            this.registerType(12, "vargraphic($l)");
        }

        @Override
        public String[] dropIndexOn(String indexName, String tableName) {
            return new String[]{"DROP INDEX " + indexName, "CALL ADMIN_CMD('REORG TABLE " + tableName + " ALLOW READ ACCESS')"};
        }

        @Override
        public String[] dropUniqueConstraint(String table, String constraintName) {
            return new String[]{"ALTER TABLE " + table + " DROP CONSTRAINT " + constraintName, "CALL ADMIN_CMD('REORG TABLE " + table + " ALLOW READ ACCESS')"};
        }

        @Override
        public String[] modifyColumn(String tableName, String columnName, String oldType, boolean oldNotNull, String newType, boolean newNotNull) {
            if (oldType.equals(newType) && oldNotNull == newNotNull) {
                return null;
            }
            ArrayList<String> toReturn = new ArrayList<String>(3);
            StringBuilder sb = new StringBuilder();
            if (!oldType.equalsIgnoreCase(newType)) {
                sb.append("ALTER TABLE ");
                sb.append(tableName);
                sb.append(" ALTER COLUMN ");
                sb.append(columnName);
                sb.append(" SET DATA TYPE ");
                sb.append(newType);
                toReturn.add(sb.toString());
                sb.setLength(0);
            }
            if (oldNotNull != newNotNull) {
                sb.append("ALTER TABLE ");
                sb.append(tableName);
                sb.append(" ALTER COLUMN ");
                sb.append(columnName);
                sb.append(newNotNull ? " SET" : " DROP");
                sb.append(" NOT NULL");
                toReturn.add(sb.toString());
                sb.setLength(0);
            }
            if (!toReturn.isEmpty()) {
                sb.append("CALL ADMIN_CMD('REORG TABLE ");
                sb.append(tableName);
                sb.append(" ALLOW READ ACCESS')");
                toReturn.add(sb.toString());
            }
            return toReturn.toArray(new String[toReturn.size()]);
        }

        @Override
        public String[] renameColumn(String tableName, String oldColumnName, String newColumnName, String dataType, boolean notNull) {
            return new String[]{"ALTER TABLE " + tableName + " RENAME COLUMN " + oldColumnName + " TO " + newColumnName};
        }

        @Override
        public String charLength(String column) {
            return "LENGTH(" + column + ")";
        }

        @Override
        public String substring(String column, int start, int length) {
            return "SUBSTR(" + column + "," + start + "," + length + ")";
        }
    }

    private static class Db2AS400Dialect
    extends Dialect {
        Db2AS400Dialect() {
            super("''yyyy-MM-dd HH:mm:ss''");
            this.registerType(-7, "smallint");
            this.registerType(-5, "bigint");
            this.registerType(16, "smallint");
            this.registerType(5, "smallint");
            this.registerType(-6, "smallint");
            this.registerType(4, "integer");
            this.registerType(1, "char(1)");
            this.registerType(12, "varchar($l)");
            this.registerType(6, "float");
            this.registerType(8, "double");
            this.registerType(91, "date");
            this.registerType(92, "time");
            this.registerType(93, "timestamp");
            this.registerType(-3, "varchar($l) for bit data");
            this.registerType(2, "numeric($p,$s)");
            this.registerType(2004, "blob($l)");
            this.registerType(2005, "clob($l)");
        }

        @Override
        public String dropPrimaryKey(String table) {
            return "ALTER TABLE " + table + " DROP PRIMARY KEY";
        }

        @Override
        public String[] dropIndexOn(String indexName, String tableName) {
            return new String[]{"DROP INDEX " + indexName};
        }

        @Override
        public String[] dropUniqueConstraint(String table, String constraintName) {
            return new String[]{"ALTER TABLE " + table + " DROP CONSTRAINT " + constraintName};
        }

        @Override
        public String[] dropForeignKey(String table, String foreignKeyName) {
            return new String[]{"ALTER TABLE " + table + " DROP FOREIGN KEY " + foreignKeyName};
        }

        @Override
        public String[] modifyColumn(String tableName, String columnName, String oldType, boolean oldNotNull, String newType, boolean newNotNull) {
            if (oldType.equals(newType) && oldNotNull == newNotNull) {
                return null;
            }
            ArrayList<String> toReturn = new ArrayList<String>(3);
            StringBuilder sb = new StringBuilder();
            if (!oldType.equalsIgnoreCase(newType)) {
                sb.append("ALTER TABLE ");
                sb.append(tableName);
                sb.append(" ALTER COLUMN ");
                sb.append(columnName);
                sb.append(" SET DATA TYPE ");
                sb.append(newType);
                toReturn.add(sb.toString());
                sb.setLength(0);
            }
            if (oldNotNull != newNotNull) {
                sb.append("ALTER TABLE ");
                sb.append(tableName);
                sb.append(" ALTER COLUMN ");
                sb.append(columnName);
                sb.append(newNotNull ? " SET" : " DROP");
                sb.append(" NOT NULL");
                toReturn.add(sb.toString());
                sb.setLength(0);
            }
            return toReturn.toArray(new String[toReturn.size()]);
        }

        @Override
        public String[] renameColumn(String tableName, String oldColumnName, String newColumnName, String dataType, boolean notNull) {
            StringBuilder b = new StringBuilder();
            ArrayList<String> toReturn = new ArrayList<String>();
            b.append("ALTER TABLE ").append(tableName).append(" ADD COLUMN ").append(newColumnName + "_tmp ").append(dataType);
            toReturn.add(b.toString());
            b.setLength(0);
            b.append("UPDATE ").append(tableName).append(" set ").append(newColumnName + "_tmp=" + oldColumnName);
            toReturn.add(b.toString());
            b.setLength(0);
            b.append("ALTER TABLE ").append(tableName).append(" DROP COLUMN ").append(oldColumnName).append(" CASCADE");
            toReturn.add(b.toString());
            b.setLength(0);
            b.append("ALTER TABLE ").append(tableName).append(" ADD COLUMN ").append(newColumnName).append(" ").append(dataType);
            toReturn.add(b.toString());
            b.setLength(0);
            b.append("UPDATE ").append(tableName + " set ").append(newColumnName).append("=").append(newColumnName + "_tmp");
            toReturn.add(b.toString());
            b.setLength(0);
            b.append("ALTER TABLE ").append(tableName).append(" DROP COLUMN ").append(newColumnName).append("_tmp  CASCADE");
            toReturn.add(b.toString());
            b.setLength(0);
            if (notNull) {
                b.append("ALTER TABLE ");
                b.append(tableName);
                b.append(" ALTER COLUMN ");
                b.append(newColumnName);
                b.append(" SET");
                b.append(" NOT NULL");
                toReturn.add(b.toString());
                b.setLength(0);
            }
            return toReturn.toArray(new String[toReturn.size()]);
        }

        @Override
        public String renameTable(String oldName, String newName) {
            return "RENAME TABLE " + oldName + " TO " + newName;
        }

        @Override
        public String[] renameIndex(String table, String oldIndexName, String newIndexName, String[] columns) {
            return new String[]{"RENAME INDEX " + oldIndexName + " TO " + newIndexName};
        }

        @Override
        public String getSchema(Connection c) throws SQLException {
            try (Statement s = c.createStatement();){
                String string;
                block12: {
                    ResultSet rs = s.executeQuery("select current_schema from sysibm.sysdummy1");
                    try {
                        String string2 = string = rs.next() ? rs.getString(1) : null;
                        if (rs == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return string;
            }
        }

        @Override
        public String charLength(String column) {
            return "LENGTH(" + column + ")";
        }

        @Override
        public String substring(String column, int start, int length) {
            return "SUBSTR(" + column + "," + start + "," + length + ")";
        }

        @Override
        public List<String> getSequenceNames(Connection con) throws SQLException {
            ArrayList<String> toReturn = new ArrayList<String>();
            String schema = this.getSchema(con);
            try (Statement s = con.createStatement();
                 ResultSet rs = s.executeQuery("SELECT SEQSCHEMA,SEQNAME FROM SYSCAT.SEQUENCES");){
                while (rs.next()) {
                    if (schema != null && !schema.equalsIgnoreCase(rs.getString(1))) continue;
                    toReturn.add(rs.getString(2));
                }
            }
            return toReturn;
        }
    }

    private static class HsqlDialect
    extends Dialect {
        HsqlDialect() {
            super("''yyyy-MM-dd HH:mm:ss''");
            this.registerType(-5, "bigint");
            this.registerType(-2, "binary");
            this.registerType(-7, "bit");
            this.registerType(16, "boolean");
            this.registerType(1, "char(1)");
            this.registerType(91, "date");
            this.registerType(3, "decimal($p,$s)");
            this.registerType(8, "double");
            this.registerType(6, "float");
            this.registerType(4, "integer");
            this.registerType(-4, "longvarbinary");
            this.registerType(-1, "longvarchar");
            this.registerType(5, "smallint");
            this.registerType(-6, "tinyint");
            this.registerType(92, "time");
            this.registerType(93, "timestamp");
            this.registerType(12, "varchar($l)");
            this.registerType(-3, "varbinary($l)");
            this.registerType(2, "numeric($p,$s)");
            this.registerType(2004, "longvarbinary");
            this.registerType(2005, "longvarchar");
        }

        @Override
        public String[] dropIndexOn(String indexName, String tableName) {
            return new String[]{"DROP INDEX " + indexName + " IF EXISTS"};
        }

        @Override
        public String[] dropForeignKey(String table, String foreignKeyName) {
            return new String[]{"ALTER TABLE " + table + " DROP CONSTRAINT " + foreignKeyName};
        }

        @Override
        public String getSchema(Connection c) throws SQLException {
            return null;
        }

        @Override
        public String[] dropUniqueConstraint(String table, String constraintName) {
            return new String[]{"ALTER TABLE " + table + " DROP CONSTRAINT " + constraintName};
        }

        @Override
        public String getCatalog(Connection c) throws SQLException {
            return null;
        }

        @Override
        public String[] renameIndex(String table, String oldIndexName, String newIndexName, String[] columns) {
            return new String[]{"ALTER INDEX " + oldIndexName + " RENAME TO " + newIndexName};
        }

        @Override
        public String[] modifyColumn(String tableName, String columnName, String oldType, boolean oldNotNull, String newType, boolean newNotNull) {
            if (oldType.equals(newType) && oldNotNull == newNotNull) {
                return null;
            }
            StringBuilder sb = new StringBuilder("ALTER TABLE ");
            sb.append(tableName);
            sb.append(" ALTER COLUMN ");
            sb.append(columnName);
            sb.append(' ');
            sb.append(newType);
            if (newNotNull) {
                sb.append(" NOT NULL");
            }
            return new String[]{sb.toString()};
        }

        @Override
        public String[] renameColumn(String tableName, String oldColumnName, String newColumnName, String dataType, boolean notNull) {
            StringBuilder sb = new StringBuilder("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(oldColumnName).append(" RENAME TO ").append(newColumnName);
            return new String[]{sb.toString()};
        }

        @Override
        public String renameTable(String oldName, String newName) {
            return "ALTER TABLE " + oldName + " RENAME TO " + newName;
        }

        @Override
        public String dropView(String view) {
            return "DROP VIEW IF EXISTS " + view;
        }
    }

    private static class Hsql2Dialect
    extends HsqlDialect {
        private Hsql2Dialect() {
        }

        @Override
        public String[] dropIndexOn(String indexName, String tableName) {
            return new String[]{"DROP INDEX " + indexName + " IF EXISTS"};
        }

        @Override
        public String getSchema(Connection c) throws SQLException {
            return c.getSchema();
        }

        @Override
        public String getCatalog(Connection c) throws SQLException {
            return c.getCatalog();
        }

        @Override
        public String[] modifyColumn(String tableName, String columnName, String oldType, boolean oldNotNull, String newType, boolean newNotNull) {
            ArrayList<String> toReturn = new ArrayList<String>(2);
            StringBuilder resultBuilder = new StringBuilder();
            if (newNotNull != oldNotNull) {
                resultBuilder.append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(columnName).append(" SET").append(newNotNull ? " NOT" : "").append(" NULL");
                toReturn.add(resultBuilder.toString());
                resultBuilder.setLength(0);
            }
            if (!oldType.equalsIgnoreCase(newType)) {
                resultBuilder.append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(columnName).append(" SET DATA TYPE ").append(newType);
                toReturn.add(resultBuilder.toString());
            }
            if (toReturn.isEmpty()) {
                return null;
            }
            return toReturn.toArray(new String[toReturn.size()]);
        }

        @Override
        public List<String> getSequenceNames(Connection con) throws SQLException {
            String schema = this.getSchema(con);
            ArrayList<String> toReturn = new ArrayList<String>();
            try (Statement s = con.createStatement();
                 ResultSet rs = s.executeQuery("SELECT SEQUENCE_SCHEMA,SEQUENCE_NAME FROM INFORMATION_SCHEMA.SEQUENCES");){
                while (rs.next()) {
                    if (schema != null && !schema.equalsIgnoreCase(rs.getString(2))) continue;
                    toReturn.add(rs.getString(2));
                }
            }
            return toReturn;
        }
    }

    private static class H2Dialect
    extends Dialect {
        protected H2Dialect() {
            super("''yyyy-MM-dd hh:mm:ss''");
            this.registerType(16, "boolean");
            this.registerType(-5, "bigint");
            this.registerType(-2, "binary");
            this.registerType(-7, "bit");
            this.registerType(1, "char($l)");
            this.registerType(91, "date");
            this.registerType(3, "decimal($p,$s)");
            this.registerType(8, "double");
            this.registerType(6, "float");
            this.registerType(4, "integer");
            this.registerType(-4, "longvarbinary");
            this.registerType(-1, "longvarchar");
            this.registerType(7, "real");
            this.registerType(5, "smallint");
            this.registerType(-6, "tinyint");
            this.registerType(92, "time");
            this.registerType(93, "timestamp");
            this.registerType(12, "varchar($l)");
            this.registerType(-3, "binary($l)");
            this.registerType(2, "numeric");
            this.registerType(2004, "blob");
            this.registerType(2005, "clob");
        }

        @Override
        public String[] modifyColumn(String tableName, String columnName, String oldType, boolean oldNotNull, String newType, boolean newNotNull) {
            if (oldType.equals(newType) && oldNotNull == newNotNull) {
                return null;
            }
            StringBuilder resultBuilder = new StringBuilder("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(columnName).append(' ');
            if (oldType.equals(newType)) {
                if (newNotNull) {
                    resultBuilder.append("SET NOT NULL");
                } else {
                    resultBuilder.append("SET NULL");
                }
            } else {
                resultBuilder.append(newType);
                if (newNotNull) {
                    resultBuilder.append(" NOT NULL");
                }
            }
            return new String[]{resultBuilder.toString()};
        }

        @Override
        public String[] dropIndexOn(String indexName, String tableName) {
            return new String[]{"DROP INDEX IF EXISTS " + indexName};
        }

        @Override
        public String[] dropUniqueConstraint(String table, String constraintName) {
            return this.dropForeignKey(table, constraintName);
        }

        @Override
        public String[] dropForeignKey(String table, String foreignKeyName) {
            return new String[]{"ALTER TABLE " + table + " DROP CONSTRAINT IF EXISTS " + foreignKeyName};
        }

        @Override
        public String[] renameColumn(String tableName, String oldColumnName, String newColumnName, String dataType, boolean notNull) {
            throw new RuntimeException("TODO: implement");
        }

        @Override
        public String renameTable(String oldName, String newName) {
            return "ALTER TABLE " + oldName + " RENAME TO " + newName;
        }
    }

    private static class MssqlDialect
    extends Dialect {
        MssqlDialect() {
            super("''yyyy-MM-dd'T'HH:mm:ss''");
            this.registerType(-7, "tinyint");
            this.registerType(-5, "numeric(19,0)");
            this.registerType(16, "bit");
            this.registerType(5, "smallint");
            this.registerType(-6, "smallint");
            this.registerType(4, "int");
            this.registerType(1, "char(1)");
            this.registerType(12, "varchar($l)");
            this.registerType(6, "float");
            this.registerType(8, "double precision");
            this.registerType(91, "datetime");
            this.registerType(92, "datetime");
            this.registerType(93, "datetime");
            this.registerType(-3, "image");
            this.registerType(-3, 8000L, "varbinary($l)");
            this.registerType(2, "numeric($p,$s)");
            this.registerType(2004, "image");
            this.registerType(2005, "text");
        }

        @Override
        public String[] dropForeignKey(String table, String foreignKeyName) {
            return new String[]{"ALTER TABLE " + table + " DROP CONSTRAINT " + foreignKeyName};
        }

        @Override
        public String[] dropIndexOn(String indexName, String tableName) {
            return new String[]{"DROP INDEX IF EXISTS " + indexName + " ON " + tableName};
        }

        @Override
        public String dropPrimaryKey(String table) {
            return "DECLARE @pkn VARCHAR(1000);SELECT @pkn=CONSTRAINT_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE TABLE_NAME = '" + table + "' AND CONSTRAINT_TYPE='PRIMARY KEY';EXEC('ALTER TABLE " + table + " DROP CONSTRAINT '+@pkn)";
        }

        @Override
        public String[] dropUniqueConstraint(String table, String constraintName) {
            return new String[]{"ALTER TABLE " + table + " DROP CONSTRAINT " + constraintName};
        }

        @Override
        public String[] modifyColumn(String tableName, String columnName, String oldType, boolean oldNotNull, String newType, boolean newNotNull) {
            if (oldType.equals(newType) && oldNotNull == newNotNull) {
                return null;
            }
            StringBuilder sb = new StringBuilder("ALTER TABLE ");
            sb.append(tableName);
            sb.append(" ALTER COLUMN ");
            sb.append(columnName);
            sb.append(' ');
            sb.append(newType);
            if (newNotNull) {
                sb.append(" NOT NULL");
            }
            return new String[]{sb.toString()};
        }

        @Override
        public String addSetIdentityInsert(String sql) {
            int i;
            if (!sql.toLowerCase().startsWith("insert into ") || (i = sql.indexOf(32, 12)) < 13) {
                throw new RuntimeException("Statement must start with 'insert into <tablename> '");
            }
            String tableName = sql.substring(12, i);
            return "SET IDENTITY_INSERT " + tableName + " ON " + sql + " SET IDENTITY_INSERT " + tableName + " OFF";
        }

        @Override
        public String renameTable(String oldName, String newName) {
            return "exec sp_rename '" + oldName + "','" + newName + "'";
        }

        @Override
        public String[] renameColumn(String tableName, String oldColumnName, String newColumnName, String dataType, boolean notNull) {
            return new String[]{"exec sp_rename '" + tableName + "." + oldColumnName + "','" + newColumnName + "', 'COLUMN'"};
        }

        @Override
        public String[] renameForeignKey(String table, String matchingFK, String oldIndexName, String fkName, String[] myColumns, String referredTable, String[] referredColumns) {
            return new String[]{"exec sp_rename '" + matchingFK + "','" + fkName + "'"};
        }

        @Override
        public String getCatalog(Connection c) throws SQLException {
            try (Statement s = c.createStatement();){
                String string;
                block12: {
                    ResultSet rs = s.executeQuery("select db_name()");
                    try {
                        String string2 = string = rs.next() ? rs.getString(1) : null;
                        if (rs == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return string;
            }
        }

        @Override
        public String charLength(String column) {
            return "LEN(" + column + ")";
        }
    }

    private static class PSQLDialect
    extends Dialect {
        PSQLDialect() {
            super("''yyyy-MM-dd HH:mm:ss''");
            this.registerType(-7, "bool");
            this.registerType(-5, "int8");
            this.registerType(5, "int2");
            this.registerType(-6, "int2");
            this.registerType(4, "int4");
            this.registerType(1, "char(1)");
            this.registerType(12, "varchar($l)");
            this.registerType(6, "float4");
            this.registerType(8, "float8");
            this.registerType(91, "date");
            this.registerType(92, "time");
            this.registerType(93, "timestamp");
            this.registerType(-3, "bytea");
            this.registerType(2005, "text");
            this.registerType(2004, "bytea");
            this.registerType(16, "boolean");
            this.registerType(2, "numeric($p, $s)");
        }

        @Override
        public String[] dropIndexOn(String indexName, String tableName) {
            return new String[]{"DROP INDEX IF EXISTS " + indexName};
        }

        @Override
        public String[] dropUniqueConstraint(String table, String constraintName) {
            return new String[]{"ALTER TABLE " + table + " DROP CONSTRAINT " + constraintName};
        }

        @Override
        public String[] dropForeignKey(String table, String foreignKeyName) {
            return new String[]{"ALTER TABLE " + table + " DROP CONSTRAINT " + foreignKeyName};
        }

        @Override
        public String[] modifyColumn(String tableName, String columnName, String oldType, boolean oldNotNull, String newType, boolean newNotNull) {
            if (oldType.equals(newType) && oldNotNull == newNotNull) {
                return null;
            }
            ArrayList<String> toReturn = new ArrayList<String>(3);
            StringBuilder sb = new StringBuilder();
            if (!oldType.equals(newType)) {
                sb.append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(columnName).append(" SET DATA TYPE ").append(newType);
                toReturn.add(sb.toString());
                sb.setLength(0);
            }
            if (oldNotNull != newNotNull) {
                sb.append("ALTER TABLE ").append(tableName).append(" ALTER COLUMN ").append(columnName).append(newNotNull ? " SET" : " DROP").append(" NOT NULL");
                toReturn.add(sb.toString());
                sb.setLength(0);
            }
            return toReturn.toArray(new String[toReturn.size()]);
        }

        @Override
        public String[] renameColumn(String tableName, String oldColumnName, String newColumnName, String dataType, boolean notNull) {
            return new String[]{"ALTER TABLE " + tableName + " RENAME COLUMN " + oldColumnName + " TO " + newColumnName};
        }

        @Override
        public String getInsertAutoGenKey() {
            return "nextval('hibernate_sequence')";
        }

        @Override
        public String renameTable(String oldName, String newName) {
            return "ALTER TABLE " + oldName + " RENAME TO " + newName;
        }

        @Override
        public String getLiteralBoolean(boolean b) {
            return Boolean.toString(b);
        }

        @Override
        public String dropView(String view) {
            return "DROP VIEW IF EXISTS " + view;
        }

        @Override
        public List<String> getSequenceNames(Connection con) throws SQLException {
            ArrayList<String> toReturn = new ArrayList<String>();
            try (Statement s = con.createStatement();
                 ResultSet rs = s.executeQuery("SELECT relname FROM pg_class WHERE relkind = 'S'");){
                while (rs.next()) {
                    toReturn.add(rs.getString(1));
                }
            }
            return toReturn;
        }
    }
}

