/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.pdf.pdfbox;

import de.businesslogics.pdf.pdfbox.Alignment;
import de.businesslogics.pdf.pdfbox.Font;
import de.businesslogics.pdf.pdfbox.PDFElement;
import de.businesslogics.pdf.pdfbox.Page;
import de.businesslogics.pdf.pdfbox.Paragraph;
import de.businesslogics.pdf.pdfbox.PrintableText;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.font.PDFont;

public class Text
extends PDFElement {
    private static final float TEXT_OFFSET_RATE = 0.11f;
    private static final Map<String, String> UNICODE_REPLACEMENTS = new HashMap<String, String>();
    private static final char[] WRAP_SYMBOLS = new char[]{'/', '\\', '-', '|'};
    private boolean fillParentWidth = false;
    private Font font = Font.FONT_NORMAL;
    private final String text;
    private float textOffset;
    private final List<PrintableText> printableTexts = new ArrayList<PrintableText>();

    public Text(String text) throws IOException {
        this(text, Font.FONT_NORMAL, 0.0f, false);
    }

    public Text(String text, Font font) throws IOException {
        this(text, font, 0.0f, false);
    }

    public Text(String text, Font font, float leading) throws IOException {
        this(text, font, leading, false);
    }

    public Text(String text, Font font, float leading, boolean noLineSpacing) throws IOException {
        this(text, font, Alignment.ALIGN_BOTTOM);
        float textHeight = font.getTextHeight();
        this.height = noLineSpacing ? textHeight - 0.5f * this.textOffset : (leading >= textHeight ? leading : 1.5f * (textHeight - this.textOffset));
    }

    public Text(String text, Font font, Alignment alignment) throws IOException {
        this.text = text = Text.replaceUnicodeChars(text);
        this.font = font;
        this.textOffset = font.getSize() * 0.11f;
        this.width = 0.0f;
        this.alignment = alignment;
    }

    @Override
    public void calculateSize() throws IOException {
        PDFont pdFont = this.root.loadFont(this.font);
        if (this.isPrintable(this.text, pdFont)) {
            PrintableText pt = new PrintableText(this.text, pdFont, this.font.getSize(), this.font.getFontColor());
            pt.setParent(this);
            this.printableTexts.add(pt);
            this.width += this.font.getTextWidth(this.text);
        } else {
            Object tmp = "";
            for (int i = 0; i < this.text.length(); ++i) {
                if (this.isPrintable(this.text.charAt(i), pdFont)) {
                    tmp = (String)tmp + this.text.charAt(i);
                    continue;
                }
                if (!((String)tmp).isEmpty()) {
                    PrintableText pt = new PrintableText((String)tmp, pdFont, this.font.getSize(), this.font.getFontColor());
                    pt.setParent(this);
                    this.printableTexts.add(pt);
                    this.width += pt.getWidth();
                    tmp = "";
                }
                PrintableText pt2 = new PrintableText(String.valueOf(this.text.charAt(i)), this.root.loadFont(null), this.font.getSize(), this.font.getFontColor());
                pt2.setParent(this);
                this.printableTexts.add(pt2);
                this.width += pt2.getWidth();
            }
            if (!((String)tmp).isEmpty()) {
                PrintableText pt = new PrintableText((String)tmp, pdFont, this.font.getSize(), this.font.getFontColor());
                pt.setParent(this);
                this.printableTexts.add(pt);
                this.width += pt.getWidth();
            }
        }
    }

    @Override
    public boolean renderTo(Page page, float verticalSpaceLeft, PDStructureElement parent, COSArray markedContent) throws IOException {
        if (super.renderTo(page, verticalSpaceLeft)) {
            PrintableText previous = null;
            this.getCursor().setPosition(this.getCursor().getX(), this.getCursor().getY() - this.getHeight());
            this.styleText(page.contentStream);
            for (PrintableText pt : this.printableTexts) {
                pt.setStartPoint(previous);
                pt.setTextOffset(this.textOffset);
                pt.renderTo(page, verticalSpaceLeft, parent, markedContent);
                this.getCursor().setPosition(this.getCursor().getX() + pt.getWidth(), this.getCursor().getY());
                previous = pt;
            }
            this.isRenderedOnce = true;
            return true;
        }
        return false;
    }

    @Override
    public void setRenderedOnEachPage(boolean fixedOnPage) {
        if (fixedOnPage != this.isRenderedOnEachPage()) {
            super.setRenderedOnEachPage(fixedOnPage);
            for (PrintableText element : this.printableTexts) {
                element.setRenderedOnEachPage(this.isRenderedOnEachPage());
            }
        }
    }

    public boolean fillParentWidth() {
        return this.fillParentWidth;
    }

    public Font getFont() {
        return this.font;
    }

    public float getFontSize() {
        return this.font.getSize();
    }

    public List<PrintableText> getText() {
        return this.printableTexts;
    }

    public void setFillParentWidth(boolean fillParentWidth) {
        this.fillParentWidth = fillParentWidth;
    }

    public static String[] wrap(String word) {
        for (char symbol : WRAP_SYMBOLS) {
            int i = word.substring(0, word.length() - 1).lastIndexOf(symbol);
            if (i <= 0) continue;
            return new String[]{word.substring(0, i + 1), word.substring(i + 1)};
        }
        return new String[]{word.substring(0, word.length() - 1), word.substring(word.length() - 1)};
    }

    public static String replaceUnicodeChars(String text) {
        String result = text;
        for (Map.Entry<String, String> replacement : UNICODE_REPLACEMENTS.entrySet()) {
            result = result.replaceAll(replacement.getKey(), replacement.getValue());
        }
        return result;
    }

    private boolean isPrintable(char c, PDFont font) {
        if (c == '\n' || c == '\r') {
            return true;
        }
        return this.isPrintable(String.valueOf(c), font);
    }

    private boolean isPrintable(String text, PDFont font) {
        try {
            font.encode(text);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void styleText(PDPageContentStream content) throws IOException {
        content.setNonStrokingColor(this.font.getFontColor());
        if (this.font.isUnderline() && !this.text.trim().isEmpty()) {
            float lineWidth = 0.05f * this.font.getSize();
            content.setStrokingColor(this.font.getFontColor());
            content.setLineWidth(lineWidth);
            content.moveTo(this.getCursor().getX(), this.getCursor().getY() - lineWidth);
            content.lineTo(this.getCursor().getX() + this.getWidth(), this.getCursor().getY() - lineWidth);
            content.closeAndStroke();
        }
        if (this.parentElement instanceof Paragraph.Line) {
            this.textOffset = ((Paragraph.Line)this.parentElement).getBiggestFontSize() * 0.11f;
        }
    }

    static {
        UNICODE_REPLACEMENTS.put("\u00a0", " ");
        UNICODE_REPLACEMENTS.put("\t", "  ");
        UNICODE_REPLACEMENTS.put("\u202f", " ");
    }
}

