/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.pdf.pdfbox;

import de.businesslogics.pdf.pdfbox.Alignment;
import de.businesslogics.pdf.pdfbox.Border;
import de.businesslogics.pdf.pdfbox.PDFElement;
import de.businesslogics.pdf.pdfbox.Page;
import de.businesslogics.pdf.pdfbox.PageLayout;
import de.businesslogics.pdf.pdfbox.Paragraph;
import de.businesslogics.pdf.pdfbox.Text;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureNode;

public class Table
extends PDFElement {
    public static final int TOP = 1;
    private float cellspacing = 0.0f;
    private float[] columnWidths;
    private float headerHeight;
    private int headerRows = 0;
    private int numberOfCols;
    private float[] rowHeights;
    private boolean skipFirstHeader;
    private float widthRate = 80.0f;
    private Alignment defaultVerticalCellAlignment;
    private Color defaultCellBackgroundColor;
    private Border defaultCellBorder = Border.BOX;
    private float defaultCellBorderWidth = 0.5f;
    private Color defaultCellBorderColor = Color.black;
    private float defaultCellPaddingTop;
    private float defaultCellPaddingBottom;
    private float defaultCellPaddingLeft;
    private float defaultCellPaddingRight;
    private int defaultColspan = 1;
    private Alignment defaultHorizontalCellAlignment = null;
    private boolean useDescender = false;
    private List<Cell[]> cells = new ArrayList<Cell[]>();
    private int currentColumn = 0;
    private int lineCounter = -1;

    private Table() {
        this.structureElementType = "Table";
    }

    public Table(int numberOfCols) {
        this();
        this.numberOfCols = numberOfCols;
        this.columnWidths = new float[numberOfCols];
        for (int i = 0; i < numberOfCols; ++i) {
            this.columnWidths[i] = 1.0f / (float)numberOfCols;
        }
        this.setAlignment(Alignment.ALIGN_CENTER_HORIZONTAL);
    }

    public void addCell(PDFElement cellElement) throws IOException {
        this.addCell(cellElement, this.defaultColspan, this.defaultCellBorder, null);
    }

    public void addCell(PDFElement cellElement, int colspan) throws IOException {
        this.addCell(cellElement, colspan, this.defaultCellBorder, null);
    }

    public void addCell(PDFElement element, int colspan, Border border, Color background) throws IOException {
        this.addCell(element, 0.0f, colspan, border, background);
    }

    public void addCell(PDFElement element, float fixedCellHeight, int colspan, Border border, Color background) throws IOException {
        Cell newCell = new Cell(this, element, this, this.defaultColspan, this.defaultCellBorder, this.defaultCellBackgroundColor);
        if (colspan > 0 && colspan != this.defaultColspan) {
            newCell.setColspan(colspan);
        }
        if (this.currentColumn + newCell.getColspan() > this.numberOfCols) {
            newCell.setColspan(this.numberOfCols - this.currentColumn);
        }
        if (border != null && border != this.defaultCellBorder) {
            newCell.setBorder(border);
        }
        if (background != null && !background.equals(this.defaultCellBackgroundColor)) {
            newCell.setBackgroundColor(background);
        }
        if (fixedCellHeight > 0.0f) {
            newCell.setFixedHeight(fixedCellHeight);
        }
        if (this.currentColumn == 0) {
            this.cells.add(new Cell[this.numberOfCols]);
            ++this.lineCounter;
        }
        this.cells.get((int)this.lineCounter)[this.currentColumn] = newCell;
        this.currentColumn += newCell.getColspan();
        if (this.currentColumn == this.numberOfCols) {
            this.currentColumn = 0;
        }
    }

    @Override
    public void calculateSize() throws IOException {
        if (this.isEmpty()) {
            return;
        }
        float parentWidth = this.parentElement.getWidth() > 0.0f ? this.parentElement.getWidth() : PageLayout.A4.pageSize.getWidth();
        this.width = parentWidth * (this.widthRate / 100.0f);
        this.rowHeights = new float[this.cells.size()];
        this.headerHeight = 0.0f;
        this.height = 0.0f;
        for (int i = 0; i < this.cells.size(); ++i) {
            Cell currentCell;
            this.rowHeights[i] = 0.0f;
            for (int j = 0; j < this.numberOfCols; ++j) {
                currentCell = this.cells.get(i)[j];
                if (currentCell == null) continue;
                float columnWidth = this.columnWidths[j];
                int nextCellIndex = j + currentCell.colspan;
                for (int k = 1 + j; k < nextCellIndex; ++k) {
                    columnWidth += this.columnWidths[k];
                    ++j;
                }
                currentCell.setWidth(columnWidth * this.getWidth() - this.cellspacing);
                if (currentCell.isRenderedOnce && i >= this.headerRows) continue;
                if (!currentCell.isRenderedOnce) {
                    currentCell.setRoot(this.root);
                    currentCell.calculateSize();
                }
                this.rowHeights[i] = Math.max(this.rowHeights[i], currentCell.getHeight());
            }
            for (int k = 0; k < this.numberOfCols; ++k) {
                currentCell = this.cells.get(i)[k];
                if (currentCell == null) continue;
                currentCell.setHeight(this.rowHeights[i]);
            }
            if (i < this.headerRows) {
                this.headerHeight += this.rowHeights[i];
            }
            this.height += this.rowHeights[i];
        }
    }

    public void deleteBodyRows() {
        ArrayList<Cell[]> headerCells = new ArrayList<Cell[]>();
        for (int i = 0; i < this.headerRows; ++i) {
            headerCells.add(this.cells.get(i));
        }
        this.cells = headerCells;
        this.lineCounter = this.headerRows - 1;
        this.currentColumn = 0;
    }

    public float getCellSpacing() {
        return this.cellspacing;
    }

    public int getColumnCount() {
        return this.numberOfCols;
    }

    public float getCurrentHeight() {
        int i;
        float height = 0.0f;
        for (i = 0; i < this.headerRows; ++i) {
            height += this.rowHeights[i];
        }
        for (i = this.getFirstNotRenderedRow(); i < this.cells.size(); ++i) {
            height += this.rowHeights[i];
        }
        return height;
    }

    public float getDefaultCellPaddingTop() {
        return this.defaultCellPaddingTop;
    }

    public Alignment getDefaultHorizontalAlignment() {
        return this.defaultHorizontalCellAlignment;
    }

    public Alignment getDefaultVerticalAlignment() {
        return this.defaultVerticalCellAlignment;
    }

    @Override
    public boolean renderTo(Page page, float verticalSpaceLeft, PDStructureElement parent, COSArray markedContent) throws IOException {
        if (super.renderTo(page, verticalSpaceLeft)) {
            if (!this.isEmpty()) {
                if (!this.isEnoughSpaceFor(this.headerHeight + this.rowHeights[this.getFirstNotRenderedRow()], verticalSpaceLeft)) {
                    return false;
                }
                COSDictionary attr = new COSDictionary();
                attr.setItem(COSName.O, (COSBase)COSName.getPDFName((String)"Layout"));
                attr.setItem(COSName.getPDFName((String)"Placement"), (COSBase)COSName.getPDFName((String)"Block"));
                PDStructureElement table = new PDStructureElement(this.structureElementType, (PDStructureNode)parent);
                table.setPage(this.getCurrentPDPage());
                parent.appendKid(table);
                table.getCOSObject().setItem(COSName.A, (COSBase)attr);
                this.height = this.getCurrentHeight();
                this.fillMissingCells();
                this.renderStyle(page, verticalSpaceLeft);
                if (!this.skipFirstHeader && this.headerRows > 0) {
                    this.printHeaderRows(page, verticalSpaceLeft, table, markedContent);
                } else {
                    this.skipFirstHeader = false;
                }
                verticalSpaceLeft -= this.headerHeight;
                for (int i = this.getFirstNotRenderedRow(); i < this.cells.size(); ++i) {
                    if (!this.isEnoughSpaceFor(this.rowHeights[i], verticalSpaceLeft)) {
                        return false;
                    }
                    PDStructureElement currentRow = new PDStructureElement("TR", (PDStructureNode)table);
                    currentRow.setPage(this.getCurrentPDPage());
                    if (!this.printRow(page, verticalSpaceLeft, this.cells.get(i), this.rowHeights[i], false, currentRow, markedContent)) {
                        return false;
                    }
                    verticalSpaceLeft -= this.rowHeights[i];
                    table.appendKid(currentRow);
                }
            }
            this.isRenderedOnce = true;
            return true;
        }
        return false;
    }

    public void setDefaultVerticalCellAlignment(Alignment cellAlignment) {
        this.defaultVerticalCellAlignment = cellAlignment;
    }

    public Color getDefaultCellBackgroundColor() {
        return this.defaultCellBackgroundColor;
    }

    public void setDefaultCellBackgroundColor(Color color) {
        this.defaultCellBackgroundColor = color;
    }

    public void setDefaultCellBorder(Border border) {
        this.defaultCellBorder = border;
    }

    public Color getDefaultCellBorderColor() {
        return this.defaultCellBorderColor;
    }

    public void setDefaultCellBorderColor(Color color) {
        this.defaultCellBorderColor = color;
    }

    public void setDefaultCellBorderSize(float width) {
        this.defaultCellBorderWidth = width;
    }

    public void setDefaultCellPadding(float padding) {
        this.defaultCellPaddingTop = padding;
        this.defaultCellPaddingBottom = padding;
        this.defaultCellPaddingLeft = padding;
        this.defaultCellPaddingRight = padding;
    }

    public void setDefaultCellPaddingBottom(float padding) {
        this.defaultCellPaddingBottom = padding;
    }

    public void setDefaultCellPaddingTop(float padding) {
        this.defaultCellPaddingTop = padding;
    }

    public void setDefaultColspan(int colspan) {
        this.defaultColspan = colspan;
    }

    public void setHeaderRows(int rows) {
        this.headerRows = rows;
    }

    @Override
    public void setRenderedOnEachPage(boolean fixedOnPage) {
        if (fixedOnPage != this.isRenderedOnEachPage()) {
            super.setRenderedOnEachPage(fixedOnPage);
            for (Cell[] row : this.cells) {
                for (Cell cell : row) {
                    if (cell == null) continue;
                    cell.setRenderedOnEachPage(this.isRenderedOnEachPage());
                }
            }
        }
    }

    public void setSkipFirstHeader(boolean skipFirstHeader) {
        this.skipFirstHeader = skipFirstHeader;
    }

    public void setSpacing(float spacing) {
        this.cellspacing = spacing;
    }

    public void setDefaultHorizontalCellAlignment(Alignment alignment) {
        this.defaultHorizontalCellAlignment = alignment;
    }

    public void setUseDescender(boolean value) {
        this.useDescender = value;
    }

    @Override
    public void setWidth(float widthRate) {
        this.widthRate = widthRate;
    }

    public void setWidths(float[] widths) {
        this.columnWidths = widths;
    }

    boolean isEmpty() {
        return this.cells.size() <= this.headerRows;
    }

    private void fillMissingCells() throws IOException {
        while (this.currentColumn != 0) {
            this.addCell(new Text(""), 0, null, null);
        }
    }

    private int getFirstNotRenderedRow() {
        if (this.isRenderedOnEachPage()) {
            return 0;
        }
        for (int i = this.headerRows; i < this.cells.size(); ++i) {
            for (int j = 0; j < this.numberOfCols; ++j) {
                Cell currentCell = this.cells.get(i)[j];
                if (currentCell == null || currentCell.isRenderedOnce) continue;
                return i;
            }
        }
        return this.cells.size();
    }

    private void printHeaderRows(Page page, float verticalSpaceLeft, PDStructureElement table, COSArray markedContent) throws IOException {
        for (int i = 0; i < this.headerRows; ++i) {
            PDStructureElement currentRow = new PDStructureElement("TR", (PDStructureNode)table);
            currentRow.setPage(this.getCurrentPDPage());
            if ((double)(this.getCursor().getY() - this.rowHeights[i]) + 0.1 < (double)(this.parentElement.getStartPoint().getY() - this.parentElement.getHeight())) {
                return;
            }
            this.printRow(page, verticalSpaceLeft, this.cells.get(i), this.rowHeights[i], true, currentRow, markedContent);
            table.appendKid(currentRow);
        }
    }

    private boolean printRow(Page page, float verticalSpaceLeft, Cell[] row, float height, boolean isHeaderRow, PDStructureElement tableRow, COSArray markedContent) throws IOException {
        boolean renderedCompletly = true;
        this.getCursor().setPosition(this.getCursor().getX() + this.cellspacing / 2.0f, this.getCursor().getY() - this.cellspacing / 2.0f);
        Cell previous = null;
        COSDictionary attr = new COSDictionary();
        attr.setItem(COSName.O, (COSBase)COSName.getPDFName((String)"Layout"));
        attr.setItem(COSName.getPDFName((String)"Placement"), (COSBase)COSName.getPDFName((String)"Block"));
        tableRow.getCOSObject().setItem(COSName.A, (COSBase)attr);
        for (int j = 0; j < this.numberOfCols; ++j) {
            Cell currentCell = row[j];
            if (currentCell == null) continue;
            PDStructureElement currentData = new PDStructureElement(isHeaderRow ? "TH" : "TD", (PDStructureNode)tableRow);
            currentData.setPage(this.getCurrentPDPage());
            COSArray cellAttr = new COSArray();
            COSDictionary table = new COSDictionary();
            table.setItem(COSName.O, (COSBase)COSName.getPDFName((String)"Table"));
            table.setItem(COSName.getPDFName((String)"Scope"), (COSBase)(isHeaderRow ? COSName.getPDFName((String)"Column") : COSName.getPDFName((String)"None")));
            if (isHeaderRow) {
                currentData.getCOSObject().setString(COSName.ID, "Header" + (j + 1));
            }
            if (currentCell.colspan > 1) {
                table.setInt(COSName.getPDFName((String)"ColSpan"), currentCell.colspan);
            }
            if (isHeaderRow || currentCell.colspan > 1) {
                cellAttr.add((COSBase)table);
            }
            COSDictionary layout = new COSDictionary();
            layout.setItem(COSName.O, (COSBase)COSName.getPDFName((String)"Layout"));
            layout.setItem(COSName.getPDFName((String)"Placement"), (COSBase)COSName.getPDFName((String)"Inline"));
            cellAttr.add((COSBase)layout);
            currentData.getCOSObject().setItem(COSName.A, (COSBase)cellAttr);
            currentCell.setStartPoint(previous);
            currentCell.isRenderedOnce = false;
            if (isHeaderRow) {
                currentCell.setRenderedOnEachPage(true);
            }
            if (!currentCell.renderTo(page, verticalSpaceLeft, currentData, markedContent)) {
                renderedCompletly = false;
            }
            this.getCursor().setPosition(this.getCursor().getX() + currentCell.getWidth() + this.cellspacing, this.getCursor().getY());
            previous = currentCell;
            tableRow.appendKid(currentData);
        }
        this.getCursor().setPosition(this.getStartPoint().getX(), this.getCursor().getY() - (this.cellspacing / 2.0f + height));
        return renderedCompletly;
    }

    protected class Cell
    extends PDFElement {
        PDFElement element;
        int colspan = 1;
        float paddingTop;
        float paddingBottom;
        float paddingLeft;
        float paddingRight;

        public Cell(Table this$0, PDFElement element, Table parent, int colspan, Border border, Color background) throws IOException {
            this.parentElement = parent;
            if (this$0.defaultCellPaddingTop > 0.0f) {
                this.paddingTop = this$0.defaultCellPaddingTop;
            }
            if (this$0.defaultCellPaddingBottom > 0.0f) {
                this.paddingBottom = this$0.defaultCellPaddingBottom;
            }
            if (this$0.defaultCellPaddingLeft > 0.0f) {
                this.paddingLeft = this$0.defaultCellPaddingLeft;
            }
            if (this$0.defaultCellPaddingRight > 0.0f) {
                this.paddingRight = this$0.defaultCellPaddingRight;
            }
            this.colspan = colspan;
            this.setBorder(border);
            this.setBorderSize(parent.defaultCellBorderWidth);
            this.setBorderColor(parent.defaultCellBorderColor);
            this.setBackgroundColor(background);
            this.setCellElement(element);
            this.structureElementType = "TD";
        }

        @Override
        public void calculateSize() throws IOException {
            this.element.setRoot(this.root);
            this.element.calculateSize();
            this.element.setFixedHeight(this.fixedHeight - this.element.getMarginVertical());
            this.height = Math.min(this.element.getHeight() + this.element.getMarginVertical(), PageLayout.A4.getLayout().getHeight());
        }

        @Override
        public boolean renderTo(Page page, float verticalSpaceLeft, PDStructureElement currentData, COSArray markedContent) throws IOException {
            if (super.renderTo(page, verticalSpaceLeft)) {
                this.element.setStartPoint((PDFElement)null);
                this.renderStyle(page, verticalSpaceLeft);
                this.element.renderTo(page, verticalSpaceLeft, currentData, markedContent);
                this.isRenderedOnce = this.element.isRenderedOnce;
                return this.isRenderedOnce;
            }
            return false;
        }

        @Override
        public void setRenderedOnEachPage(boolean renderOnEachPage) {
            if (renderOnEachPage != this.isRenderedOnEachPage()) {
                super.setRenderedOnEachPage(renderOnEachPage);
                this.element.setRenderedOnEachPage(this.isRenderedOnEachPage());
            }
        }

        public int getColspan() {
            return this.colspan;
        }

        public void setColspan(int colspan) {
            this.colspan = colspan;
        }

        private void setCellElement(PDFElement element) throws IOException {
            Table parent = (Table)this.parentElement;
            if (element instanceof Text) {
                Paragraph p = new Paragraph();
                p.add(element);
                p.setAlignment(parent.getDefaultVerticalAlignment());
                p.setTextAlignment(parent.getDefaultHorizontalAlignment());
                if (element.getAlignment() != null) {
                    p.setTextAlignment(element.getAlignment());
                }
                element.setAlignment(null);
                this.element = p;
            } else {
                this.element = element;
            }
            if (this.element instanceof Paragraph) {
                ((Paragraph)this.element).noLineSpacing = true;
                ((Paragraph)this.element).leading = 0.0f;
            }
            if (!(this.element instanceof Table)) {
                float paddingOffset = 1.5f;
                this.element.setMarginTop(this.paddingTop > paddingOffset ? this.paddingTop : paddingOffset + this.paddingTop);
                this.element.setMarginLeft(this.paddingLeft > paddingOffset ? this.paddingLeft : paddingOffset + this.paddingLeft);
                this.element.setMarginRight((this.paddingRight > paddingOffset ? this.paddingRight : paddingOffset + this.paddingRight) + element.getMarginRight());
                float paddingOffsetBottom = ((Table)this.parentElement).useDescender ? paddingOffset + 2.0f : paddingOffset;
                this.element.setMarginBottom(this.paddingBottom > paddingOffsetBottom ? this.paddingBottom : paddingOffsetBottom + this.paddingBottom);
            }
            this.element.parentElement = this;
        }
    }
}

