/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.pdf.pdfbox;

import de.businesslogics.pdf.pdfbox.Font;
import de.businesslogics.pdf.pdfbox.PDFElement;
import de.businesslogics.pdf.pdfbox.Page;
import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.font.PDFont;

public class PrintableText
extends PDFElement {
    private final PDFont font;
    private final Color fontColor;
    private final float fontSize;
    private final boolean isUnderline;
    private final String text;
    private float textOffset;

    public PrintableText(String text, PDFont font, float fontSize, Color fontColor) throws IOException {
        this(text, font, fontSize, fontColor, false);
    }

    public PrintableText(String text, PDFont font, float fontSize, Color fontColor, boolean isUnderline) throws IOException {
        this.text = text;
        this.font = font;
        this.fontSize = fontSize;
        this.fontColor = fontColor;
        this.isUnderline = isUnderline;
        this.width = Font.getTextWidth(font, fontSize, text);
    }

    @Override
    public void calculateSize() throws IOException {
    }

    @Override
    public boolean renderTo(Page page, float verticalSpaceLeft, PDStructureElement parent, COSArray markedContent) throws IOException {
        if (super.renderTo(page, verticalSpaceLeft)) {
            this.getCursor().setPosition(this.getCursor().getX(), this.getCursor().getY() - this.getHeight());
            this.styleText(page.contentStream);
            this.writeText(page.contentStream);
            this.isRenderedOnce = true;
            return true;
        }
        return false;
    }

    public String getText() {
        return this.text;
    }

    public void setTextOffset(float textOffset) {
        this.textOffset = textOffset;
    }

    private void styleText(PDPageContentStream content) throws IOException {
        content.setNonStrokingColor(this.fontColor);
        if (this.isUnderline && !this.text.trim().isEmpty()) {
            float lineWidth = 0.05f * this.fontSize;
            content.setStrokingColor(this.fontColor);
            content.setLineWidth(lineWidth);
            content.moveTo(this.getCursor().getX(), this.getCursor().getY() - lineWidth);
            content.lineTo(this.getCursor().getX() + this.getWidth(), this.getCursor().getY() - lineWidth);
            content.closeAndStroke();
        }
    }

    private void writeText(PDPageContentStream content) throws IOException {
        content.setFont(this.font, this.fontSize);
        content.beginText();
        content.newLineAtOffset(this.getCursor().getX(), this.getCursor().getY() + this.textOffset);
        content.showText(Font.getPrintableString(this.font, this.text));
        content.endText();
    }
}

