/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.pdf.pdfbox;

import de.businesslogics.pdf.pdfbox.Alignment;
import de.businesslogics.pdf.pdfbox.Font;
import de.businesslogics.pdf.pdfbox.PDFElement;
import de.businesslogics.pdf.pdfbox.Page;
import de.businesslogics.pdf.pdfbox.PageLayout;
import de.businesslogics.pdf.pdfbox.PrintableText;
import de.businesslogics.pdf.pdfbox.Text;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureNode;
import org.apache.pdfbox.pdmodel.documentinterchange.markedcontent.PDMarkedContent;
import org.apache.pdfbox.pdmodel.documentinterchange.markedcontent.PDPropertyList;

public class Paragraph
extends PDFElement {
    private List<PDFElement> elements = new ArrayList<PDFElement>();
    private List<Line> lines = new ArrayList<Line>();
    protected float leading;
    protected boolean noLineSpacing = false;
    private Alignment textAlignment = null;
    COSDictionary currentMarkedContentDictionary;

    public Paragraph() {
        this.structureElementType = "P";
    }

    public Paragraph(Alignment alignment) {
        this();
        this.setAlignment(alignment);
    }

    public Paragraph(float leading) {
        this();
        if (leading == 0.0f) {
            this.noLineSpacing = true;
        }
        this.leading = leading;
    }

    public Paragraph(String text) throws IOException {
        this();
        this.addText(text);
    }

    public Paragraph(String text, Font font) throws IOException {
        this();
        this.addText(text, font);
    }

    public Paragraph(String text, Font font, Alignment textAlignment) throws IOException {
        this();
        this.addText(text, font);
        this.textAlignment = textAlignment;
    }

    public Paragraph(float leading, String text, Font font) throws IOException {
        this(leading);
        this.addText(text, font);
    }

    public Paragraph(float leading, String text, Font font, Alignment textAlignment) throws IOException {
        this(leading);
        this.addText(text, font);
        this.textAlignment = textAlignment;
    }

    public void add(PDFElement element) {
        this.elements.add(element);
        element.setParent(this);
    }

    public void addText(String text) throws IOException {
        this.addText(text, Font.FONT_NORMAL);
    }

    public void addText(String text, Font font) throws IOException {
        this.addText(text, font, this.alignment);
    }

    public void addText(String text, Font font, Alignment alignment) throws IOException {
        this.add(new Text(text, font, this.leading, this.noLineSpacing));
        this.alignment = alignment;
    }

    public void addText(String text, Font font, Alignment alignment, boolean fillWidth) throws IOException {
        Text toAdd = new Text(text, font, this.leading, this.noLineSpacing);
        toAdd.setFillParentWidth(fillWidth);
        this.add(toAdd);
        this.alignment = alignment;
    }

    @Override
    public void calculateSize() throws IOException {
        if (!this.lines.isEmpty()) {
            this.height = 0.0f;
            for (Line line : this.lines) {
                if (line.isRenderedOnce) continue;
                this.height += line.getHeight();
            }
        } else {
            float parentWidth = this.parentElement.getWidth() > 0.0f ? this.parentElement.getWidth() : PageLayout.A4.pageSize.getWidth();
            this.width = parentWidth - this.getMarginHorizontal();
            Line currentLine = new Line(this);
            Object line = "";
            for (PDFElement element : this.elements) {
                if (element instanceof Text) {
                    Text textElement = (Text)element;
                    textElement.setRoot(this.root);
                    textElement.calculateSize();
                    for (PrintableText pt : textElement.getText()) {
                        String[] textLines = pt.getText().split("\r?\n", -1);
                        for (int i = 0; i < textLines.length; ++i) {
                            if (i > 0) {
                                currentLine.addElement(new Text((String)line, textElement.getFont(), textElement.getHeight(), this.noLineSpacing));
                                this.addLine(currentLine);
                                line = "";
                                currentLine = new Line(this);
                            }
                            if (currentLine.getWidth() + pt.getWidth() > this.getWidth()) {
                                String[] words = textLines[i].split("\\s");
                                for (int j = 0; j < words.length; ++j) {
                                    Object word = words[j];
                                    while (currentLine.getWidth() + textElement.getFont().getTextWidth((String)line + (String)word) > this.getWidth()) {
                                        if (currentLine.isEmpty() && ((String)line).isEmpty()) {
                                            String part1 = word;
                                            Object part2 = "";
                                            do {
                                                String[] wrappedWord = Text.wrap(part1);
                                                part1 = wrappedWord[0];
                                                part2 = wrappedWord[1] + (String)part2;
                                            } while (currentLine.getWidth() + textElement.getFont().getTextWidth(part1) > this.getWidth());
                                            line = (String)line + part1;
                                            word = part2;
                                        }
                                        if (!Pattern.matches("^\\s{2}.*", (CharSequence)line)) {
                                            line = ((String)line).trim();
                                        }
                                        if (i == 0 && !currentLine.isEmpty()) {
                                            line = " " + (String)line;
                                        }
                                        currentLine.addElement(new Text((String)line, textElement.getFont(), textElement.getHeight(), this.noLineSpacing));
                                        this.addLine(currentLine);
                                        line = "";
                                        currentLine = new Line(this);
                                    }
                                    line = (String)line + (String)word + " ";
                                }
                                continue;
                            }
                            line = textLines[i];
                            if (i == 0 && !currentLine.isEmpty()) {
                                line = " " + (String)line;
                                continue;
                            }
                            if (i != 0 || !textElement.fillParentWidth()) continue;
                            while (textElement.getFont().getTextWidth((String)line) < this.getWidth()) {
                                line = (String)line + " ";
                            }
                        }
                        if (((String)line).isEmpty()) continue;
                        currentLine.addElement(new Text((String)line, textElement.getFont(), textElement.getHeight(), this.noLineSpacing));
                        line = "";
                    }
                    continue;
                }
                if (!currentLine.isEmpty()) {
                    this.addLine(currentLine);
                    currentLine = new Line(this);
                }
                currentLine.addElement(element);
                this.addLine(currentLine);
                currentLine = new Line(this);
            }
            if (!currentLine.isEmpty()) {
                this.addLine(currentLine);
            }
        }
    }

    @Override
    public boolean renderTo(Page page, float verticalSpaceLeft, PDStructureElement parent, COSArray markedContent) throws IOException {
        if (super.renderTo(page, verticalSpaceLeft)) {
            PDStructureElement p = new PDStructureElement(this.structureElementType, (PDStructureNode)parent);
            p.setPage(this.getCurrentPDPage());
            Line previous = null;
            for (Line line : this.lines) {
                if (this.currentMarkedContentDictionary == null) {
                    this.currentMarkedContentDictionary = new COSDictionary();
                    this.currentMarkedContentDictionary.setInt(COSName.MCID, markedContent.size());
                    page.contentStream.beginMarkedContent(COSName.P, PDPropertyList.create((COSDictionary)this.currentMarkedContentDictionary));
                }
                if (!this.isEnoughSpaceFor(line.getHeight(), verticalSpaceLeft)) {
                    page.contentStream.endMarkedContent();
                    if (this.currentMarkedContentDictionary.size() > 0) {
                        PDMarkedContent currentContent = new PDMarkedContent(COSName.P, this.currentMarkedContentDictionary);
                        p.appendKid(currentContent);
                        markedContent.add((COSBase)p.getCOSObject());
                        parent.appendKid(p);
                    }
                    this.currentMarkedContentDictionary = null;
                    this.renderStyle(page, verticalSpaceLeft);
                    return false;
                }
                line.setStartPoint(previous);
                if (!line.renderTo(page, verticalSpaceLeft, p, markedContent)) continue;
                this.getCursor().setPosition(this.getCursor().getX(), this.getCursor().getY() - line.getHeight());
                previous = line;
                verticalSpaceLeft -= line.getHeight() + line.getMarginVertical();
            }
            this.isRenderedOnce = true;
            if (this.currentMarkedContentDictionary != null) {
                page.contentStream.endMarkedContent();
                if (this.currentMarkedContentDictionary.size() > 0) {
                    PDMarkedContent currentContent = new PDMarkedContent(COSName.P, this.currentMarkedContentDictionary);
                    p.appendKid(currentContent);
                    markedContent.add((COSBase)p.getCOSObject());
                    parent.appendKid(p);
                }
                this.currentMarkedContentDictionary = null;
            }
            this.renderStyle(page, verticalSpaceLeft);
            return true;
        }
        return false;
    }

    @Override
    public void setRenderedOnEachPage(boolean fixedOnPage) {
        if (fixedOnPage != this.isRenderedOnEachPage()) {
            super.setRenderedOnEachPage(fixedOnPage);
            for (PDFElement pDFElement : this.lines) {
                pDFElement.setRenderedOnEachPage(this.isRenderedOnEachPage());
            }
        }
    }

    public void setTextAlignment(Alignment textAlignment) {
        this.textAlignment = textAlignment;
    }

    private void addLine(Line line) throws IOException {
        line.setRoot(this.root);
        this.lines.add(line);
        line.calculateSize();
        this.height += line.getHeight();
    }

    class Line
    extends PDFElement {
        float biggestFontSize;
        List<PDFElement> elements = new ArrayList<PDFElement>();

        public Line(Paragraph parent) {
            this.root = parent.root;
            this.parentElement = parent;
            this.alignment = parent.textAlignment;
        }

        public void addElement(PDFElement element) throws IOException {
            element.setRoot(this.root);
            element.calculateSize();
            this.elements.add(element);
            this.width += element.getWidth();
            element.setParent(this);
        }

        @Override
        public void calculateSize() throws IOException {
            for (PDFElement element : this.elements) {
                if (element.isRenderedOnce) continue;
                this.setHeight(Math.max(this.getHeight(), element.getHeight()));
                if (!(element instanceof Text)) continue;
                this.setBiggestFontSize(Math.max(((Text)element).getFontSize(), this.biggestFontSize));
            }
        }

        public float getBiggestFontSize() {
            return this.biggestFontSize;
        }

        public void setBiggestFontSize(float biggestFontSize) {
            this.biggestFontSize = biggestFontSize;
        }

        public boolean isEmpty() {
            return this.elements.isEmpty();
        }

        @Override
        public boolean renderTo(Page page, float verticalSpaceLeft, PDStructureElement parent, COSArray markedContent) throws IOException {
            if (super.renderTo(page, verticalSpaceLeft)) {
                PDFElement previous = null;
                this.getCursor().setPosition(this.getCursor().getX(), this.getCursor().getY() - this.getHeight());
                for (PDFElement element : this.elements) {
                    if (!(element instanceof Text)) {
                        if (Paragraph.this.currentMarkedContentDictionary != null) {
                            page.contentStream.endMarkedContent();
                            if (Paragraph.this.currentMarkedContentDictionary.size() > 0) {
                                PDMarkedContent currentContent = new PDMarkedContent(COSName.P, Paragraph.this.currentMarkedContentDictionary);
                                parent.appendKid(currentContent);
                                markedContent.add((COSBase)parent.getCOSObject());
                                parent.getParent().appendKid(parent);
                            }
                            Paragraph.this.currentMarkedContentDictionary = null;
                        }
                        parent = (PDStructureElement)parent.getParent();
                    }
                    this.getCursor().setY(this.getCursor().getY() + element.getHeight());
                    element.setStartPoint(previous);
                    element.renderTo(page, verticalSpaceLeft, parent, markedContent);
                    this.getCursor().setPosition(this.getCursor().getX() + element.getWidth(), this.getCursor().getY() - element.getHeight());
                    previous = element;
                }
                this.renderStyle(page, verticalSpaceLeft);
                this.isRenderedOnce = true;
                return true;
            }
            return false;
        }

        @Override
        public void setRenderedOnEachPage(boolean fixedOnPage) {
            if (fixedOnPage != this.isRenderedOnEachPage()) {
                super.setRenderedOnEachPage(fixedOnPage);
                for (PDFElement element : this.elements) {
                    element.setRenderedOnEachPage(this.isRenderedOnEachPage());
                }
            }
        }
    }
}

