/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.pdf.pdfbox;

import de.businesslogics.pdf.pdfbox.Document;
import de.businesslogics.pdf.pdfbox.Image;
import de.businesslogics.pdf.pdfbox.PDFBaseElement;
import de.businesslogics.pdf.pdfbox.PDFElement;
import de.businesslogics.pdf.pdfbox.Paragraph;
import de.businesslogics.pdf.pdfbox.Text;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;

public class Page
extends PDFElement {
    private final PDRectangle PAGE_SIZE;
    private Paragraph currentParagraph;
    List<PDFElement> pageElements = new ArrayList<PDFElement>();
    public PDPage page;
    public PDPageContentStream contentStream;

    public Page(Document document) throws IOException {
        this(document, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Page(Document document, float marginLeft, float marginRight, float marginTop, float marginBottom) throws IOException {
        this.parentElement = document;
        this.root = document;
        this.page = this.setupPage(document.getPageSize());
        this.PAGE_SIZE = document.getPageSize();
        this.setMargin(marginLeft, marginRight, marginTop, marginBottom);
        this.height = this.PAGE_SIZE.getHeight() - this.getMarginVertical();
        this.width = this.PAGE_SIZE.getWidth() - this.getMarginHorizontal();
    }

    public void addElement(PDFElement element) {
        if (element instanceof Text) {
            if (this.currentParagraph == null) {
                this.currentParagraph = new Paragraph();
                this.pageElements.add(this.currentParagraph);
                this.currentParagraph.setParent(this);
                this.currentParagraph.setRoot(this.root);
            }
            this.currentParagraph.add(element);
        } else {
            if (this.currentParagraph != null) {
                this.currentParagraph = null;
            }
            this.pageElements.add(element);
            element.setParent(this);
        }
    }

    @Override
    public void calculateSize() throws IOException {
        this.height = this.PAGE_SIZE.getHeight() - this.getMarginVertical();
        this.width = this.PAGE_SIZE.getWidth() - this.getMarginHorizontal();
        for (PDFElement element : this.pageElements) {
            if (element.isRenderedOnce) continue;
            element.setRoot(this.root);
            element.calculateSize();
        }
    }

    public PDRectangle getPageSize() {
        return this.PAGE_SIZE;
    }

    public boolean isEmpty() {
        return this.pageElements.isEmpty();
    }

    public void pageBreak() throws IOException {
        this.contentStream.close();
        this.page = this.setupPage(this.PAGE_SIZE);
        this.contentStream = new PDPageContentStream(((Document)this.parentElement).getPDF(), this.page, PDPageContentStream.AppendMode.OVERWRITE, false);
    }

    public boolean render(PDStructureElement parent, COSArray markedContent, Document document) throws IOException {
        this.calculateSize();
        this.setStartPoint(new PDFBaseElement.Point(this, this.PAGE_SIZE.getLowerLeftX() + this.getMarginLeft(), this.PAGE_SIZE.getUpperRightY() - this.getMarginTop()));
        this.contentStream = new PDPageContentStream(document.getPDF(), this.page, PDPageContentStream.AppendMode.OVERWRITE, false);
        return this.renderTo(this, this.getHeight(), parent, markedContent);
    }

    @Override
    public boolean renderTo(Page page, float verticalSpaceLeft, PDStructureElement parent, COSArray markedContent) throws IOException {
        if (super.renderTo(page, verticalSpaceLeft)) {
            this.renderStyle(page, verticalSpaceLeft);
            PDFElement previous = null;
            for (PDFElement element : this.pageElements) {
                if (element.isRenderedOnce && !element.isRenderedOnEachPage()) continue;
                element.setStartPoint(previous);
                if (!element.renderTo(page, verticalSpaceLeft, parent, markedContent)) {
                    return false;
                }
                verticalSpaceLeft -= element.getHeight() + element.getMarginVertical();
                this.updatePosition(element);
                previous = element;
            }
            this.isRenderedOnce = true;
            return true;
        }
        return false;
    }

    public static Page getDummy(PDRectangle pageSize) throws IOException {
        Document dummyDoc = new Document(pageSize, 0.0f, 0.0f, 0.0f, 0.0f);
        return Page.getDummy(pageSize, dummyDoc);
    }

    public static Page getDummy(PDRectangle pageSize, Document document) throws IOException {
        Page dummyPage;
        Page page = dummyPage = new Page(document, document.getMarginLeft(), document.getMarginRight(), document.getMarginTop(), document.getMarginBottom());
        Objects.requireNonNull(page);
        dummyPage.setStartPoint(new PDFBaseElement.Point(page, dummyPage.getPageSize().getLowerLeftX() + dummyPage.getMarginLeft(), dummyPage.getPageSize().getUpperRightY() - dummyPage.getMarginTop()));
        dummyPage.initCursor();
        return dummyPage;
    }

    private PDPage setupPage(PDRectangle size) {
        PDPage newPage = new PDPage(size);
        newPage.getCOSObject().setItem(COSName.getPDFName((String)"Tabs"), (COSBase)COSName.S);
        newPage.getCOSObject().setItem(COSName.CROP_BOX, (COSObjectable)newPage.getCropBox());
        newPage.getCOSObject().setItem(COSName.ROTATE, (COSBase)COSInteger.get((long)0L));
        newPage.getCOSObject().setItem(COSName.STRUCT_PARENTS, (COSBase)COSInteger.get((long)0L));
        return newPage;
    }

    private void updatePosition(PDFElement element) {
        if (element instanceof Image) {
            return;
        }
        this.getCursor().setPosition(this.getStartPoint().getX(), element.getCursor().getY());
    }
}

