/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.pdf.pdfbox;

import de.businesslogics.pdf.pdfbox.Alignment;
import de.businesslogics.pdf.pdfbox.Border;
import de.businesslogics.pdf.pdfbox.Document;
import de.businesslogics.pdf.pdfbox.PDFBaseElement;
import de.businesslogics.pdf.pdfbox.Page;
import de.businesslogics.pdf.pdfbox.Paragraph;
import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;

public abstract class PDFElement
extends PDFBaseElement
implements de.businesslogics.pdf.PDFElement<PDFElement> {
    public static final float ROUNDING_ERROR_COMPENSATION = 0.1f;
    private Border border = Border.NO_BORDER;
    private float borderWidth = 0.5f;
    private boolean renderedOnEachPage = false;
    protected Document root;
    protected boolean isRenderedOnce = false;
    Alignment alignment;
    Color borderColor = Color.black;
    Color backgroundColor;
    PDFBaseElement.Point cursor;
    PDFBaseElement parentElement;
    String structureElementType;

    protected PDFElement() {
    }

    public abstract void calculateSize() throws IOException;

    public void align() {
        float xPos = this.getAlignment().getXPos(this.startPoint.getX(), this.getWidth(), this.parentElement.getStartPoint(), this.parentElement.getWidth());
        float yPos = this.getAlignment().getYPos(this.startPoint.getY(), this.getHeight(), this.parentElement.getStartPoint(), this.parentElement.getHeight());
        this.startPoint.setPosition(xPos, yPos);
    }

    public void drawBorder(Page content, float verticalSpaceLeft) throws IOException {
        this.border.draw(content.contentStream, this.getStartPoint(), this.getWidth(), Math.min(this.getHeight(), verticalSpaceLeft), this.borderWidth, this.borderColor);
    }

    public void fillBackgroundColor(PDPageContentStream content, float verticalSpaceLeft) throws IOException {
        content.beginMarkedContent(COSName.ARTIFACT);
        content.setNonStrokingColor(this.backgroundColor);
        float offset = this.hasBorder() ? this.borderWidth / 2.0f : 0.0f;
        float height = Math.min(this.getHeight(), verticalSpaceLeft);
        content.addRect(this.startPoint.getX() + offset, this.startPoint.getY() - height + offset, this.getWidth() - 2.0f * offset, height - 2.0f * offset);
        content.fill();
        content.endMarkedContent();
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public Border getBorder() {
        return this.border;
    }

    public PDFBaseElement.Point getCursor() {
        return this.cursor;
    }

    @Override
    public int getCurrentMCID() {
        if (this.parentElement == null) {
            return Integer.MAX_VALUE;
        }
        return this.parentElement.getCurrentMCID();
    }

    @Override
    public PDPage getCurrentPDPage() {
        if (this.parentElement instanceof Page) {
            return ((Page)this.parentElement).page;
        }
        return this.parentElement.getCurrentPDPage();
    }

    @Override
    public PDFElement getElement() {
        return this;
    }

    public void setRoot(Document document) {
        this.root = document;
    }

    public PDFBaseElement getParent() {
        return this.parentElement;
    }

    public void initCursor() {
        this.cursor = new PDFBaseElement.Point(this, this.getStartPoint().getX(), this.getStartPoint().getY());
    }

    public void initCursor(float xStart, float yStart) {
        this.cursor = new PDFBaseElement.Point(this, xStart, yStart);
    }

    public boolean isRenderedOnce() {
        return this.isRenderedOnce;
    }

    public boolean isRenderedOnEachPage() {
        return this.renderedOnEachPage;
    }

    public void renderStyle(Page page, float verticalSpaceLeft) throws IOException {
        if (this.backgroundColor != null && !this.backgroundColor.equals(Color.WHITE)) {
            this.fillBackgroundColor(page.contentStream, verticalSpaceLeft);
        }
        if (this.hasBorder()) {
            this.drawBorder(page, verticalSpaceLeft);
        }
    }

    public boolean renderTo(Page page, float verticalSpaceLeft) throws IOException {
        if (this.isRenderedOnce && !this.isRenderedOnEachPage()) {
            return false;
        }
        this.initCursor();
        return true;
    }

    public abstract boolean renderTo(Page var1, float var2, PDStructureElement var3, COSArray var4) throws IOException;

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public void setBackgroundColor(Color color) {
        this.backgroundColor = color;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public void setBorderSize(float width) {
        this.borderWidth = width;
    }

    public void setMargin(float marginHorizontal, float marginVertical) {
        this.setMarginLeft(marginHorizontal);
        this.setMarginRight(marginHorizontal);
        this.setMarginTop(marginVertical);
        this.setMarginBottom(marginVertical);
    }

    public void setMargin(float marginLeft, float marginRight, float marginTop, float marginBottom) {
        this.setMarginLeft(marginLeft);
        this.setMarginRight(marginRight);
        this.setMarginTop(marginTop);
        this.setMarginBottom(marginBottom);
    }

    public void setMarginLeft(float marginLeft) {
        this.marginLeft = marginLeft;
    }

    public void setMarginRight(float marginRight) {
        this.marginRight = marginRight;
    }

    public void setMarginTop(float marginTop) {
        this.marginTop = marginTop;
    }

    public void setMarginBottom(float marginBottom) {
        this.marginBottom = marginBottom;
    }

    public void setParent(PDFBaseElement parent) {
        this.parentElement = parent;
    }

    public void setRenderedOnEachPage(boolean renderedOnEachPage) {
        if (this.parentElement instanceof PDFElement && ((PDFElement)this.parentElement).isRenderedOnEachPage()) {
            this.renderedOnEachPage = true;
            return;
        }
        this.renderedOnEachPage = renderedOnEachPage;
    }

    public void setRenderedOnce(boolean rendered) {
        this.isRenderedOnce = rendered;
    }

    public void setStartPoint(PDFElement previousElement) {
        float currentSpaceBottom;
        float currentSpaceRight;
        boolean checkPrevious;
        boolean bl = checkPrevious = previousElement != null && previousElement.parentElement.equals(this.parentElement);
        if (this.parentElement instanceof PDFElement) {
            PDFElement parent = (PDFElement)this.parentElement;
            this.startPoint.setPosition(parent.getCursor().getX(), parent.getCursor().getY());
        } else {
            this.startPoint.setPosition(this.parentElement.getStartPoint().getX(), this.parentElement.getStartPoint().getY());
        }
        if (this.getAlignment() != null) {
            this.align();
        }
        float parentEndX = this.parentElement.getStartPoint().getX() + this.parentElement.getWidth();
        float parentEndY = this.parentElement.getStartPoint().getY() - this.parentElement.getHeight();
        if (this.getMarginRight() > 0.0f && (currentSpaceRight = parentEndX - (this.startPoint.getX() + this.getWidth())) < this.getMarginRight()) {
            this.startPoint.setX(this.startPoint.getX() - (this.getMarginRight() - currentSpaceRight));
        }
        if (this.getMarginLeft() > 0.0f || checkPrevious && previousElement.getMarginRight() > 0.0f) {
            float marginLeft;
            float currentSpaceLeft = this.startPoint.getX() - this.parentElement.getStartPoint().getX();
            if (currentSpaceLeft < this.getMarginLeft()) {
                this.startPoint.setX(this.startPoint.getX() + (this.getMarginLeft() - currentSpaceLeft));
            }
            if (checkPrevious && this.startPoint.getX() > previousElement.getStartPoint().getX() && (currentSpaceLeft = this.startPoint.getX() - previousElement.getStartPoint().getX() + previousElement.getWidth()) < (marginLeft = Math.max(this.getMarginLeft(), previousElement.getMarginRight()))) {
                this.startPoint.setX(this.startPoint.getX() + (marginLeft - currentSpaceLeft));
            }
        }
        if (this.getMarginBottom() > 0.0f && (currentSpaceBottom = this.startPoint.getY() - this.getHeight() - parentEndY) >= 0.0f && currentSpaceBottom < this.getMarginBottom()) {
            this.startPoint.setY(this.startPoint.getY() + (this.getMarginBottom() - currentSpaceBottom));
        }
        if (this.getMarginTop() > 0.0f || checkPrevious && previousElement.getMarginBottom() > 0.0f) {
            float marginTop;
            float currentSpaceTop = this.parentElement.getStartPoint().getY() - this.startPoint.getY();
            if (currentSpaceTop < this.getMarginTop()) {
                this.startPoint.setY(this.startPoint.getY() - (this.getMarginTop() - currentSpaceTop));
            }
            if (checkPrevious && !(this.parentElement instanceof Paragraph.Line) && this.startPoint.getY() < previousElement.getStartPoint().getY() && (currentSpaceTop = previousElement.getStartPoint().getY() - previousElement.getHeight() - this.startPoint.getY()) < (marginTop = Math.max(this.getMarginTop(), previousElement.getMarginBottom()))) {
                this.startPoint.setY(this.startPoint.getY() - (marginTop - currentSpaceTop));
            }
        }
    }

    public void setStructuredType(String type) {
        this.structureElementType = type;
    }

    protected boolean isEnoughSpaceFor(float requiredSpace, float verticalSpaceLeft) {
        return this.parentElement.getHeight() < requiredSpace || verticalSpaceLeft - requiredSpace + 0.1f > 0.0f;
    }

    private boolean hasBorder() {
        return this.border != null && this.border != Border.NO_BORDER;
    }
}

