/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.pdf.pdfbox;

import de.businesslogics.pdf.BLBorder;
import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.pdf.pdfbox.Alignment;
import de.businesslogics.pdf.pdfbox.BLBox;
import de.businesslogics.pdf.pdfbox.BLDocument;
import de.businesslogics.pdf.pdfbox.BLImage;
import de.businesslogics.pdf.pdfbox.BLParagraph;
import de.businesslogics.pdf.pdfbox.BLTable;
import de.businesslogics.pdf.pdfbox.Document;
import de.businesslogics.pdf.pdfbox.Image;
import de.businesslogics.pdf.pdfbox.PDFElement;
import de.businesslogics.pdf.pdfbox.Page;
import de.businesslogics.pdf.pdfbox.PageLayout;
import de.businesslogics.pdf.pdfbox.Table;
import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.PDNumberTreeNode;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;

public class PDFCreator
extends de.businesslogics.pdf.PDFCreator {
    @Override
    public BLDocument createDocument(BLDocument.PageLayout pageLayout) {
        return this.createDocument(pageLayout, Locale.getDefault());
    }

    @Override
    public BLDocument createDocument(BLDocument.PageLayout pageLayout, Locale locale) {
        return new BLDocument(pageLayout, locale);
    }

    @Override
    public BLDocument createDocument(BLDocument.PageLayout pageLayout, float marginLeft, float marginRight, float marginTop, float marginBottom) {
        return this.createDocument(pageLayout, Locale.getDefault(), marginLeft, marginRight, marginTop, marginBottom);
    }

    @Override
    public BLDocument createDocument(BLDocument.PageLayout pageLayout, Locale locale, float marginLeft, float marginRight, float marginTop, float marginBottom) {
        return new BLDocument(pageLayout, locale, marginLeft, marginRight, marginTop, marginBottom);
    }

    @Override
    public File addPageNumbersFootersAndLogo(File origFile, BLDocument.Footer footer, String pageNumberingText, byte[] logoByteArray, String footerText1, String footerText2) throws PDFException, IOException {
        Image logo;
        if (origFile.length() == 0L) {
            return null;
        }
        File tmp = new File(String.valueOf(origFile.getAbsoluteFile()) + "-tmp.pdf");
        Image image = logo = logoByteArray != null ? new Image(logoByteArray, "Logo") : null;
        if (logo != null) {
            logo.setAlignment(Alignment.ALIGN_LEFT);
            logo.scaleToFitSize(125.0f, 40.0f);
            logo.setMarginLeft(15.0f);
            logo.setMarginTop(50.0f - logo.getHeight());
            logo.setRenderedOnEachPage(true);
        }
        if (footer == null) {
            footer = new BLDocument.Footer(null, null, null);
        }
        try (PDDocument document = Loader.loadPDF((File)origFile);){
            PDStructureTreeRoot root = document.getDocumentCatalog().getStructureTreeRoot();
            PDNumberTreeNode ntn = root.getParentTree();
            COSArray a = ntn.getCOSObject().getCOSArray(COSName.NUMS);
            COSArray markedContent = (COSArray)a.getObject(1);
            PDStructureElement doc = (PDStructureElement)root.getKids().get(0);
            PDPageTree pages = document.getDocumentCatalog().getPages();
            int pageNumber = 1;
            Page dummyPage = null;
            Document dummyDoc = null;
            for (PDPage currentPage : pages) {
                if (dummyPage == null) {
                    dummyPage = Page.getDummy(currentPage.getMediaBox());
                    dummyDoc = dummyPage.root;
                } else {
                    dummyPage = Page.getDummy(currentPage.getMediaBox(), dummyDoc);
                }
                dummyPage.page = currentPage;
                dummyPage.contentStream = new PDPageContentStream(document, currentPage, PDPageContentStream.AppendMode.APPEND, false);
                if (logo != null) {
                    logo.setParent(dummyPage);
                    logo.setRoot(dummyPage.root);
                    logo.setStartPoint((PDFElement)null);
                    logo.renderTo(dummyPage, 50.0f, doc, markedContent);
                }
                if (pageNumber >= footer.getStartPage()) {
                    Table footerTable = BLDocument.createFooterTableForPage(dummyPage, footer, pageNumberingText, pageNumber, pages.getCount(), footerText1, footerText2);
                    footerTable.setStartPoint((PDFElement)null);
                    footerTable.setRoot(dummyPage.root);
                    footerTable.renderTo(dummyPage, footerTable.getHeight() + footerTable.getMarginVertical(), doc, markedContent);
                }
                dummyPage.contentStream.close();
                ++pageNumber;
            }
            document.save(tmp);
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
        return tmp;
    }

    @Override
    public void addWatermark(File origFile, byte[] watermark) throws IOException {
        if (origFile.length() == 0L || watermark == null) {
            return;
        }
        Image image = new Image(watermark, "Watermark");
        image.setAlignment(Alignment.ALIGN_CENTER);
        image.setRenderedOnEachPage(true);
        try (PDDocument document = Loader.loadPDF((File)origFile);){
            PDPageTree pages = document.getDocumentCatalog().getPages();
            PDStructureElement doc = (PDStructureElement)document.getDocumentCatalog().getStructureTreeRoot().getKids().get(0);
            for (PDPage currentPage : pages) {
                Page dummyPage = Page.getDummy(currentPage.getMediaBox());
                dummyPage.contentStream = new PDPageContentStream(document, currentPage, PDPageContentStream.AppendMode.APPEND, true);
                image.setParent(dummyPage);
                image.setRoot(dummyPage.root);
                image.setStartPoint((PDFElement)null);
                image.renderTo(dummyPage, 50.0f, doc, dummyPage.root.markedContent);
                dummyPage.contentStream.close();
            }
            document.save(origFile);
        }
    }

    @Override
    public void concatPDFs(File source1, File source2, File destination, boolean deleteSources) throws IOException, PDFException {
        PDFMergerUtility PDFmerger = new PDFMergerUtility();
        try (FileOutputStream fos = new FileOutputStream(destination);){
            PDFmerger.setDestinationStream((OutputStream)fos);
            PDFmerger.addSource(source1);
            PDFmerger.addSource(source2);
            PDFmerger.mergeDocuments(IOUtils.createMemoryOnlyStreamCache());
        }
        if (deleteSources) {
            if (!source1.delete()) {
                source1.deleteOnExit();
            }
            if (!source2.delete()) {
                source2.deleteOnExit();
            }
        }
    }

    public BLParagraph createParagraph(float leading) {
        return new BLParagraph(leading);
    }

    public BLParagraph createParagraph(String text) throws PDFException {
        return new BLParagraph(text);
    }

    public BLParagraph createParagraph(String text, BLFont font) throws PDFException {
        return new BLParagraph(text, font);
    }

    public BLParagraph createParagraph(String text, boolean asPhrase) throws PDFException {
        return this.createParagraph(text);
    }

    public BLParagraph createParagraph(String text, BLFont font, boolean asPhrase) throws PDFException {
        return this.createParagraph(text, font);
    }

    public BLParagraph createParagraph(String text, BLFont font, float lineIndentLeft, Color background) throws PDFException {
        return new BLParagraph(text, font, lineIndentLeft, background);
    }

    public BLTable createTable(int columns) {
        return new BLTable(columns);
    }

    public BLTable createTable(int columns, de.businesslogics.pdf.Alignment alignment) {
        return new BLTable(columns, alignment);
    }

    public BLImage renderImage(byte[] logoByteArray, String altText) throws PDFException, IOException {
        return new BLImage(logoByteArray, altText);
    }

    @Override
    public BLBox createBox() {
        return new BLBox();
    }

    @Override
    public de.businesslogics.pdf.BLParagraph<?> createHeadline(String title, BLFont font, de.businesslogics.pdf.Alignment alignment, float leading) throws PDFException {
        return this.createHeadline(title, font, alignment, leading, 0.0f);
    }

    @Override
    public de.businesslogics.pdf.BLParagraph<?> createHeadline(String title, BLFont font, de.businesslogics.pdf.Alignment alignment, float leading, float spacing) throws PDFException {
        BLParagraph p = new BLParagraph();
        if (leading > 0.0f) {
            p = new BLParagraph(leading);
        }
        p.setTextAlignment(alignment);
        p.setSpacingAfter(spacing);
        p.addText(title, font);
        return p;
    }

    @Override
    public de.businesslogics.pdf.BLParagraph<?> createHeadline(String title, BLFont font, de.businesslogics.pdf.Alignment alignment, float leading, float spacing, float lineIdentLeft) throws PDFException {
        BLParagraph p = new BLParagraph(title, font, leading, lineIdentLeft);
        p.setTextAlignment(alignment);
        p.setSpacingAfter(spacing);
        return p;
    }

    public BLTable createSignatureFileds(BLDocument.PageLayout layout, String ... fieldDescriptions) throws PDFException {
        int numberOfFields = fieldDescriptions.length;
        float cellSpacing = numberOfFields > 2 ? 10.0f : 20.0f;
        BLTable t = new BLTable(numberOfFields);
        t.setSpacingBefore(50.0f);
        t.setCellspacing(cellSpacing);
        if (numberOfFields > 2) {
            t.setWidth(100.0f * (1.0f + cellSpacing / PageLayout.getLayout(layout).getWidth()));
        }
        t.setBorder(BLBorder.TOP);
        for (String fieldDescription : fieldDescriptions) {
            t.addCell(fieldDescription, BLFont.FONT_NORMAL);
        }
        return t;
    }
}

