/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.pdf.pdfbox;

import de.businesslogics.pdf.pdfbox.Linkable;
import de.businesslogics.pdf.pdfbox.PDFElement;
import de.businesslogics.pdf.pdfbox.Page;
import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSFloat;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDObjectReference;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureNode;
import org.apache.pdfbox.pdmodel.documentinterchange.markedcontent.PDMarkedContent;
import org.apache.pdfbox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;

public class Image
extends PDFElement
implements Linkable {
    PDImageXObject image;
    PDAnnotationLink link;
    String alternativeText;

    private Image() {
        this.structureElementType = "Figure";
    }

    public Image(byte[] image, String altText) throws IOException {
        this(new PDDocument(), image, altText);
    }

    public Image(PDDocument document, byte[] image, String altText) throws IOException {
        this();
        this.image = PDImageXObject.createFromByteArray((PDDocument)document, (byte[])image, (String)"image");
        this.width = this.image.getWidth();
        this.height = this.image.getHeight();
        this.alternativeText = altText;
    }

    @Override
    public void addLink(String url, Page page) throws IOException {
        this.link = new PDAnnotationLink();
        PDBorderStyleDictionary none = new PDBorderStyleDictionary();
        none.setWidth(0.0f);
        this.link.setBorderStyle(none);
        PDActionURI action = new PDActionURI();
        action.setURI(url);
        this.link.setAction((PDAction)action);
    }

    @Override
    public void calculateSize() {
    }

    public PDImageXObject getImage() {
        return this.image;
    }

    @Override
    public boolean renderTo(Page page, float verticalSpaceLeft, PDStructureElement parent, COSArray markedContent) throws IOException {
        if (super.renderTo(page, verticalSpaceLeft)) {
            PDRectangle bbox = new PDRectangle(this.getCursor().getX(), this.getCursor().getY() - this.getHeight(), this.getWidth(), this.getHeight());
            PDStructureElement fig = new PDStructureElement(this.structureElementType, (PDStructureNode)parent);
            fig.setAlternateDescription(this.alternativeText);
            fig.setPage(this.getCurrentPDPage());
            fig.getCOSObject().setItem(COSName.A, (COSBase)this.getAttributes());
            COSDictionary currentMarkedContentDictionary = new COSDictionary();
            currentMarkedContentDictionary.setInt(COSName.MCID, markedContent.size());
            if (this.link == null) {
                currentMarkedContentDictionary.setString(COSName.ALT, this.alternativeText);
            }
            page.contentStream.beginMarkedContent(this.link != null ? COSName.getPDFName((String)"Link") : COSName.IMAGE, PDPropertyList.create((COSDictionary)currentMarkedContentDictionary));
            page.contentStream.drawImage(this.image, this.getCursor().getX(), this.getCursor().getY() - this.getHeight(), this.getWidth(), this.getHeight());
            this.renderStyle(page, verticalSpaceLeft);
            this.isRenderedOnce = true;
            page.contentStream.endMarkedContent();
            PDMarkedContent currentContent = new PDMarkedContent(COSName.IMAGE, currentMarkedContentDictionary);
            currentContent.addXObject((PDXObject)this.image);
            if (this.link != null) {
                this.link.setRectangle(bbox);
                PDStructureElement link = new PDStructureElement("Link", (PDStructureNode)parent);
                link.setPage(this.getCurrentPDPage());
                PDObjectReference objRef = new PDObjectReference();
                objRef.setReferencedObject((PDAnnotation)this.link);
                link.appendKid(currentContent);
                link.appendKid(objRef);
                markedContent.add((COSBase)link.getCOSObject());
                fig.appendKid(link);
                page.page.getAnnotations().add(this.link);
            } else {
                fig.appendKid(currentContent);
                markedContent.add((COSBase)fig.getCOSObject());
            }
            parent.appendKid(fig);
        }
        return this.isRenderedOnce;
    }

    public void scaleToFitSize(float maxWidth, float maxHeight) {
        float scale = Math.min(maxHeight / this.height, maxWidth / this.width);
        this.width = scale * this.width;
        this.height = scale * this.height;
    }

    protected COSDictionary getAttributes() {
        COSArray boxArray = new COSArray();
        boxArray.add((COSBase)new COSFloat(this.getCursor().getX()));
        boxArray.add((COSBase)new COSFloat(this.getCursor().getY() - this.getHeight()));
        boxArray.add((COSBase)new COSFloat(this.getWidth()));
        boxArray.add((COSBase)new COSFloat(this.getHeight()));
        COSDictionary attr = new COSDictionary();
        attr.setItem(COSName.BBOX, (COSBase)boxArray);
        attr.setFloat(COSName.HEIGHT, this.height);
        attr.setFloat(COSName.WIDTH, this.width);
        attr.setItem(COSName.O, (COSBase)COSName.getPDFName((String)"Layout"));
        attr.setItem(COSName.getPDFName((String)"Placement"), (COSBase)COSName.getPDFName((String)"Block"));
        return attr;
    }
}

