/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.pdf.pdfbox;

import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.pdfbox.Document;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;

public enum Font {
    H1(Standard14Fonts.FontName.HELVETICA, 20.0f),
    H1_BOLD(Standard14Fonts.FontName.HELVETICA_BOLD, 20.0f),
    H1_UNDERLINE(Standard14Fonts.FontName.HELVETICA, 20.0f, true),
    H1_INI_HIA(Standard14Fonts.FontName.HELVETICA_BOLD, 20.0f),
    FONT_NORMAL(Standard14Fonts.FontName.HELVETICA, 10.0f),
    FONT_BOLD(Standard14Fonts.FontName.HELVETICA_BOLD, 10.0f),
    FONT_BOLD_UNDERLINE(Standard14Fonts.FontName.HELVETICA_BOLD, 10.0f, true),
    FONT_BOLD_9(Standard14Fonts.FontName.HELVETICA_BOLD, 9.0f),
    FONT_SMALL(Standard14Fonts.FontName.HELVETICA, 8.0f),
    FONT_SMALL_BOLD(Standard14Fonts.FontName.HELVETICA_BOLD, 8.0f),
    FONT_SMALL_UNDERLINE(Standard14Fonts.FontName.HELVETICA, 8.0f, true),
    FONT_VERY_SMALLER(Standard14Fonts.FontName.HELVETICA, 7.0f),
    FONT_VERY_SMALL(Standard14Fonts.FontName.HELVETICA, 6.0f),
    FONT_COBA_BOLD(Standard14Fonts.FontName.HELVETICA, 11.0f),
    FONT_LARGE(Standard14Fonts.FontName.HELVETICA, 12.0f),
    FONT_LARGE_BOLD(Standard14Fonts.FontName.HELVETICA_BOLD, 12.0f),
    FONT_BIG_BOLD(Standard14Fonts.FontName.HELVETICA_BOLD, 14.0f),
    FONT_BIG_OBLIQUE(Standard14Fonts.FontName.HELVETICA_OBLIQUE, 14.0f),
    COURIER_LARGE(Standard14Fonts.FontName.COURIER, 12.0f),
    COURIER_NORMAL(Standard14Fonts.FontName.COURIER, 10.0f),
    COURIER_BOLD(Standard14Fonts.FontName.COURIER_BOLD, 10.0f),
    COURIER_SMALL(Standard14Fonts.FontName.COURIER, 8.0f),
    COURIER_SMALL_RED(Standard14Fonts.FontName.COURIER, 8.0f),
    COURIER_VERY_SMALL(Standard14Fonts.FontName.COURIER, 6.0f),
    VSPACE(Standard14Fonts.FontName.COURIER, 1.0f),
    PTK(COURIER_SMALL.getFontname(), COURIER_SMALL.getSize());

    private static PDFont FONT_UNICODE;
    private final Standard14Fonts.FontName fontname;
    private final float fontSize;
    private final boolean underline;
    private Color color = Color.BLACK;

    private Font(Standard14Fonts.FontName fontName, float fontSize) {
        this(fontName, fontSize, false);
    }

    private Font(Standard14Fonts.FontName fontName, float fontSize, boolean underline) {
        this.fontname = fontName;
        this.fontSize = fontSize;
        this.underline = underline;
    }

    public Standard14Fonts.FontName getFontname() {
        return this.fontname;
    }

    public PDFont getFallBackFont() {
        return FONT_UNICODE;
    }

    public static Font getFont(BLFont blFont) {
        return Font.valueOf(blFont.toString());
    }

    public Color getFontColor() {
        return this.color;
    }

    public float getSize() {
        return this.fontSize;
    }

    public float getTextHeight() {
        return new PDType1Font(this.fontname).getFontDescriptor().getFontBoundingBox().getHeight() / 1000.0f * this.fontSize;
    }

    public float getTextWidth(String text) throws IOException {
        return new PDType1Font(this.fontname).getStringWidth(Font.getPrintableString((PDFont)new PDType1Font(this.fontname), text.replaceAll("\r?\n", ""))) / 1000.0f * this.fontSize;
    }

    public static float getTextWidth(PDFont font, float fontSize, String text) throws IOException {
        return font.getStringWidth(Font.getPrintableString(font, text.replaceAll("\r?\n", ""))) / 1000.0f * fontSize;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    protected void setColor(Color color) {
        this.color = color;
    }

    public static String getPrintableString(PDFont destFont, String text) throws IOException {
        String decomposedString = new String(Normalizer.normalize(text, Normalizer.Form.NFC));
        try {
            destFont.encode(decomposedString);
        }
        catch (IllegalArgumentException iae) {
            int i = decomposedString.length();
            while (iae != null) {
                if (--i < 0) {
                    return "";
                }
                Matcher unicodeMatcher = Pattern.compile("U\\+\\p{XDigit}{4}").matcher(iae.getMessage());
                if (unicodeMatcher.find()) {
                    try {
                        String toReplace = new String(Character.toChars(Integer.decode("0x" + unicodeMatcher.group().substring(2))));
                        decomposedString = decomposedString.replaceAll(toReplace, "");
                        destFont.encode(decomposedString);
                        iae = null;
                    }
                    catch (IllegalArgumentException iae2) {
                        iae = iae2;
                    }
                    continue;
                }
                throw iae;
            }
        }
        return decomposedString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PDFont loadDefaultFontToDocument(Document document) {
        try (InputStream is = Font.class.getResourceAsStream("unifont.ttf");){
            if (is == null) return document.loadFont(FONT_NORMAL);
            PDType0Font pDType0Font = PDType0Font.load((PDDocument)document.getPDF(), (InputStream)is, (boolean)true);
            return pDType0Font;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return document.loadFont(FONT_NORMAL);
    }

    static {
        FONT_UNICODE = null;
        H1_INI_HIA.setColor(new Color(9734271));
        COURIER_SMALL_RED.setColor(Color.RED);
    }
}

