/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.pdf.pdfbox;

import de.businesslogics.pdf.pdfbox.Alignment;
import de.businesslogics.pdf.pdfbox.Border;
import de.businesslogics.pdf.pdfbox.Font;
import de.businesslogics.pdf.pdfbox.Image;
import de.businesslogics.pdf.pdfbox.PDFBaseElement;
import de.businesslogics.pdf.pdfbox.PDFElement;
import de.businesslogics.pdf.pdfbox.Page;
import de.businesslogics.pdf.pdfbox.Paragraph;
import de.businesslogics.pdf.pdfbox.Table;
import de.businesslogics.pdf.pdfbox.Text;
import de.businesslogics.util.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.transform.TransformerException;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.jempbox.xmp.XMPSchema;
import org.apache.jempbox.xmp.XMPSchemaBasic;
import org.apache.jempbox.xmp.XMPSchemaDublinCore;
import org.apache.jempbox.xmp.XMPSchemaPDF;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDNumberTreeNode;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDMarkInfo;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureNode;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.viewerpreferences.PDViewerPreferences;

public class Document
extends PDFBaseElement {
    private PDAcroForm acroForm;
    private final PDDocument PDF = new PDDocument();
    private Page currentPage;
    private PDRectangle currentPageSize = new PDRectangle();
    private boolean hasFooter;
    private List<Page> pages = new ArrayList<Page>();
    private final Map<Standard14Fonts.FontName, PDFont> documentFonts = new HashMap<Standard14Fonts.FontName, PDFont>();
    PDStructureElement currentSection;
    private int currentMCID = 0;
    final COSDictionary dict = new COSDictionary();
    final COSArray markedContent = new COSArray();

    public Document(PDRectangle pageSize) {
        this(pageSize, Locale.getDefault());
    }

    public Document(PDRectangle pageSize, Locale locale) {
        this(pageSize, locale, 36.0f, 36.0f, 36.0f, 36.0f);
    }

    public Document(PDRectangle pageSize, float marginLeft, float marginRight, float marginTop, float marginBottom) {
        this(pageSize, Locale.getDefault(), marginLeft, marginRight, marginTop, marginBottom);
    }

    public Document(PDRectangle pageSize, Locale locale, float marginLeft, float marginRight, float marginTop, float marginBottom) {
        this.currentPageSize = pageSize;
        this.width = this.currentPageSize.getWidth();
        this.height = this.currentPageSize.getHeight();
        this.setMargins(marginLeft, marginRight, marginTop, marginBottom);
        this.initDocument(locale);
    }

    public void add(PDFElement element) {
        this.currentPage.addElement(element);
        element.setRoot(this);
    }

    public void addDocumentAuthor(String docAuthor) {
        this.getPDF().getDocumentInformation().setAuthor(docAuthor);
    }

    public void addDocumentCreationDate() {
        this.getPDF().getDocumentInformation().setCreationDate(Calendar.getInstance());
        this.getPDF().getDocumentInformation().setModificationDate(Calendar.getInstance());
    }

    public void addDocumentCreator(String docCreator) {
        this.getPDF().getDocumentInformation().setCreator(docCreator);
    }

    public void addDocumentKeywords(String keywords) {
        this.getPDF().getDocumentInformation().setKeywords(keywords);
    }

    public void addDocumentProducer() {
        this.getPDF().getDocumentInformation().setProducer("Apache PDF Box");
    }

    public void addDocumentSubject(String subject) {
        this.getPDF().getDocumentInformation().setSubject(subject);
    }

    public void addDocumentTitle(String docTitle) {
        this.getPDF().getDocumentInformation().setTitle(docTitle);
    }

    public void addLogo(byte[] image, Alignment alignment) throws IOException {
        this.addLogo(image, alignment, 0.0f, null);
    }

    public void addLogo(byte[] image, Alignment alignment, float margin, String url) throws IOException {
        Image bllogo = new Image(this.getPDF(), image, "Logo");
        bllogo.setMarginTop(margin);
        bllogo.setMarginRight(margin);
        if (bllogo.getHeight() > 72.0f || bllogo.getWidth() > 225.0f) {
            bllogo.scaleToFitSize(225.0f, 72.0f);
        }
        bllogo.setAlignment(alignment);
        if (url != null) {
            // empty if block
        }
        this.add(bllogo);
    }

    public void addLogo(byte[] image, float fixedWidth, float fixedHeight, Alignment alignment, float margin) throws IOException {
        Image bllogo = new Image(this.getPDF(), image, "Logo");
        bllogo.setMarginTop(margin);
        bllogo.setMarginRight(margin);
        bllogo.scaleToFitSize(fixedWidth, fixedHeight);
        bllogo.setAlignment(alignment);
        this.add(bllogo);
    }

    public void addSignatureFields(Font font, Alignment textAlignment, String ... fieldDescriptions) throws IOException {
        int numberOfFields = fieldDescriptions.length;
        float cellSpacing = numberOfFields > 2 ? 10.0f : 20.0f;
        Table t = new Table(numberOfFields);
        t.setMarginTop(50.0f);
        t.setSpacing(cellSpacing);
        if (numberOfFields > 2) {
            t.setWidth(100.0f * (1.0f + cellSpacing / this.getCurrentPage().getWidth()));
        }
        t.setDefaultCellBorder(Border.TOP);
        for (String fieldDescription : fieldDescriptions) {
            t.addCell(new Text(fieldDescription, font, textAlignment));
        }
        this.add(t);
    }

    public void addTitle(String title) throws IOException {
        this.addTitle(title, Font.H1_BOLD, Alignment.ALIGN_TOP_LEFT, 0.0f, 0.0f, 0.0f, false);
    }

    public void addTitle(String title, Font font, Alignment alignment, float leading, float spacing, float lineIdent, boolean fillWidth) throws IOException {
        Paragraph p = new Paragraph();
        if (leading > 0.0f) {
            p = new Paragraph(leading);
        }
        p.setTextAlignment(alignment);
        p.setMarginBottom(spacing);
        p.setMarginLeft(lineIdent);
        p.addText(title, font, null, fillWidth);
        p.setStructuredType("H1");
        this.add(p);
    }

    public void close(OutputStream fos) throws IOException {
        this.getPDF().save(fos);
        this.getPDF().close();
        fos.close();
    }

    public Page getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public int getCurrentMCID() {
        return this.currentMCID++;
    }

    public PDRectangle getPageSize() {
        return this.currentPageSize;
    }

    public PDDocument getPDF() {
        return this.PDF;
    }

    public PDFont loadFont(Font font) {
        Standard14Fonts.FontName fontName;
        Standard14Fonts.FontName fontName2 = fontName = font != null ? font.getFontname() : null;
        if (!this.documentFonts.containsKey(fontName)) {
            if (font == null) {
                PDFont newFont = Font.loadDefaultFontToDocument(this);
                this.documentFonts.put(fontName, newFont);
                this.acroForm.getDefaultResources().put(COSName.getPDFName((String)"Uni"), newFont);
            } else {
                PDType1Font newFont;
                try {
                    newFont = PDType0Font.load((PDDocument)this.getPDF(), (TrueTypeFont)new PDTrueTypeFont(new PDType1Font(fontName).getCOSObject()).getTrueTypeFont(), (boolean)true);
                }
                catch (IOException e) {
                    newFont = new PDType1Font(fontName);
                }
                this.acroForm.getDefaultResources().put(COSName.getPDFName((String)fontName.getName()), (PDFont)newFont);
                this.documentFonts.put(fontName, (PDFont)newFont);
            }
        }
        return this.documentFonts.get(fontName);
    }

    public void newPage() throws IOException {
        if (this.currentPage == null || !this.currentPage.isEmpty()) {
            this.newPage(this.marginLeft, this.marginRight, this.marginTop, this.marginBottom);
        }
    }

    public void newPage(float marginLeft, float marginRight, float marginTop, float marginBottom) throws IOException {
        Page newPage = new Page(this, marginLeft, marginRight, marginTop, marginBottom);
        this.pages.add(newPage);
        this.currentPage = newPage;
    }

    public void render() throws IOException {
        PDStructureElement doc = new PDStructureElement("Document", (PDStructureNode)this.getPDF().getDocumentCatalog().getStructureTreeRoot());
        this.getPDF().getDocumentCatalog().getStructureTreeRoot().appendKid(doc);
        this.dict.setItem(COSName.NUMS, (COSBase)new COSArray());
        this.dict.getCOSArray(COSName.NUMS).add((COSBase)COSInteger.get((long)0L));
        this.dict.getCOSArray(COSName.NUMS).add((COSBase)this.markedContent);
        PDResources resources = this.acroForm.getDefaultResources();
        int i = 1;
        for (Page page : this.pages) {
            if (i == this.pages.size() && page.isEmpty()) break;
            if (this.hasFooter) {
                page.setMarginBottom(Math.max(this.marginBottom, 20.0f + 1.5f * Font.FONT_NORMAL.getSize()));
            }
            while (!page.isRenderedOnce) {
                page.page.setResources(resources);
                this.getPDF().addPage(page.page);
                if (!page.render(doc, this.markedContent, this)) {
                    page.pageBreak();
                    continue;
                }
                page.contentStream.close();
            }
            ++i;
        }
        this.getPDF().getDocumentCatalog().getStructureTreeRoot().setParentTree(new PDNumberTreeNode(this.dict, this.dict.getClass()));
        this.addMetadata();
    }

    public void setHasFooter(boolean hasFooter) {
        this.hasFooter = hasFooter;
    }

    public void setMargins(float marginLeft, float marginRight, float marginTop, float marginBottom) {
        this.marginLeft = marginLeft;
        this.marginRight = marginRight;
        this.marginTop = marginTop;
        this.marginBottom = marginBottom;
    }

    public void setPageSize(PDRectangle pageSize) {
        this.currentPageSize = pageSize;
    }

    public void setLanguage(String language) {
        this.getPDF().getDocumentCatalog().setLanguage(language);
    }

    @Override
    protected PDPage getCurrentPDPage() {
        return this.getCurrentPage().page;
    }

    private void addMetadata() throws IOException {
        try {
            XMPMetadata metadata = new XMPMetadata();
            XMPSchema schema = new XMPSchema(metadata, "pdfuaid", "http://www.aiim.org/pdfua/ns/id/");
            schema.setIntegerProperty("pdfuaid:part", Integer.valueOf(1));
            metadata.addSchema(schema);
            XMPSchemaPDF pdfSchema = metadata.addPDFSchema();
            pdfSchema.setKeywords(this.getPDF().getDocumentInformation().getKeywords());
            pdfSchema.setProducer(this.getPDF().getDocumentInformation().getProducer());
            pdfSchema.setPDFVersion(String.valueOf(this.PDF.getVersion()));
            XMPSchemaBasic basicSchema = metadata.addBasicSchema();
            basicSchema.setModifyDate(this.getPDF().getDocumentInformation().getModificationDate());
            basicSchema.setCreateDate(this.getPDF().getDocumentInformation().getCreationDate());
            basicSchema.setCreatorTool(this.getPDF().getDocumentInformation().getCreator());
            basicSchema.setMetadataDate((Calendar)new GregorianCalendar());
            XMPSchemaDublinCore dcSchema = metadata.addDublinCoreSchema();
            dcSchema.setTitle(this.getPDF().getDocumentInformation().getTitle());
            dcSchema.addCreator("PDFBox");
            dcSchema.setDescription(this.getPDF().getDocumentInformation().getSubject());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            metadata.save((OutputStream)baos);
            PDMetadata meta = new PDMetadata(this.getPDF(), (InputStream)new ByteArrayInputStream(baos.toByteArray()));
            this.getPDF().getDocumentCatalog().setMetadata(meta);
        }
        catch (TransformerException e) {
            LogUtils.logp(Document.class, Level.WARNING, "close", "Could not add XMP Metadata", e);
        }
    }

    private void initDocument(Locale locale) {
        this.setupAcroForm();
        this.getPDF().getDocumentCatalog().setAcroForm(this.acroForm);
        this.getPDF().getDocumentCatalog().setViewerPreferences(new PDViewerPreferences(new COSDictionary()));
        this.getPDF().getDocumentCatalog().getViewerPreferences().setDisplayDocTitle(true);
        PDStructureTreeRoot structureTreeRoot = new PDStructureTreeRoot();
        this.getPDF().getDocumentCatalog().setStructureTreeRoot(structureTreeRoot);
        PDMarkInfo markInfo = new PDMarkInfo();
        markInfo.setMarked(true);
        this.getPDF().getDocumentCatalog().setMarkInfo(markInfo);
        this.setLanguage(locale.getLanguage());
    }

    private void setupAcroForm() {
        this.acroForm = new PDAcroForm(this.PDF);
        COSArray cosArray = new COSArray();
        cosArray.add((COSBase)COSName.getPDFName((String)"PDF"));
        cosArray.add((COSBase)COSName.getPDFName((String)"Text"));
        this.acroForm.setNeedAppearances(Boolean.valueOf(true));
        this.acroForm.setXFA(null);
        this.acroForm.setFields(Collections.emptyList());
        this.acroForm.setDefaultResources(new PDResources());
        this.acroForm.getDefaultResources().getCOSObject().setItem(COSName.PROC_SET, (COSBase)cosArray);
    }
}

