/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.pdf.pdfbox;

import de.businesslogics.pdf.pdfbox.PDFElement;
import de.businesslogics.pdf.pdfbox.Page;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureNode;

public class Div
extends PDFElement {
    List<PDFElement> elements = new ArrayList<PDFElement>();

    public Div() {
        this.structureElementType = "Div";
    }

    public void add(PDFElement element) {
        this.elements.add(element);
        element.setParent(this);
    }

    @Override
    public void calculateSize() throws IOException {
        float parentWidth = this.getParent().getWidth() > 0.0f ? this.getParent().getWidth() : PDRectangle.A4.getWidth();
        this.setWidth(parentWidth - this.getMarginHorizontal());
        float calcHeight = 0.0f;
        for (PDFElement element : this.elements) {
            if (element.isRenderedOnce) continue;
            element.setRoot(this.root);
            element.calculateSize();
            calcHeight += element.getHeight() + element.getMarginVertical();
        }
        this.setHeight(Math.min(calcHeight, this.getParent().getHeight()));
    }

    @Override
    public boolean renderTo(Page page, float verticalSpaceLeft, PDStructureElement parent, COSArray markedContent) throws IOException {
        PDStructureElement div = new PDStructureElement(this.structureElementType, (PDStructureNode)parent);
        if (super.renderTo(page, verticalSpaceLeft)) {
            if (this.getHeight() < this.getParent().getHeight() && !this.isEnoughSpaceFor(this.getHeight(), verticalSpaceLeft)) {
                return false;
            }
            div.setPage(this.getCurrentPDPage());
            this.renderStyle(page, verticalSpaceLeft -= this.getMarginVertical());
            PDFElement previous = null;
            for (PDFElement element : this.elements) {
                if (element.isRenderedOnce()) continue;
                element.setStartPoint(previous);
                if (element.renderTo(page, verticalSpaceLeft, div, markedContent)) {
                    this.getCursor().setPosition(this.getStartPoint().getX(), element.getCursor().getY());
                    previous = element;
                    verticalSpaceLeft -= element.getHeight() + element.getMarginVertical();
                    continue;
                }
                parent.appendKid(div);
                return false;
            }
            this.setRenderedOnce(true);
            parent.appendKid(div);
            return true;
        }
        return false;
    }
}

