/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.pdf.pdfbox;

import de.businesslogics.pdf.BLBorder;
import de.businesslogics.pdf.pdfbox.PDFBaseElement;
import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPageContentStream;

public enum Border {
    BOTTOM(false, true, false, false),
    BOX(true, true, true, true),
    LEFT(false, false, true, false),
    NO_BORDER(false, false, false, false),
    TOP(true, false, false, false);

    private boolean top;
    private boolean bottom;
    private boolean left;
    private boolean right;

    private Border(boolean top, boolean bottom, boolean left, boolean right) {
        this.top = top;
        this.bottom = bottom;
        this.left = left;
        this.right = right;
    }

    public void draw(PDPageContentStream content, PDFBaseElement.Point start, float width, float height, float borderWidth, Color borderColor) throws IOException {
        content.beginMarkedContent(COSName.ARTIFACT);
        content.setStrokingColor(borderColor);
        content.setLineWidth(borderWidth);
        float borderWidthOffset = borderWidth / 2.0f;
        if (this.top) {
            content.moveTo(start.getX() - borderWidthOffset, start.getY());
            content.lineTo(start.getX() + width + borderWidthOffset, start.getY());
        }
        if (this.bottom) {
            content.moveTo(start.getX() - borderWidthOffset, start.getY() - height);
            content.lineTo(start.getX() + width + borderWidthOffset, start.getY() - height);
        }
        if (this.left) {
            content.moveTo(start.getX(), start.getY() + borderWidthOffset);
            content.lineTo(start.getX(), start.getY() - height - borderWidthOffset);
        }
        if (this.right) {
            content.moveTo(start.getX() + width, start.getY() + borderWidthOffset);
            content.lineTo(start.getX() + width, start.getY() - height - borderWidthOffset);
        }
        content.closeAndStroke();
        content.endMarkedContent();
    }

    public static Border getBorder(BLBorder blBorder) {
        return Border.valueOf(blBorder.toString());
    }
}

