/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.pdf.pdfbox;

import de.businesslogics.pdf.BLBorder;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.BLParagraph;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.pdf.pdfbox.Alignment;
import de.businesslogics.pdf.pdfbox.Border;
import de.businesslogics.pdf.pdfbox.Font;
import de.businesslogics.pdf.pdfbox.Paragraph;
import de.businesslogics.pdf.pdfbox.Table;
import de.businesslogics.pdf.pdfbox.Text;
import java.awt.Color;
import java.io.IOException;

public class BLTable
implements de.businesslogics.pdf.BLTable<Table> {
    protected Table table;

    public BLTable(int columns) {
        this.table = new Table(columns);
    }

    public BLTable(int columns, de.businesslogics.pdf.Alignment alignment) {
        this(columns);
        this.table.setAlignment(Alignment.getValue(null, alignment));
    }

    @Override
    public Table getElement() {
        return this.table;
    }

    @Override
    public void addCell(String text) throws PDFException {
        this.addCell(text, BLFont.FONT_NORMAL);
    }

    @Override
    public void addCell(String text, BLFont font) throws PDFException {
        this.addCell(text, font, 0);
    }

    @Override
    public void addCell(String text, int colspan) throws PDFException {
        this.addCell(text, BLFont.FONT_NORMAL, colspan);
    }

    @Override
    public void addCell(String text, BLFont font, int colspan) throws PDFException {
        this.addCell(text, font, colspan, null, null);
    }

    @Override
    public void addCell(String text, de.businesslogics.pdf.Alignment horizontalAlignment, de.businesslogics.pdf.Alignment verticalAlignment) throws PDFException {
        this.addCell(text, BLFont.FONT_NORMAL, horizontalAlignment, verticalAlignment);
    }

    @Override
    public void addCell(String text, BLFont font, de.businesslogics.pdf.Alignment horizontalAlignment, de.businesslogics.pdf.Alignment verticalAlignment) throws PDFException {
        this.addCell(text, font, 0, horizontalAlignment, verticalAlignment);
    }

    @Override
    public void addCell(String text, int colspan, de.businesslogics.pdf.Alignment horizontalAlignment, de.businesslogics.pdf.Alignment verticalAlignment) throws PDFException {
        this.addCell(text, BLFont.FONT_NORMAL, colspan, horizontalAlignment, verticalAlignment);
    }

    @Override
    public void addCell(String text, BLFont font, int colspan, de.businesslogics.pdf.Alignment horizontalAlignment, de.businesslogics.pdf.Alignment verticalAlignment) throws PDFException {
        this.addCell(text, font, colspan, horizontalAlignment, verticalAlignment, null, null);
    }

    @Override
    public void addCell(String text, BLFont font, de.businesslogics.pdf.Alignment horizontalAlignment, de.businesslogics.pdf.Alignment verticalAlignment, Color background, BLBorder border) throws PDFException {
        this.addCell(text, font, 0, horizontalAlignment, verticalAlignment, background, border);
    }

    @Override
    public void addCell(String text, BLFont font, int colspan, de.businesslogics.pdf.Alignment horizontalAlignment, de.businesslogics.pdf.Alignment verticalAlignment, Color background, BLBorder border) throws PDFException {
        Alignment alignment = Alignment.getValue(verticalAlignment, horizontalAlignment);
        try {
            if (text == null) {
                text = "";
            }
            Text t = new Text(text, Font.getFont(font), alignment);
            this.table.addCell(t, colspan, border != null ? Border.valueOf(border.toString()) : null, background);
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void addCell(String text, BLFont font, float fixedCellHeight, Color background, de.businesslogics.pdf.Alignment horizontalAlignment, de.businesslogics.pdf.Alignment verticalAlignment) throws PDFException {
        Alignment alignment = Alignment.getValue(verticalAlignment, horizontalAlignment);
        try {
            Text t = new Text(text, Font.getFont(font), alignment);
            this.table.addCell(t, fixedCellHeight, 0, null, background);
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void addCell(BLParagraph<?> paragraph) throws PDFException {
        try {
            this.table.addCell((Paragraph)paragraph.getElement());
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void addCell(BLParagraph<?> paragraph, int colspan) throws PDFException {
        try {
            this.table.addCell((Paragraph)paragraph.getElement(), colspan);
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void addCell(BLParagraph<?> paragraph, BLBorder border, int colspan) throws PDFException {
        try {
            this.table.addCell((Paragraph)paragraph.getElement(), colspan, border != null ? Border.valueOf(border.toString()) : null, null);
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void addCell(de.businesslogics.pdf.BLTable<?> cellTable) throws PDFException {
        try {
            cellTable.setWidth(100.0f);
            this.table.addCell(((BLTable)cellTable).getElement());
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void addEmptyCell() throws PDFException {
        try {
            this.table.addCell(new Text(""));
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void addEmptyCell(float fixedHeight) throws PDFException {
        try {
            this.table.addCell(new Text(""), fixedHeight, 0, null, null);
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void addEmptyCell(int colspan) throws PDFException {
        try {
            this.table.addCell(new Text(""), colspan, null, null);
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void addEmptyCell(int colspan, BLBorder border) throws PDFException {
        try {
            this.table.addCell(new Text(""), colspan, border != null ? Border.valueOf(border.toString()) : null, Color.WHITE);
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void deleteAllRows() {
        this.table.deleteBodyRows();
    }

    @Override
    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    @Override
    public Color getBackgroundColor() {
        return this.table.getDefaultCellBackgroundColor();
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.table.setDefaultCellBackgroundColor(color);
    }

    @Override
    public void setBorder(BLBorder border) {
        this.table.setDefaultCellBorder(Border.getBorder(border));
    }

    @Override
    public Color getBorderColor() {
        return this.table.getDefaultCellBorderColor();
    }

    @Override
    public int getColumnCount() {
        return this.table.getColumnCount();
    }

    @Override
    public float getDefaultPaddingTop() {
        return this.table.getDefaultCellPaddingTop();
    }

    @Override
    public void resetDefaults() {
        this.setBackgroundColor(null);
        this.setDefaultColspan(1);
        this.setPadding(0.0f);
        this.setUseDescender(false);
    }

    @Override
    public void setBorderColor(Color color) {
        this.table.setDefaultCellBorderColor(color);
    }

    @Override
    public void setBorderWidth(float width) {
        this.table.setDefaultCellBorderSize(width);
    }

    @Override
    public void setCellspacing(float spacing) {
        this.table.setSpacing(spacing);
    }

    @Override
    public void setDefaultColspan(int colspan) {
        this.table.setDefaultColspan(colspan);
    }

    @Override
    public void setDefaultPaddingBottom(float padding) {
        this.table.setDefaultCellPaddingBottom(padding);
    }

    @Override
    public void setDefaultPaddingTop(float padding) {
        this.table.setDefaultCellPaddingTop(padding);
    }

    @Override
    public void setHeaderRows(int rows) {
        this.table.setHeaderRows(rows);
    }

    @Override
    public void setHorizontalAlignment(de.businesslogics.pdf.Alignment horizontalAlignment) {
        Alignment cellAlignment = Alignment.getValue(null, horizontalAlignment);
        this.table.setDefaultHorizontalCellAlignment(cellAlignment);
    }

    @Override
    public void setVerticalAlignment(de.businesslogics.pdf.Alignment verticalAlignment) {
        Alignment cellAlignment = Alignment.getValue(verticalAlignment, null);
        this.table.setDefaultVerticalCellAlignment(cellAlignment);
    }

    @Override
    public void setPadding(float padding) {
        this.table.setDefaultCellPadding(padding);
    }

    @Override
    public void setSkipFirstHeader(boolean skipFirstHeader) {
        this.table.setSkipFirstHeader(skipFirstHeader);
    }

    @Override
    public void setSpacingAfter(float spacing) {
        this.table.setMarginBottom(spacing);
    }

    @Override
    public void setSpacingBefore(float spacing) {
        this.table.setMarginTop(spacing);
    }

    @Override
    public float getTotalWidth() {
        return this.table.getHeight();
    }

    @Override
    public void setTotalWidth(float tableWidth) {
        this.table.setFixedWidth(tableWidth);
    }

    @Override
    public void setUseDescender(boolean value) {
        this.table.setUseDescender(value);
    }

    @Override
    public void setWidth(float percentage) {
        this.table.setWidth(percentage);
    }

    @Override
    public void setWidths(int[] widths) throws PDFException {
        int total = 0;
        for (int i : widths) {
            total += i;
        }
        float[] widthsInFloat = new float[widths.length];
        for (int i = 0; i < widths.length; ++i) {
            widthsInFloat[i] = 1.0f * (float)widths[i] / (float)total;
        }
        this.table.setWidths(widthsInFloat);
    }

    @Override
    public void setWidths(float[] widths) throws PDFException {
        float total = 0.0f;
        for (float i : widths) {
            total += i;
        }
        for (int i = 0; i < widths.length; ++i) {
            widths[i] = widths[i] / total;
        }
        this.table.setWidths(widths);
    }
}

