/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.pdf.pdfbox;

import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.pdf.pdfbox.Alignment;
import de.businesslogics.pdf.pdfbox.Font;
import de.businesslogics.pdf.pdfbox.PDFElement;
import de.businesslogics.pdf.pdfbox.Paragraph;
import java.awt.Color;
import java.io.IOException;

public class BLParagraph
implements de.businesslogics.pdf.BLParagraph<Paragraph> {
    private Paragraph paragraph;
    private BLFont lastUsedFont = BLFont.FONT_NORMAL;

    public BLParagraph() {
        this.paragraph = new Paragraph();
    }

    public BLParagraph(float leading) {
        this.paragraph = new Paragraph(leading);
    }

    public BLParagraph(String text) throws PDFException {
        this(text, BLFont.FONT_NORMAL);
    }

    public BLParagraph(String text, BLFont font) throws PDFException {
        try {
            this.paragraph = new Paragraph(text, Font.getFont(font));
            this.lastUsedFont = font;
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    public BLParagraph(String text, BLFont font, float lineIndentLeft, Color background) throws PDFException {
        this(text, font);
        this.paragraph.setMarginLeft(lineIndentLeft);
        this.paragraph.setBackgroundColor(background);
    }

    public BLParagraph(String text, BLFont font, float leading, float lineIndentLeft) throws PDFException {
        try {
            this.paragraph = leading > 0.0f ? new Paragraph(leading, text, Font.getFont(font)) : new Paragraph(text, Font.getFont(font));
            this.paragraph.setMarginLeft(lineIndentLeft);
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void addText(String text, BLFont font) throws PDFException {
        try {
            this.paragraph.addText(text, Font.getFont(font));
            this.lastUsedFont = font;
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void addTable(BLTable<?> table) throws PDFException {
        this.paragraph.add((PDFElement)table.getElement());
    }

    @Override
    public Paragraph getElement() {
        return this.paragraph;
    }

    @Override
    public void newLine() throws PDFException {
        this.addText("\n", this.lastUsedFont);
    }

    @Override
    public void setAlignment(de.businesslogics.pdf.Alignment verticalAlignment) {
        this.paragraph.setAlignment(Alignment.getValue(verticalAlignment, null));
    }

    @Override
    public void setTextAlignment(de.businesslogics.pdf.Alignment horizontalAlignment) {
        this.paragraph.setTextAlignment(Alignment.getValue(null, horizontalAlignment));
    }

    @Override
    public void setSpacingBefore(float spacing) {
        this.paragraph.setMarginTop(spacing);
    }

    @Override
    public void setSpacingAfter(float spacing) {
        this.paragraph.setMarginBottom(spacing);
    }
}

