/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.pdf.pdfbox;

import de.businesslogics.pdf.BLDocument;
import de.businesslogics.pdf.BLFont;
import de.businesslogics.pdf.BLTable;
import de.businesslogics.pdf.PDFElement;
import de.businesslogics.pdf.PDFException;
import de.businesslogics.pdf.pdfbox.Alignment;
import de.businesslogics.pdf.pdfbox.Border;
import de.businesslogics.pdf.pdfbox.Document;
import de.businesslogics.pdf.pdfbox.Font;
import de.businesslogics.pdf.pdfbox.Page;
import de.businesslogics.pdf.pdfbox.PageLayout;
import de.businesslogics.pdf.pdfbox.Paragraph;
import de.businesslogics.pdf.pdfbox.Table;
import de.businesslogics.pdf.pdfbox.Text;
import de.businesslogics.util.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;

public class BLDocument
implements de.businesslogics.pdf.BLDocument {
    private final Document document;
    private OutputStream fos;
    private BLDocument.Footer footer;
    private Map<Integer, de.businesslogics.pdf.pdfbox.PDFElement> pageFooter = new HashMap<Integer, de.businesslogics.pdf.pdfbox.PDFElement>();
    private boolean noLineSpacing;
    private String pageNumberingText;

    @Deprecated
    public BLDocument(BLDocument.PageLayout pageLayout) {
        this.document = new Document(PageLayout.getLayout(pageLayout));
    }

    public BLDocument(BLDocument.PageLayout pageLayout, Locale locale) {
        this.document = new Document(PageLayout.getLayout(pageLayout), locale);
    }

    @Deprecated
    public BLDocument(BLDocument.PageLayout pageLayout, float marginLeft, float marginRight, float marginTop, float marginBottom) {
        this.document = new Document(PageLayout.getLayout(pageLayout), marginLeft, marginRight, marginTop, marginBottom);
    }

    public BLDocument(BLDocument.PageLayout pageLayout, Locale locale, float marginLeft, float marginRight, float marginTop, float marginBottom) {
        this.document = new Document(PageLayout.getLayout(pageLayout), locale, marginLeft, marginRight, marginTop, marginBottom);
    }

    @Override
    public void add(PDFElement<?> pdfElement) throws PDFException {
        this.document.add((de.businesslogics.pdf.pdfbox.PDFElement)pdfElement.getElement());
    }

    @Override
    public void addFooter(String footerText, BLFont font, de.businesslogics.pdf.Alignment horizontalAlignment) throws PDFException {
        if (horizontalAlignment == null || horizontalAlignment == de.businesslogics.pdf.Alignment.ALIGN_RIGHT) {
            this.setDefaultFooter(null, null, footerText, font);
        } else if (horizontalAlignment == de.businesslogics.pdf.Alignment.ALIGN_CENTER) {
            this.setDefaultFooter(null, footerText, null, font);
        } else if (horizontalAlignment == de.businesslogics.pdf.Alignment.ALIGN_LEFT) {
            this.setDefaultFooter(footerText, null, null, font);
        }
    }

    @Override
    public void addHeadline(String title) throws PDFException {
        this.addHeadline(title, BLFont.H1_BOLD);
    }

    @Override
    public void addHeadline(String title, BLFont font) throws PDFException {
        this.addHeadline(title, font, null, 0.0f, 20.0f);
    }

    @Override
    public void addHeadline(String title, de.businesslogics.pdf.Alignment alignment) throws PDFException {
        this.addHeadline(title, BLFont.H1_BOLD, alignment, 0.0f, 0.0f);
    }

    @Override
    public void addHeadline(String title, BLFont font, float leading) throws PDFException {
        this.addHeadline(title, font, de.businesslogics.pdf.Alignment.ALIGN_LEFT, leading, 20.0f);
    }

    @Override
    public void addHeadline(String title, BLFont font, de.businesslogics.pdf.Alignment alignment, float spacing) throws PDFException {
        this.addHeadline(title, font, alignment, 0.0f, spacing);
    }

    @Override
    public void addHeadline(String title, BLFont font, de.businesslogics.pdf.Alignment alignment, float leading, float spacing) throws PDFException {
        this.addHeadline(title, font, alignment, leading, spacing, false);
    }

    @Override
    public void addHeadline(String title, BLFont font, de.businesslogics.pdf.Alignment alignment, float leading, float spacing, float lineIdent) throws PDFException {
        try {
            this.document.addTitle(title.trim(), Font.getFont(font), Alignment.getValue(null, alignment), leading, spacing, lineIdent, false);
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void addHeadline(String title, BLFont font, de.businesslogics.pdf.Alignment alignment, float leading, float spacing, boolean fillWidth) throws PDFException {
        try {
            this.document.addTitle(title.trim(), Font.getFont(font), Alignment.getValue(null, alignment), leading, spacing, 0.0f, fillWidth);
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void addKeywords(String keywords) {
        this.document.addDocumentKeywords(keywords);
    }

    @Override
    public void addLogo(byte[] image, float margin) throws PDFException {
        this.addLogo(image, margin, System.getProperty("de.businesslogics.iniletter.url", "https://www.business-logics.de"));
    }

    @Override
    public void addLogo(byte[] image, float margin, String url) throws PDFException {
        try {
            this.document.addLogo(image, Alignment.ALIGN_TOP_RIGHT, margin, url);
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void addLogo(byte[] image, float fixedWidth, float fixedHeight, float margin) throws PDFException {
        try {
            this.document.addLogo(image, fixedWidth, fixedHeight, Alignment.ALIGN_TOP_RIGHT, margin);
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void addMetaInformation(String title, String author, String creator) {
        this.addMetaInformation(title, author, creator, true, true);
    }

    @Override
    public void addMetaInformation(String title, String author, String creator, boolean setProducer, boolean setCreationDate) {
        this.document.addDocumentTitle(title);
        this.document.addDocumentAuthor(author);
        this.document.addDocumentCreator(creator);
        if (setProducer) {
            this.document.addDocumentProducer();
        }
        if (setCreationDate) {
            this.document.addDocumentCreationDate();
        }
    }

    @Override
    public void addNewLine() throws PDFException {
        try {
            this.document.add(new Text("\n", Font.FONT_NORMAL));
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void addPageFooter(int pageNumber, PDFElement<?> element) {
        this.document.setHasFooter(true);
        de.businesslogics.pdf.pdfbox.PDFElement e = (de.businesslogics.pdf.pdfbox.PDFElement)element.getElement();
        e.setRoot(this.document);
        this.pageFooter.put(pageNumber, e);
    }

    @Override
    public void addTable(BLTable<?> table) throws PDFException {
        this.document.add(((de.businesslogics.pdf.pdfbox.BLTable)table).getElement());
    }

    @Override
    public void addTable(BLTable<?> table, float spacing) throws PDFException {
        ((de.businesslogics.pdf.pdfbox.BLTable)table).getElement().setMarginTop(spacing);
        this.document.add(((de.businesslogics.pdf.pdfbox.BLTable)table).getElement());
    }

    @Override
    public void addText(String text) throws PDFException {
        this.addText(text, BLFont.FONT_NORMAL);
    }

    @Override
    public void addText(String text, BLFont font) throws PDFException {
        try {
            this.add(new Text(text, Font.getFont(font)));
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void addTextln(String text) throws PDFException {
        this.addTextln(text, BLFont.FONT_NORMAL);
    }

    @Override
    public void addTextln(String text, BLFont font) throws PDFException {
        this.addTextln(text, font, null);
    }

    @Override
    public void addTextln(String text, de.businesslogics.pdf.Alignment alignment) throws PDFException {
        this.addTextln(text, BLFont.FONT_NORMAL, alignment);
    }

    @Override
    public void addTextln(String text, BLFont font, de.businesslogics.pdf.Alignment alignment) throws PDFException {
        Paragraph p;
        if (text == null || text.length() == 0) {
            return;
        }
        Alignment textAlignment = Alignment.getValue(null, alignment);
        try {
            p = this.noLineSpacing ? new Paragraph(0.0f, text, Font.getFont(font), textAlignment) : new Paragraph(text, Font.getFont(font), textAlignment);
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
        this.document.add(p);
    }

    @Override
    public void addTextln(String text, float leading) throws PDFException {
        this.addTextln(text, leading, 0.0f);
    }

    @Override
    public void addTextln(String text, BLFont font, float leading) throws PDFException {
        this.addTextln(text, font, leading, 0.0f);
    }

    @Override
    public void addTextln(String text, float leading, float spacing) throws PDFException {
        this.addTextln(text, BLFont.FONT_NORMAL, leading, spacing);
    }

    @Override
    public void addTextln(String text, BLFont font, float leading, float spacing) throws PDFException {
        try {
            Paragraph p = leading > 0.0f ? new Paragraph(leading, text, Font.getFont(font)) : (this.noLineSpacing ? new Paragraph(0.0f, text, Font.getFont(font)) : new Paragraph(text, Font.getFont(font)));
            p.setMarginBottom(spacing);
            this.document.add(p);
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void addSignatureFields(String ... fieldDescriptions) throws PDFException {
        this.addSignatureFields(BLFont.FONT_NORMAL, fieldDescriptions);
    }

    @Override
    public void addSignatureFields(BLFont font, String ... fieldDescriptions) throws PDFException {
        this.addSignatureFields(font, de.businesslogics.pdf.Alignment.ALIGN_LEFT, fieldDescriptions);
    }

    @Override
    public void addSignatureFields(BLFont font, de.businesslogics.pdf.Alignment textAlignment, String ... fieldDescriptions) throws PDFException {
        try {
            this.document.addSignatureFields(Font.getFont(font), Alignment.getValue(textAlignment), fieldDescriptions);
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void addSubject(String subject) {
        this.document.addDocumentSubject(subject);
    }

    @Override
    public void addVSpace(float vSpace) throws PDFException {
        try {
            Paragraph p = new Paragraph("", Font.VSPACE);
            p.setMarginTop(vSpace);
            this.document.add(p);
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void addVSpace(BLFont font) throws PDFException {
        this.addVSpace(Font.getFont(font).getSize());
    }

    @Override
    public void close() throws PDFException {
        try {
            this.document.render();
            this.printFooter();
            this.document.close(this.fos);
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void newPage() throws PDFException {
        try {
            this.document.newPage();
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void open() throws PDFException {
        try {
            this.document.newPage();
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void open(OutputStream fos) throws PDFException {
        this.open();
        this.fos = fos;
    }

    @Override
    public void printFooter() throws PDFException {
        if (!this.hasFooterConfigured()) {
            return;
        }
        if (this.footer == null) {
            this.footer = new BLDocument.Footer(null, null, null);
        }
        try {
            PDStructureTreeRoot root = this.document.getPDF().getDocumentCatalog().getStructureTreeRoot();
            PDStructureElement doc = (PDStructureElement)root.getKids().get(0);
            PDPageTree pages = this.document.getPDF().getDocumentCatalog().getPages();
            int pageNumber = 0;
            for (PDPage currentPage : pages) {
                Page dummyPage = Page.getDummy(currentPage.getMediaBox(), this.document);
                de.businesslogics.pdf.pdfbox.PDFElement footer = this.getFooterForPage(dummyPage, ++pageNumber, pages.getCount());
                if (footer == null) continue;
                dummyPage.contentStream = new PDPageContentStream(this.document.getPDF(), currentPage, PDPageContentStream.AppendMode.APPEND, false);
                footer.setStartPoint((de.businesslogics.pdf.pdfbox.PDFElement)null);
                footer.setRoot(this.document);
                footer.renderTo(dummyPage, footer.getHeight(), doc, this.document.markedContent);
                dummyPage.contentStream.close();
            }
        }
        catch (IOException e) {
            throw new PDFException(e);
        }
    }

    @Override
    public void setDefaultFooter(String textLeft, String textCenter, String textRight, BLFont footerFont) {
        this.setDefaultFooter(textLeft, textCenter, textRight, footerFont, 1);
    }

    @Override
    public void setDefaultFooter(String textLeft, String textCenter, String textRight, BLFont footerFont, int start) {
        this.document.setHasFooter(true);
        this.footer = new BLDocument.Footer(textLeft, textCenter, textRight, footerFont, start);
        this.footer.setWidth(this.document.getWidth() - this.document.getMarginHorizontal());
    }

    @Override
    public void setMargins(float marginLeft, float marginRight, float marginTop, float marginBottom) {
        this.document.setMargins(marginLeft, marginRight, marginTop, marginBottom);
    }

    @Override
    public void setNoLineSpacing(boolean value) {
        this.noLineSpacing = true;
    }

    @Override
    public void setPageNumbering(String pageNumberingText) {
        this.pageNumberingText = pageNumberingText;
    }

    @Override
    public void setPageSize(BLDocument.PageLayout pageLayout) {
        this.document.setPageSize(PageLayout.getLayout(pageLayout));
    }

    private boolean hasFooterConfigured() {
        boolean hasDefaultFooter = !StringUtils.isEmpty(this.pageNumberingText) || this.footer != null;
        boolean hasPageFooter = this.pageFooter != null && !this.pageFooter.isEmpty();
        return hasDefaultFooter || hasPageFooter;
    }

    private de.businesslogics.pdf.pdfbox.PDFElement getFooterForPage(Page page, int pageNumber, int pageCount) throws IOException {
        if (this.pageFooter.get(pageNumber) != null) {
            de.businesslogics.pdf.pdfbox.PDFElement footer = this.pageFooter.get(pageNumber);
            footer.setMarginBottom(20.0f);
            footer.setAlignment(Alignment.ALIGN_BOTTOM_CENTER);
            footer.setParent(page);
            footer.calculateSize();
            return footer;
        }
        if (pageNumber >= this.footer.getStartPage()) {
            return BLDocument.createFooterTableForPage(page, this.footer, this.pageNumberingText, pageNumber, pageCount, null, null);
        }
        return null;
    }

    public static Table createFooterTableForPage(Page page, BLDocument.Footer footer, String pageNumberingText, int pageNumber, int pageCount, String footerText1, String footerText2) throws IOException {
        Text infoText;
        Text text;
        int footerCells = 0;
        if (footer.getTextRight() != null || pageNumberingText != null) {
            ++footerCells;
        }
        if (footer.getTextLeft() != null) {
            ++footerCells;
        }
        if (footer.getTextCenter() != null) {
            int n = footerCells = footerCells > 0 ? 3 : 1;
        }
        if (footerText1 != null || footerText2 != null) {
            footerCells = footerCells > 0 ? 3 : 1;
        }
        Table footerTable = new Table(footerCells);
        footerTable.setFixedWidth(footer.getWidth() > 0.0f ? footer.getWidth() : page.getWidth() - 72.0f);
        footerTable.setDefaultCellBorder(Border.NO_BORDER);
        footerTable.setMarginBottom(20.0f);
        footerTable.setAlignment(Alignment.ALIGN_BOTTOM_CENTER);
        if (footer.getTextLeft() != null) {
            text = new Text(footer.getTextLeft(), Font.getFont(footer.getFont()), Alignment.ALIGN_LEFT);
            footerTable.addCell(text, 0, null, null);
        } else if (footerCells == 3) {
            footerTable.addCell(new Text(""));
        }
        if (footer.getTextCenter() != null) {
            text = new Text(footer.getTextCenter(), Font.getFont(footer.getFont()), Alignment.ALIGN_CENTER_HORIZONTAL);
            footerTable.addCell(text, 0, null, null);
        } else if (footerCells == 3) {
            footerTable.addCell(new Text(""));
        }
        if (footer.getTextRight() != null || pageNumberingText != null) {
            Object textRight;
            Object object = textRight = footer.getTextRight() != null ? footer.getTextRight() : "";
            if (pageNumberingText != null) {
                textRight = (String)textRight + MessageFormat.format(pageNumberingText, pageNumber, pageCount);
            }
            Text text2 = new Text((String)textRight, Font.getFont(footer.getFont()), Alignment.ALIGN_RIGHT);
            footerTable.addCell(text2, 0, null, null);
        } else if (footerCells == 3) {
            footerTable.addCell(new Text(""));
        }
        if (footerText1 != null) {
            infoText = new Text(footerText1, Font.FONT_VERY_SMALL, Alignment.ALIGN_CENTER_HORIZONTAL);
            footerTable.addCell(infoText, footerCells, null, null);
        }
        if (footerText2 != null) {
            infoText = new Text(footerText2, Font.FONT_VERY_SMALL, Alignment.ALIGN_CENTER_HORIZONTAL);
            footerTable.addCell(infoText, footerCells, null, null);
        }
        footerTable.setParent(page);
        footerTable.setRoot(page.root);
        footerTable.calculateSize();
        return footerTable;
    }
}

