/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.pdf.pdfbox;

import de.businesslogics.pdf.pdfbox.PDFBaseElement;

public enum Alignment {
    ALIGN_LEFT(0),
    ALIGN_RIGHT(1),
    ALIGN_TOP(2),
    ALIGN_BOTTOM(3),
    ALIGN_TOP_LEFT(4),
    ALIGN_TOP_RIGHT(5),
    ALIGN_BOTTOM_LEFT(6),
    ALIGN_BOTTOM_RIGHT(7),
    ALIGN_CENTER(8),
    ALIGN_CENTER_RIGHT(9),
    ALIGN_CENTER_LEFT(10),
    ALIGN_TOP_CENTER(11),
    ALIGN_BOTTOM_CENTER(12),
    ALIGN_CENTER_VERTICAL(13),
    ALIGN_CENTER_HORIZONTAL(14);

    private final int value;

    private Alignment(int value) {
        this.value = value;
    }

    public static Alignment getValue(de.businesslogics.pdf.Alignment alignment) {
        if (alignment == null) {
            return null;
        }
        return Alignment.valueOf(alignment.toString());
    }

    public static Alignment getValue(de.businesslogics.pdf.Alignment verticalAlignment, de.businesslogics.pdf.Alignment horizontalAlignment) {
        if (verticalAlignment == null && horizontalAlignment == null) {
            return null;
        }
        if (verticalAlignment == de.businesslogics.pdf.Alignment.ALIGN_MIDDLE && horizontalAlignment == de.businesslogics.pdf.Alignment.ALIGN_CENTER) {
            return ALIGN_CENTER;
        }
        if (verticalAlignment == de.businesslogics.pdf.Alignment.ALIGN_MIDDLE && horizontalAlignment == null) {
            return ALIGN_CENTER_VERTICAL;
        }
        if (horizontalAlignment == de.businesslogics.pdf.Alignment.ALIGN_CENTER && verticalAlignment == null) {
            return ALIGN_CENTER_HORIZONTAL;
        }
        Object alignment = "ALIGN";
        if (verticalAlignment != null) {
            alignment = (String)alignment + verticalAlignment.toString().substring(5);
        }
        if (horizontalAlignment != null) {
            alignment = (String)alignment + horizontalAlignment.toString().substring(5);
        }
        return Alignment.valueOf(((String)alignment).replaceAll("MIDDLE", "CENTER"));
    }

    public float getXPos(float xPos, float objectWidth, PDFBaseElement.Point parentStart, float parentWidth) {
        if (this.value == 1 || this.value == 5 || this.value == 7 || this.value == 9) {
            return parentStart.getX() + parentWidth - objectWidth;
        }
        if (this.value == 0 || this.value == 4 || this.value == 6 || this.value == 10) {
            return parentStart.getX();
        }
        if (this.value == 8 || this.value == 11 || this.value == 12 || this.value == 14) {
            float x_center = parentStart.getX() + parentWidth / 2.0f;
            return x_center - objectWidth / 2.0f;
        }
        return xPos;
    }

    public float getYPos(float yPos, float objectHeight, PDFBaseElement.Point parentStart, float parentHeight) {
        if (this.value == 2 || this.value == 4 || this.value == 5 || this.value == 11) {
            return parentStart.getY();
        }
        if (this.value == 3 || this.value == 6 || this.value == 7 || this.value == 12) {
            return parentStart.getY() - parentHeight + objectHeight;
        }
        if (this.value == 8 || this.value == 9 || this.value == 10 || this.value == 13) {
            float y_center = parentStart.getY() - parentHeight / 2.0f;
            return y_center + objectHeight / 2.0f;
        }
        return yPos;
    }
}

