/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class MT940
extends Charset {
    private static final char[] DECODE_TABLE = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '`', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u007f', '\u00c7', '\u00fc', '\u00e9', '\u00e2', '\u00e4', '\u00e0', '\u00e5', '\u00e7', '\u00ea', '\u00eb', '\u00e8', '\u00ef', '\u00ee', '\u00ec', '\u00c4', '\u00c5', '\u00c9', '\u00e6', '\u00c6', '\u00f4', '\u00f6', '\u00f2', '\u00fb', '\u00f9', '\u00ff', '\u00d6', '\u00dc', '\u00f8', '\u00a3', '\u00d8', '\u00d7', '\u0192', '\u00a0', '\u00a1', '\u00a2', '\u00a3', '\u20ac', '\u00a5', '\u0160', '\u00a7', '\u0161', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u017d', '\u00b5', '\u00b6', '\u00b7', '\u017e', '\u00b9', '\u00ba', '\u00bb', '\u0152', '\u0153', '\u0178', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};

    public MT940() {
        super("MT940", null);
    }

    @Override
    public boolean contains(Charset cs) {
        return cs.name().equals("ISO-8859-1") || cs.name().equals("IBM850");
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return Charset.forName("ISO-8859-1").newEncoder();
    }

    private static class Decoder
    extends CharsetDecoder {
        private final byte[] NEEDLE = new byte[]{-17, -65, -67};
        private boolean openBraces;
        private int found;

        Decoder(Charset c) {
            super(c, 1.0f, 1.0f);
        }

        @Override
        protected void implReset() {
            this.openBraces = false;
            this.found = 0;
        }

        @Override
        protected CoderResult implFlush(CharBuffer out) {
            if (out.remaining() < this.found) {
                return CoderResult.OVERFLOW;
            }
            for (int i = 0; i < this.found; ++i) {
                out.put(DECODE_TABLE[this.NEEDLE[i] & 0xFF]);
            }
            this.found = 0;
            return CoderResult.UNDERFLOW;
        }

        @Override
        public CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            while (in.remaining() > 0) {
                if (out.remaining() == 0) {
                    return CoderResult.OVERFLOW;
                }
                byte b = in.get();
                if (b == this.NEEDLE[this.found]) {
                    ++this.found;
                    if (this.found != 3) continue;
                    out.put(this.openBraces ? (char)'{' : '}');
                    this.openBraces = !this.openBraces;
                    this.found = 0;
                    continue;
                }
                if (this.found > 0 && this.implFlush(out) == CoderResult.OVERFLOW) {
                    in.position(in.position() - 1);
                    return CoderResult.OVERFLOW;
                }
                out.put(DECODE_TABLE[b & 0xFF]);
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

