/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class DTAUS
extends Charset {
    public static final DTAUS INSTANCE = new DTAUS();
    private static final char[] DECODE_TABLE = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', '$', '%', '&', ' ', ' ', ' ', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ' ', ' ', ' ', ' ', ' ', ' ', ' ', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c4', '\u00d6', '\u00dc', ' ', ' ', ' ', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\u00e4', '\u00f6', '\u00fc', '\u00df', ' '};
    private static final char[] DECODE_TABLE2 = new char[]{' ', '\u00fc', ' ', ' ', '\u00e4', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', '\u00c4', ' ', ' ', ' ', ' ', ' ', '\u00f6', ' ', ' ', ' ', ' ', '\u00d6', '\u00dc', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', '\u00df', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
    private static final byte[] ENCODE_TABLE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 36, 37, 38, 0, 0, 0, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 0, 0, 0, 0, 0, 0, 0, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 0, 0, 0, 0, 0, 0, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 92, 0, 0, 0, 0, 0, 93, 0, 0, 126, 0, 0, 0, 0, 91, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 92, 0, 0, 0, 0, 0, 93, 0, 0, 0};

    public DTAUS() {
        super("DTAUS", null);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public boolean contains(Charset c) {
        return false;
    }

    public static String toValidDTAUS(String in) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c > '\u00ff' || ENCODE_TABLE[c] == 0) {
                b.append(' ');
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    private static class Encoder
    extends CharsetEncoder {
        Encoder(Charset c) {
            super(c, 1.0f, 1.0f);
        }

        @Override
        public CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            int r = Math.min(in.remaining(), out.remaining());
            while (r-- > 0) {
                byte b;
                char c = in.get();
                if (c > '\u00ff' || (b = ENCODE_TABLE[c]) == 0) {
                    in.position(in.position() - 1);
                    return CoderResult.unmappableForLength(1);
                }
                out.put(b);
            }
            return in.remaining() > 0 ? CoderResult.OVERFLOW : CoderResult.UNDERFLOW;
        }
    }

    private static class Decoder
    extends CharsetDecoder {
        Decoder(Charset c) {
            super(c, 1.0f, 1.0f);
        }

        @Override
        public CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            int r = Math.min(in.remaining(), out.remaining());
            while (r-- > 0) {
                byte b = in.get();
                if (b < 0) {
                    out.put(DECODE_TABLE2[b + 128]);
                    continue;
                }
                out.put(DECODE_TABLE[b]);
            }
            return in.remaining() > 0 ? CoderResult.OVERFLOW : CoderResult.UNDERFLOW;
        }
    }
}

