/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.license;

import de.businesslogics.io.Streams;
import de.businesslogics.license.LicenseExpiredException;
import de.businesslogics.license.NoLicenseException;
import de.businesslogics.util.HexTool;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class UnsignedJarLicense {
    static final BigInteger modulus = new BigInteger("24905131160108308358770874323569969321864656041665595492505325883895908362840478871967503407600807615407322725424386230101446560603679504234163235966508923136533551616190084862802800046593692973733396495104366345071524029230988218274623643183139361167437332928419422852951768427539213485027045701801664424516869904353695904598568670551026948234045072774499541799769527856095056683078760075876233551120102819766044626265530182952319821394727469362034102577460742807453284287506485120791321816665972852740572297945592974831979174194646875221386952486933239318859336469606403954528816330345436612595655184423681792408133");
    static final BigInteger exponent = new BigInteger("65537");
    private static RSAPublicKey publicKey;
    private final Properties properties = new Properties();
    private final Date expires;

    public static void setRSAPublicKeyModulus(BigInteger in) {
        try {
            KeyFactory f = KeyFactory.getInstance("RSA");
            publicKey = (RSAPublicKey)f.generatePublic(new RSAPublicKeySpec(in, exponent));
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException(gse);
        }
    }

    public static void setRSAPublicKey(RSAPublicKey publicKey) {
        UnsignedJarLicense.publicKey = publicKey;
    }

    public UnsignedJarLicense(InputStream is) {
        if (is == null) {
            throw new NoLicenseException();
        }
        StringBuilder sb = new StringBuilder();
        try {
            int i;
            while ((i = is.read()) > 0 && i != 10) {
                sb.append((char)i);
            }
            Signature s = Signature.getInstance("SHA1withRSA");
            s.initVerify(publicKey);
            byte[] b = Streams.readAll(is);
            is.close();
            is = null;
            s.update(b);
            if (!s.verify(HexTool.fromHex(sb.toString()))) {
                throw new NoLicenseException();
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(b);
            this.properties.load(bis);
            String date = this.properties.getProperty("expires");
            if (date != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
                this.expires = sdf.parse(date);
            } else {
                this.expires = null;
            }
        }
        catch (Exception e) {
            NoLicenseException nle = new NoLicenseException();
            nle.initCause(e);
            throw nle;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        this.checkValid();
    }

    public String getProperty(String name) {
        this.checkValid();
        return this.properties.getProperty(name);
    }

    public Properties getProperties() {
        this.checkValid();
        return (Properties)this.properties.clone();
    }

    public void checkValid() {
        if (!this.isValid()) {
            throw new LicenseExpiredException(this.expires);
        }
    }

    public boolean isValid() {
        return this.expires == null || this.expires.getTime() > System.currentTimeMillis();
    }

    static {
        try {
            KeyFactory f = KeyFactory.getInstance("RSA");
            publicKey = (RSAPublicKey)f.generatePublic(new RSAPublicKeySpec(modulus, exponent));
        }
        catch (GeneralSecurityException gse) {
            throw new RuntimeException(gse);
        }
    }
}

