/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.io;

import java.io.IOException;
import java.io.OutputStream;

public class YOutputStream
extends OutputStream {
    private final OutputStream out1;
    private final OutputStream out2;
    private boolean ignoreOut2Exception = false;
    private Throwable out2Exception;

    public YOutputStream(OutputStream out1, OutputStream out2) {
        this.out1 = out1;
        this.out2 = out2;
    }

    @Override
    public void close() throws IOException {
        OutputStream toClose = this.out2;
        try {
            this.out1.close();
            if (!this.ignoreOut2Exception) {
                toClose = null;
                this.out2.close();
            }
        }
        finally {
            block10: {
                if (toClose != null) {
                    try {
                        toClose.close();
                    }
                    catch (Throwable ioe) {
                        if (this.out2Exception != null) break block10;
                        this.out2Exception = ioe;
                    }
                }
            }
        }
    }

    @Override
    public void flush() throws IOException {
        this.out1.flush();
        if (this.ignoreOut2Exception) {
            if (this.out2Exception == null) {
                try {
                    this.out2.flush();
                }
                catch (Throwable ioe) {
                    this.out2Exception = ioe;
                }
            }
        } else {
            this.out2.flush();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.out1.write(b);
        if (this.ignoreOut2Exception) {
            if (this.out2Exception == null) {
                try {
                    this.out2.write(b);
                }
                catch (Throwable ioe) {
                    this.out2Exception = ioe;
                }
            }
        } else {
            this.out2.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out1.write(b, off, len);
        if (this.ignoreOut2Exception) {
            if (this.out2Exception == null) {
                try {
                    this.out2.write(b, off, len);
                }
                catch (Throwable ioe) {
                    this.out2Exception = ioe;
                }
            }
        } else {
            this.out2.write(b, off, len);
        }
    }

    public OutputStream getOutputStream1() {
        return this.out1;
    }

    public OutputStream getOutputStream2() {
        return this.out2;
    }

    public boolean isIgnoreOut2Exception() {
        return this.ignoreOut2Exception;
    }

    public void setIgnoreOut2Exception(boolean ignoreOut2Exception) {
        this.ignoreOut2Exception = ignoreOut2Exception;
    }

    public Throwable getOut2Exception() {
        return this.out2Exception;
    }
}

