/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.io;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Streams {
    public static final int BLOCK_SIZE = 4096;

    private Streams() {
    }

    public static byte[] readAll(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        byte[] buffer = new byte[1024];
        int read = -1;
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAllAndClose(InputStream in) throws IOException {
        try {
            byte[] toReturn = Streams.readAll(in);
            in.close();
            in = null;
            byte[] byArray = toReturn;
            return byArray;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void readFully(InputStream in, byte[] buffer) throws IOException {
        Streams.readFully(in, buffer, 0, buffer.length);
    }

    public static void readFully(InputStream in, byte[] buffer, int offset, int length) throws IOException {
        int tmp = -1;
        while (length > 0) {
            tmp = in.read(buffer, offset, length);
            if (tmp < 0) {
                throw new EOFException("could not read enough from stream");
            }
            offset += tmp;
            length -= tmp;
        }
    }

    public static long copy(InputStream in, OutputStream out) throws IOException {
        return Streams.copy(in, out, true);
    }

    public static long copy(InputStream in, OutputStream out, boolean close) throws IOException {
        int read;
        byte[] buffer = new byte[4096];
        long written = 0L;
        while ((read = in.read(buffer)) > 0) {
            out.write(buffer, 0, read);
            written += (long)read;
        }
        if (close) {
            out.close();
            in.close();
        }
        return written;
    }
}

