/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.io;

import java.io.OutputStream;
import java.io.Serializable;

public class StartEndOutputStream
extends OutputStream
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final byte[] end;
    private final byte[] start;
    private final int endSize;
    private int iEnd = 0;
    private int iStart = 0;

    public StartEndOutputStream(int n, int m) {
        this.start = new byte[n];
        this.end = new byte[m * 2];
        this.endSize = m;
    }

    public byte[] getEnd() {
        if (this.iEnd > this.endSize) {
            byte[] toReturn = new byte[this.endSize];
            System.arraycopy(this.end, this.iEnd - this.endSize, toReturn, 0, this.endSize);
            return toReturn;
        }
        byte[] toReturn = new byte[this.iEnd];
        System.arraycopy(this.end, 0, toReturn, 0, this.iEnd);
        return toReturn;
    }

    public byte[] getStart() {
        byte[] toReturn = new byte[this.iStart];
        System.arraycopy(this.start, 0, toReturn, 0, this.iStart);
        return toReturn;
    }

    @Override
    public void write(int param) {
        if (this.iStart < this.start.length) {
            this.start[this.iStart++] = (byte)param;
        }
        if (this.iEnd < this.end.length) {
            this.end[this.iEnd++] = (byte)param;
        } else {
            System.arraycopy(this.end, this.endSize, this.end, 0, this.endSize - 1);
            this.end[this.endSize] = (byte)param;
            this.iEnd = this.endSize + 1;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.iStart < this.start.length) {
            int min = Math.min(len, this.start.length - this.iStart);
            System.arraycopy(b, off, this.start, this.iStart, min);
            this.iStart += min;
        }
        if (len >= this.endSize) {
            System.arraycopy(b, off + len - this.endSize, this.end, 0, this.endSize);
            this.iEnd = this.endSize;
        } else if (len + this.iEnd > this.end.length) {
            System.arraycopy(this.end, this.endSize, this.end, 0, this.iEnd - this.endSize);
            System.arraycopy(b, off, this.end, this.iEnd - this.endSize, len);
            this.iEnd = this.iEnd - this.endSize + len;
        } else {
            System.arraycopy(b, off, this.end, this.iEnd, len);
            this.iEnd += len;
        }
    }
}

