/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.io;

import de.businesslogics.util.SystemUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class IteratingFileInputStream
extends InputStream {
    protected long available;
    int nowOpenIndex = -1;
    InputStream nowOpen = null;
    final File[] files;
    final Iterator<File> iterator;

    public IteratingFileInputStream(File[] files) throws IOException {
        this.files = files;
        this.iterator = null;
        this.openNextFile();
    }

    public IteratingFileInputStream(Iterator<File> iterator) throws IOException {
        this.files = null;
        this.iterator = iterator;
        this.openNextFile();
    }

    @Override
    public int read() throws IOException {
        int toReturn = -1;
        while (this.nowOpen != null && this.available == 0L) {
            this.openNextFile();
        }
        while (this.nowOpen != null && (toReturn = this.nowOpen.read()) < 0) {
            this.openNextFile();
        }
        --this.available;
        return toReturn;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        int toReturn = -1;
        while (this.nowOpen != null && this.available == 0L) {
            this.openNextFile();
        }
        if (this.available > 0L && this.available < (long)length) {
            length = (int)this.available;
        }
        while (this.nowOpen != null && (toReturn = this.nowOpen.read(b, offset, length)) < 0) {
            this.openNextFile();
        }
        this.available -= (long)toReturn;
        return toReturn;
    }

    @Override
    public void close() throws IOException {
        if (this.nowOpen != null) {
            this.nowOpen.close();
            this.nowOpen = null;
        }
    }

    private void openNextFile() throws IOException {
        if (this.nowOpen != null) {
            this.nowOpen.close();
        }
        if (this.files != null) {
            ++this.nowOpenIndex;
            if (this.nowOpenIndex >= this.files.length) {
                this.nowOpen = null;
                return;
            }
            this.nowOpen = this.openFile(this.files[this.nowOpenIndex]);
        } else {
            File next = this.iterator.next();
            this.nowOpen = next != null ? this.openFile(next) : null;
        }
    }

    protected InputStream openFile(File file) throws IOException {
        FileInputStream toReturn = new FileInputStream(file);
        if (file instanceof TruncatedFile) {
            TruncatedFile tf = (TruncatedFile)file;
            this.available = tf.readTill;
            if (tf.skip > 0L) {
                try {
                    toReturn.skip(tf.skip);
                }
                catch (IOException ioe) {
                    SystemUtils.close(toReturn);
                    throw ioe;
                }
                this.available -= tf.skip;
            }
        } else {
            this.available = -1L;
        }
        return toReturn;
    }

    public static class TruncatedFile
    extends File {
        private static final long serialVersionUID = 1L;
        final long skip;
        final long readTill;

        public TruncatedFile(File file, long skip, long readTill) {
            super(file.getAbsolutePath());
            if (skip < 0L) {
                throw new IllegalArgumentException("Skip must not be negative");
            }
            if (skip > readTill) {
                throw new IllegalArgumentException("Skip=" + skip + " bigger than readTill=" + readTill);
            }
            this.skip = skip;
            this.readTill = readTill;
        }

        @Override
        public long length() {
            return this.readTill - this.skip;
        }
    }
}

