/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CountingFilterInputStream
extends FilterInputStream {
    long countRead = 0L;

    public CountingFilterInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int read = super.read();
        if (read >= 0) {
            ++this.countRead;
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int countBytes = super.read(b, off, len);
        if (countBytes >= 0) {
            this.countRead += (long)countBytes;
        }
        return countBytes;
    }

    public long getCountRead() {
        return this.countRead;
    }
}

