/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.io;

public class ComparisonFailedException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private static final String END_OF_FILE = "<EOF>";
    public final long position;
    public final int inputByte;
    public final int outputByte;
    public final String expectedLine;
    public final String givenLine;
    private final boolean isByteMode;
    private final String hint;

    public ComparisonFailedException(long position, int inputByte, int outputByte) {
        this.position = position;
        this.inputByte = inputByte;
        this.outputByte = outputByte;
        this.expectedLine = null;
        this.givenLine = null;
        this.isByteMode = true;
        this.hint = null;
    }

    public ComparisonFailedException(String hint, String expectedLine, String givenLine, long lineNumber) {
        this.hint = hint;
        this.position = lineNumber;
        this.inputByte = -1;
        this.outputByte = -1;
        this.expectedLine = expectedLine == null ? END_OF_FILE : expectedLine;
        this.givenLine = givenLine == null ? END_OF_FILE : givenLine;
        this.isByteMode = false;
    }

    @Override
    public String getMessage() {
        return this.isByteMode ? "Write attempt for " + this.outputByte + " at position " + this.position + ", was expecting " + this.inputByte + "." : (String)(this.hint == null ? "" : "File: " + this.hint + ", ") + "Line " + this.position + ": Write attempt for:\n" + this.givenLine + "\nExpected was:\n" + this.expectedLine;
    }
}

