/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.io;

import de.businesslogics.io.ComparisonFailedException;
import de.businesslogics.io.Streams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class ComparingOutputStream
extends OutputStream {
    final InputStream is;
    long pos = 0L;

    public ComparingOutputStream(InputStream is) {
        this.is = is;
    }

    @Override
    public void write(int b) throws IOException {
        int i = this.is.read();
        if (i != (b & 0xFF)) {
            throw new ComparisonFailedException(this.pos, i, b);
        }
        ++this.pos;
    }

    @Override
    public void close() throws IOException {
        if (this.pos < 0L) {
            return;
        }
        int i = this.is.read();
        if (i != -1) {
            throw new ComparisonFailedException(this.pos, i, -1);
        }
        this.pos = -1L;
        this.is.close();
    }

    public static OutputStream create(File toCompare) throws IOException {
        if (toCompare.exists()) {
            return new ComparingOutputStream(Files.newInputStream(toCompare.toPath(), new OpenOption[0]));
        }
        return Files.newOutputStream(toCompare.toPath(), new OpenOption[0]);
    }

    public static OutputStream create(File toCompare, Charset charset) throws IOException {
        if (toCompare.exists()) {
            InputStream is = Files.newInputStream(toCompare.toPath(), new OpenOption[0]);
            InputStreamReader isr = new InputStreamReader(is, charset);
            return new ComparingOutputStream(new ReadingInputStream(isr));
        }
        return Files.newOutputStream(toCompare.toPath(), new OpenOption[0]);
    }

    public static void compare(InputStream in1, InputStream in2) throws IOException {
        ComparingOutputStream o = new ComparingOutputStream(in1);
        Streams.copy(in2, o);
    }

    private static class ReadingInputStream
    extends InputStream {
        private final InputStreamReader isr;

        ReadingInputStream(InputStreamReader isr) {
            this.isr = isr;
        }

        @Override
        public int read() throws IOException {
            return this.isr.read();
        }
    }
}

