/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.io;

import java.io.OutputStream;

public class BufferFiller
extends OutputStream {
    private byte[] myBuffer = new byte[512];
    private byte[] userBuffer;
    int userPos;
    int myPos = 0;

    public void setBuffer(byte[] buffer) {
        this.userBuffer = buffer;
        if (this.myPos > 0) {
            if (this.myPos > this.userBuffer.length) {
                System.arraycopy(this.myBuffer, 0, this.userBuffer, 0, this.userBuffer.length);
                System.arraycopy(this.myBuffer, this.userBuffer.length, this.myBuffer, 0, this.myPos - this.userBuffer.length);
                this.userPos = this.userBuffer.length;
                this.myPos -= this.userPos;
            } else {
                System.arraycopy(this.myBuffer, 0, this.userBuffer, 0, this.myPos);
                this.userPos = this.myPos;
                this.myPos = 0;
            }
        } else {
            this.userPos = 0;
        }
    }

    public boolean isBufferFull() {
        return this.userPos == this.userBuffer.length;
    }

    public int written() {
        return this.userPos;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (this.userBuffer != null) {
            int toCopy = this.userBuffer.length - this.userPos;
            if (len < toCopy) {
                toCopy = len;
            }
            System.arraycopy(b, off, this.userBuffer, this.userPos, toCopy);
            this.userPos += toCopy;
            off += toCopy;
            len -= toCopy;
        }
        if (len > 0) {
            this.allocBytes(len);
            System.arraycopy(b, off, this.myBuffer, this.myPos, len);
            this.myPos += len;
        }
    }

    @Override
    public void write(int b) {
        if (this.userBuffer != null && this.userPos < this.userBuffer.length) {
            this.userBuffer[this.userPos++] = (byte)b;
        } else {
            this.allocBytes(1);
            this.myBuffer[this.myPos++] = (byte)b;
        }
    }

    private void allocBytes(int needed) {
        if ((needed += this.myPos) <= this.myBuffer.length) {
            return;
        }
        byte[] newBuffer = new byte[needed];
        System.arraycopy(this.myBuffer, 0, newBuffer, 0, this.myPos);
        this.myBuffer = newBuffer;
    }
}

