/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.iban;

import de.businesslogics.validation.RegularExpressions;
import java.text.DecimalFormat;

public class IbanUtil {
    public static boolean DISABLE_IBAN_CHECK = false;

    public static boolean isGermanIban(String iban) {
        return iban != null && iban.startsWith("DE") && iban.length() == 22;
    }

    public static boolean isSwissOrLiechtensteinIban(String iban) {
        return iban != null && (iban.startsWith("CH") || iban.startsWith("LI")) && iban.length() == 21;
    }

    public static boolean isQRIban(String iban) {
        if (IbanUtil.isSwissOrLiechtensteinIban(iban)) {
            try {
                int iid = Integer.parseInt(iban.substring(4, 9));
                return iid >= 30000 && iid <= 31999;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static String calculateUncheckedGermanIban(String accountNumber, String bankCode) {
        return IbanUtil.calculateIban("DE", bankCode + IbanUtil.normalize(accountNumber));
    }

    public static String calculateCheckDigits(String country, String ibanSubstring4) {
        RemainderCalc rc = new RemainderCalc(3);
        rc.addDigits(country, 0, country.length());
        rc.addDigits(ibanSubstring4, 0, ibanSubstring4.length());
        int check = 98 - rc.getCheckSum();
        if (check < 10) {
            return "0" + check;
        }
        return Integer.toString(check);
    }

    public static String calculateIban(String country, String ibanSubstring4) {
        return country + IbanUtil.calculateCheckDigits(country, ibanSubstring4) + ibanSubstring4;
    }

    public static boolean checkIban(String iban) {
        if (iban == null || iban.length() < 5 || iban.length() > 34) {
            return false;
        }
        if (DISABLE_IBAN_CHECK) {
            return true;
        }
        RemainderCalc rc = new RemainderCalc(1);
        rc.addDigits(iban, 0, 4);
        rc.addDigits(iban, 4, iban.length());
        return rc.getCheckSum() == 1 && (RegularExpressions.IBAN.matches(iban) || IbanUtil.isExperimentalIBANPattern(iban));
    }

    public static boolean checkIbanPattern(String iban) {
        if (IbanUtil.checkIban(iban, false)) {
            return true;
        }
        return IbanUtil.isExperimentalIBANPattern(iban);
    }

    public static boolean isExperimentalIBANPattern(String iban) {
        if (iban != null) {
            return RegularExpressions.EXPERIMENTAL_IBAN.matches(iban);
        }
        return false;
    }

    public static boolean isISO11649Reference(String reference) {
        if (reference == null || reference.length() < 5 || reference.length() > 25) {
            return false;
        }
        RemainderCalc rc = new RemainderCalc(1);
        rc.addDigits(reference, 0, 4);
        rc.addDigits(reference, 4, reference.length());
        return rc.getCheckSum() == 1 && RegularExpressions.CREDITOR_REFERENCE_ISO11649.matches(reference);
    }

    public static boolean checkIban(String iban, boolean withCheckDigitCheck) {
        if (withCheckDigitCheck) {
            return IbanUtil.checkIban(iban);
        }
        if (iban != null) {
            return RegularExpressions.IBAN.matches(iban);
        }
        return false;
    }

    public static String getBankCode(String iban) {
        if (iban != null && iban.length() > 4) {
            switch (iban.substring(0, 2)) {
                case "EE": 
                case "GE": 
                case "MD": 
                case "SA": {
                    return iban.substring(4, 6);
                }
                case "AE": 
                case "BE": 
                case "KZ": 
                case "LU": 
                case "ME": 
                case "MK": 
                case "RS": 
                case "SE": 
                case "TL": 
                case "VA": {
                    return iban.substring(4, 7);
                }
                case "AZ": 
                case "BH": 
                case "CZ": 
                case "DK": 
                case "DO": 
                case "FO": 
                case "GI": 
                case "GL": 
                case "GT": 
                case "KW": 
                case "LB": 
                case "LV": 
                case "NL": 
                case "NO": 
                case "QA": 
                case "RO": 
                case "VG": 
                case "XK": {
                    return iban.substring(4, 8);
                }
                case "AT": 
                case "CH": 
                case "LI": 
                case "LT": 
                case "SI": 
                case "TN": {
                    return iban.substring(4, 9);
                }
                case "BA": 
                case "FI": 
                case "IL": 
                case "IS": 
                case "PK": 
                case "TR": 
                case "UA": {
                    return iban.substring(4, 10);
                }
                case "AL": 
                case "GR": 
                case "HR": 
                case "HU": 
                case "IQ": 
                case "PL": {
                    return iban.substring(4, 11);
                }
                case "AD": 
                case "AO": 
                case "BG": 
                case "BY": 
                case "CV": 
                case "CY": 
                case "DE": 
                case "DZ": 
                case "ES": 
                case "JO": 
                case "LC": 
                case "MU": 
                case "MZ": 
                case "PT": 
                case "SC": 
                case "ST": 
                case "SV": {
                    return iban.substring(4, 12);
                }
                case "MT": {
                    return iban.substring(4, 13);
                }
                case "BF": 
                case "BJ": 
                case "CF": 
                case "CG": 
                case "CI": 
                case "CM": 
                case "FR": 
                case "GA": 
                case "GB": 
                case "IE": 
                case "MC": 
                case "MG": 
                case "ML": 
                case "MR": 
                case "SK": 
                case "SN": {
                    return iban.substring(4, 14);
                }
                case "IT": 
                case "SM": {
                    return iban.substring(4, 15);
                }
                case "BR": 
                case "PS": {
                    return iban.substring(4, 17);
                }
            }
        }
        return null;
    }

    public static String getAccountNumber(String iban) {
        if (iban != null && iban.length() > 4) {
            switch (iban.substring(0, 2)) {
                case "EE": 
                case "GE": 
                case "MD": 
                case "SA": {
                    return iban.substring(6);
                }
                case "AE": 
                case "BE": 
                case "KZ": 
                case "LU": 
                case "ME": 
                case "MK": 
                case "RS": 
                case "SE": 
                case "TL": 
                case "VA": {
                    return iban.substring(7);
                }
                case "AZ": 
                case "BH": 
                case "CZ": 
                case "DK": 
                case "DO": 
                case "FO": 
                case "GI": 
                case "GL": 
                case "GT": 
                case "KW": 
                case "LB": 
                case "LV": 
                case "NL": 
                case "NO": 
                case "QA": 
                case "RO": 
                case "VG": 
                case "XK": {
                    return iban.substring(8);
                }
                case "AT": 
                case "CH": 
                case "LI": 
                case "LT": 
                case "SI": 
                case "TN": {
                    return iban.substring(9);
                }
                case "BA": 
                case "FI": 
                case "IL": 
                case "IS": 
                case "PK": 
                case "TR": 
                case "UA": {
                    return iban.substring(10);
                }
                case "AL": 
                case "GR": 
                case "HR": 
                case "HU": 
                case "IQ": 
                case "PL": {
                    return iban.substring(11);
                }
                case "AD": 
                case "AO": 
                case "BG": 
                case "BY": 
                case "CV": 
                case "CY": 
                case "DE": 
                case "DZ": 
                case "ES": 
                case "JO": 
                case "LC": 
                case "MU": 
                case "MZ": 
                case "PT": 
                case "SC": 
                case "ST": 
                case "SV": {
                    return iban.substring(12);
                }
                case "MT": {
                    return iban.substring(13);
                }
                case "BF": 
                case "BJ": 
                case "CF": 
                case "CG": 
                case "CI": 
                case "CM": 
                case "FR": 
                case "GA": 
                case "GB": 
                case "IE": 
                case "MC": 
                case "MG": 
                case "ML": 
                case "MR": 
                case "SK": 
                case "SN": {
                    return iban.substring(14);
                }
                case "IT": 
                case "SM": {
                    return iban.substring(15);
                }
                case "BR": 
                case "PS": {
                    return iban.substring(17);
                }
            }
        }
        return null;
    }

    public static String getCountryCode(String iban) {
        if (iban != null && iban.length() > 4) {
            return iban.substring(0, 2);
        }
        return null;
    }

    public static void main(String[] args) {
        assert (IbanUtil.checkIban("GE90BG0000000389602600"));
        assert (IbanUtil.checkIban("AD1200012030200359100100"));
        assert (IbanUtil.checkIban("AE070331234567890123456"));
        assert (IbanUtil.checkIban("AL47212110090000000235698741"));
        assert (IbanUtil.checkIban("AT611904300234573201"));
        assert (IbanUtil.checkIban("AZ21NABZ00000000137010001944"));
        assert (IbanUtil.checkIban("BA391290079401028494"));
        assert (IbanUtil.checkIban("BE68539007547034"));
        assert (IbanUtil.checkIban("BG80BNBG96611020345678"));
        assert (IbanUtil.checkIban("BH67BMAG00001299123456"));
        assert (IbanUtil.checkIban("BR1800000000141455123924100C2"));
        assert (IbanUtil.checkIban("BR9700360305000010009795493P1"));
        assert (IbanUtil.checkIban("BR1800360305000010009795493C1"));
        assert (IbanUtil.checkIban("BY13NBRB3600900000002Z00AB00"));
        assert (IbanUtil.checkIban("CH9300762011623852957"));
        assert (IbanUtil.checkIban("CR05015202001026284066"));
        assert (IbanUtil.checkIban("CY17002001280000001200527600"));
        assert (IbanUtil.checkIban("CZ6508000000192000145399"));
        assert (IbanUtil.checkIban("CZ9455000000001011038930"));
        assert (IbanUtil.checkIban("DE89370400440532013000"));
        assert (IbanUtil.checkIban("DK5000400440116243"));
        assert (IbanUtil.checkIban("DO28BAGR00000001212453611324"));
        assert (IbanUtil.checkIban("EE382200221020145685"));
        assert (IbanUtil.checkIban("ES9121000418450200051332"));
        assert (IbanUtil.checkIban("FI2112345600000785"));
        assert (IbanUtil.checkIban("FI5542345670000081"));
        assert (IbanUtil.checkIban("FO6264600001631634"));
        assert (IbanUtil.checkIban("FR1420041010050500013M02606"));
        assert (IbanUtil.checkIban("GB29NWBK60161331926819"));
        assert (IbanUtil.checkIban("GE29NB0000000101904917"));
        assert (IbanUtil.checkIban("GI75NWBK000000007099453"));
        assert (IbanUtil.checkIban("GL8964710001000206"));
        assert (IbanUtil.checkIban("GR1601101250000000012300695"));
        assert (IbanUtil.checkIban("GT82TRAJ01020000001210029690"));
        assert (IbanUtil.checkIban("HR1210010051863000160"));
        assert (IbanUtil.checkIban("HU42117730161111101800000000"));
        assert (IbanUtil.checkIban("IE29AIBK93115212345678"));
        assert (IbanUtil.checkIban("IL620108000000099999999"));
        assert (IbanUtil.checkIban("IQ98NBIQ850123456789012"));
        assert (IbanUtil.checkIban("IS140159260076545510730339"));
        assert (IbanUtil.checkIban("IT60X0542811101000000123456"));
        assert (IbanUtil.checkIban("JO94CBJO0010000000000131000302"));
        assert (IbanUtil.checkIban("KW81CBKU0000000000001234560101"));
        assert (IbanUtil.checkIban("KZ86125KZT5004100100"));
        assert (IbanUtil.checkIban("LB62099900000001001901229114"));
        assert (IbanUtil.checkIban("LC55HEMM000100010012001200023015"));
        assert (IbanUtil.checkIban("LI21088100002324013AA"));
        assert (IbanUtil.checkIban("LT121000011101001000"));
        assert (IbanUtil.checkIban("LU280019400644750000"));
        assert (IbanUtil.checkIban("LV80BANK0000435195001"));
        assert (IbanUtil.checkIban("MC5811222000010123456789030"));
        assert (IbanUtil.checkIban("MD24AG000225100013104168"));
        assert (IbanUtil.checkIban("ME25505000012345678951"));
        assert (IbanUtil.checkIban("MK07250120000058984"));
        assert (IbanUtil.checkIban("MR1300020001010000123456753"));
        assert (IbanUtil.checkIban("MT84MALT011000012345MTLCAST001S"));
        assert (IbanUtil.checkIban("MU17BOMM0101101030300200000MUR"));
        assert (IbanUtil.checkIban("NL91ABNA0417164300"));
        assert (IbanUtil.checkIban("NO9386011117947"));
        assert (IbanUtil.checkIban("PK36SCBL0000001123456702"));
        assert (IbanUtil.checkIban("PL61109010140000071219812874"));
        assert (IbanUtil.checkIban("PS92PALS000000000400123456702"));
        assert (IbanUtil.checkIban("PT50000201231234567890154"));
        assert (IbanUtil.checkIban("QA58DOHB00001234567890ABCDEFG"));
        assert (IbanUtil.checkIban("RO49AAAA1B31007593840000"));
        assert (IbanUtil.checkIban("RS35260005601001611379"));
        assert (IbanUtil.checkIban("SA0380000000608010167519"));
        assert (IbanUtil.checkIban("SC18SSCB11010000000000001497USD"));
        assert (IbanUtil.checkIban("SE4550000000058398257466"));
        assert (IbanUtil.checkIban("SI56191000000123438"));
        assert (IbanUtil.checkIban("SI56263300012039086"));
        assert (IbanUtil.checkIban("SK3112000000198742637541"));
        assert (IbanUtil.checkIban("SM86U0322509800000000270100"));
        assert (IbanUtil.checkIban("ST68000100010051845310112"));
        assert (IbanUtil.checkIban("ST32000200010192194210112"));
        assert (IbanUtil.checkIban("SV62CENR00000000000000700025"));
        assert (IbanUtil.checkIban("TL380080012345678910157"));
        assert (IbanUtil.checkIban("TN5910006035183598478831"));
        assert (IbanUtil.checkIban("TR330006100519786457841326"));
        assert (IbanUtil.checkIban("UA213996220000026007233566001"));
        assert (IbanUtil.checkIban("UA213223130000026007233566001"));
        assert (IbanUtil.checkIban("VA59001123000012345678"));
        assert (IbanUtil.checkIban("VG96VPVG0000012345678901"));
        assert (IbanUtil.checkIban("XK051212012345678906"));
        try {
            assert (false);
            System.out.println("Assertions not activated. Try -enableassertions");
        }
        catch (AssertionError e) {
            System.out.println("everything ok");
        }
        String accountNumber = "5000003189";
        String blz = "12345678";
        String iban = IbanUtil.calculateUncheckedGermanIban(accountNumber, blz);
        System.out.println("IBAN = " + iban);
        String result = IbanUtil.calculateCheckDigits("CH", "34567890123456789");
        System.out.println("Checkdigits = " + result);
    }

    private static String normalize(String value) {
        try {
            long l = Long.parseLong(value);
            DecimalFormat df = new DecimalFormat("0000000000");
            return df.format(l);
        }
        catch (NumberFormatException nf) {
            throw new IllegalArgumentException(nf);
        }
    }

    public static String formatIBAN(String in) {
        if (in == null) {
            return null;
        }
        if (in.length() == 0) {
            return in;
        }
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < in.length(); i += 4) {
            if (b.length() > 0) {
                b.append(' ');
            }
            if (i + 4 < in.length()) {
                b.append(in, i, i + 4);
                continue;
            }
            b.append(in.substring(i));
        }
        return b.toString();
    }

    public static String formatIfIBAN(String accountNumber) {
        if (IbanUtil.checkIbanPattern(accountNumber)) {
            return IbanUtil.formatIBAN(accountNumber);
        }
        return accountNumber;
    }

    public static String prependCalculatedCINforIT(String ibanSubstring4) {
        int CHAR_OFFSET = 65;
        int DIVIDER = 26;
        int sum = 0;
        int[] evenIndexLookup = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25};
        int[] oddIndexLookup = new int[]{1, 0, 5, 7, 9, 13, 15, 17, 19, 21, 2, 4, 18, 20, 11, 3, 6, 8, 12, 14, 16, 10, 22, 25, 24, 23};
        for (int k = 1; k <= 22; ++k) {
            char c = ibanSubstring4.charAt(k - 1);
            int i = Character.isDigit(c) ? Character.digit(c, 10) : c - 65;
            sum += k % 2 == 0 ? evenIndexLookup[i] : oddIndexLookup[i];
        }
        int y = sum % 26;
        char cin = (char)(y + 65);
        return cin + ibanSubstring4;
    }

    private static class RemainderCalc {
        private int multDigit;
        private int remainderSum = 0;

        RemainderCalc(int firstMultDigit) {
            this.multDigit = firstMultDigit;
        }

        void addDigits(String input, int from, int to) {
            while (--to >= from) {
                char c = input.charAt(to);
                int i = Character.getNumericValue(c);
                this.remainderSum += this.multDigit * i;
                this.multDigit *= i >= 10 ? 100 : 10;
                this.multDigit %= 97;
            }
        }

        int getCheckSum() {
            return this.remainderSum % 97;
        }
    }
}

