/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.ptk2.DisplayMessage;
import de.businesslogics.format.ticket.DisplayMessageGenerator;
import de.businesslogics.format.ticket.Pain001ZZV05PaymentInstruction;
import de.businesslogics.format.ticket.Pain001ZZV05Ticket;
import de.businesslogics.util.xml.SmartDefaultHandler;
import java.io.IOException;
import java.io.InputStream;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XZVDisplayMessageGenerator
extends SmartDefaultHandler
implements DisplayMessageGenerator {
    public static final SmartDefaultHandler.Path P115_MSG_ID;
    public static final SmartDefaultHandler.Path P115_CRE_DT_TM;
    public static final SmartDefaultHandler.Path P115_PMT_INF_ID;
    public static final SmartDefaultHandler.Path P115_PMT_REQD_EXCTN_DT;
    public static final SmartDefaultHandler.Path P115_DBTR_NM;
    public static final SmartDefaultHandler.Path P115_DBTR_ACCT_IBAN;
    public static final SmartDefaultHandler.Path P115_DBTR_ACCT_OTHR;
    public static final SmartDefaultHandler.Path P115_DBTR_AGT_BICFI;
    public static final SmartDefaultHandler.Path P115_DBTR_AGT_CLR_SYS_MMB_ID;
    public static final SmartDefaultHandler.Path P115_DBTR_AGT_NM;
    public static final SmartDefaultHandler.Path P115_INSTD_AMT;
    public static final SmartDefaultHandler.Path P115_EQVT_AMT;
    private String namespace;
    private Pain001ZZV05Ticket p115Message;
    private Pain001ZZV05PaymentInstruction p115Payment;
    private String ccy;

    public String getNamespace() {
        return this.namespace;
    }

    @SmartDefaultHandler.Callback(value={"P115_MSG_ID"})
    public void setP115MsgId() {
        this.namespace = this.getPath().getUri();
        this.p115Message = new Pain001ZZV05Ticket();
        this.p115Message.messageIdentification = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P115_CRE_DT_TM"})
    public void setP115CreDtTm() throws SAXParseException {
        this.p115Message.creationDateTime = this.getDateTime();
    }

    @SmartDefaultHandler.Callback(value={"P115_PMT_INF_ID"})
    public void setP115PmtInfId() {
        this.p115Payment = new Pain001ZZV05PaymentInstruction();
        this.p115Payment.pmtInfId = this.getString();
        this.p115Message.payments.add(this.p115Payment);
    }

    @SmartDefaultHandler.Callback(value={"P115_PMT_REQD_EXCTN_DT"})
    public void setP115PmtReqdExtnDt() throws SAXException {
        this.p115Payment.reqdExctnDt = this.getDate();
    }

    @SmartDefaultHandler.Callback(value={"P115_DBTR_NM"})
    public void setP115PmtDbtrNm() {
        this.p115Payment.dbtrNm = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P115_DBTR_ACCT_IBAN"})
    public void setP115PmtDbtrIban() {
        this.p115Payment.dbtrAcct = this.getString();
        this.p115Payment.dbtrFlags |= Pain001ZZV05PaymentInstruction.ACCOUNT_TYPE_IBAN;
    }

    @SmartDefaultHandler.Callback(value={"P115_DBTR_ACCT_OTHR"})
    public void setP115PmtDbtrAcctOthr() {
        this.p115Payment.dbtrAcct = this.getString();
        this.p115Payment.dbtrFlags |= Pain001ZZV05PaymentInstruction.ACCOUNT_TYPE_OTHR;
    }

    @SmartDefaultHandler.Callback(value={"P115_DBTR_AGT_BICFI"})
    public void setP115PmtDbtrBic() {
        this.p115Payment.dbtrAgt = this.getString();
        this.p115Payment.dbtrFlags |= 0x10;
    }

    @SmartDefaultHandler.Callback(value={"P115_DBTR_AGT_CLR_SYS_MMB_ID"})
    public void setP115PmtDbtrAgt() {
        if (this.p115Payment.dbtrAgt == null) {
            this.p115Payment.dbtrAgt = this.getString();
        }
    }

    @SmartDefaultHandler.Callback(value={"P115_DBTR_AGT_NM"})
    public void setP115PmtDbtrAgtNm() {
        this.p115Payment.dbtrAgtNm = this.getString();
    }

    @SmartDefaultHandler.Callback(value={"P115_INSTD_AMT", "P115_EQVT_AMT"})
    public void startInstdAmt(Attributes attributes) throws SAXParseException {
        this.ccy = attributes.getValue("Ccy");
    }

    @SmartDefaultHandler.Callback(value={"P115_INSTD_AMT", "P115_EQVT_AMT"})
    public void setP115InstdAmt() throws SAXParseException {
        this.p115Payment.add(this.ccy, this.getDecimal());
    }

    @Override
    public Pain001ZZV05Ticket getMessage(InputStream in) throws IOException, SAXException {
        this.p115Message = null;
        this.parse(in);
        return this.p115Message;
    }

    public DisplayMessage getMessage() {
        return this.p115Message;
    }

    @Override
    protected String getNamespaceSchemaLocations() {
        return "urn:iso:std:iso:20022:tech:xsd:pain.001.zzv.05 /de/businesslogics/format/iso20022/pain.001.zzv.05.xsd";
    }

    static {
        SmartDefaultHandler.Path document = new SmartDefaultHandler.Path(null, "urn:iso:std:iso:20022:tech:xsd:pain.001.zzv.05", "Document");
        SmartDefaultHandler.Path cstmrCdtTrfInitn = new SmartDefaultHandler.Path(document, "CstmrCdtTrfInitn");
        SmartDefaultHandler.Path grpHdr = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "GrpHdr");
        P115_MSG_ID = new SmartDefaultHandler.Path(grpHdr, "MsgId");
        P115_CRE_DT_TM = new SmartDefaultHandler.Path(grpHdr, "CreDtTm");
        SmartDefaultHandler.Path pmtInf = new SmartDefaultHandler.Path(cstmrCdtTrfInitn, "PmtInf");
        P115_PMT_INF_ID = new SmartDefaultHandler.Path(pmtInf, "PmtInfId");
        P115_PMT_REQD_EXCTN_DT = new SmartDefaultHandler.Path(pmtInf, "ReqdExctnDt");
        SmartDefaultHandler.Path dbtr = new SmartDefaultHandler.Path(pmtInf, "Dbtr");
        P115_DBTR_NM = new SmartDefaultHandler.Path(dbtr, "Nm");
        SmartDefaultHandler.Path dbtrAcct = new SmartDefaultHandler.Path(pmtInf, "DbtrAcct");
        SmartDefaultHandler.Path id = new SmartDefaultHandler.Path(dbtrAcct, "Id");
        P115_DBTR_ACCT_IBAN = new SmartDefaultHandler.Path(id, "IBAN");
        SmartDefaultHandler.Path othr = new SmartDefaultHandler.Path(id, "Othr");
        P115_DBTR_ACCT_OTHR = new SmartDefaultHandler.Path(othr, "Id");
        SmartDefaultHandler.Path dbtrAgt = new SmartDefaultHandler.Path(pmtInf, "DbtrAgt");
        SmartDefaultHandler.Path finInstnId = new SmartDefaultHandler.Path(dbtrAgt, "FinInstnId");
        P115_DBTR_AGT_BICFI = new SmartDefaultHandler.Path(finInstnId, "BICFI");
        SmartDefaultHandler.Path clrSysMbId = new SmartDefaultHandler.Path(finInstnId, "ClrSysMmbId");
        P115_DBTR_AGT_CLR_SYS_MMB_ID = new SmartDefaultHandler.Path(clrSysMbId, "MmbId");
        P115_DBTR_AGT_NM = new SmartDefaultHandler.Path(finInstnId, "Nm");
        SmartDefaultHandler.Path cdtTrfTxInf = new SmartDefaultHandler.Path(pmtInf, "CdtTrfTxInf");
        SmartDefaultHandler.Path amt = new SmartDefaultHandler.Path(cdtTrfTxInf, "Amt");
        P115_INSTD_AMT = new SmartDefaultHandler.Path(amt, "InstdAmt");
        SmartDefaultHandler.Path eqvtAmt = new SmartDefaultHandler.Path(amt, "EqvtAmt");
        P115_EQVT_AMT = new SmartDefaultHandler.Path(eqvtAmt, "Amt");
    }
}

