/*
 * Decompiled with CFR 0.152.
 */
package de.businesslogics.format.ticket;

import de.businesslogics.format.ptk2.AdditionalInfoResult;
import de.businesslogics.format.ticket.AbstractDisplayMessage;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

public class VOPResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<Locale, String> DISCLAIMERS = new ConcurrentHashMap<Locale, String>();
    private static final String VOP_DISCLAIMER = "VOP_DISCLAIMER";
    private int match;
    private int closeMatch;
    private int noMatch;
    private int notApplicable;

    public void increaseMatch(int increment) {
        this.match += increment;
    }

    public void increaseCloseMatch(int increment) {
        this.closeMatch += increment;
    }

    public void increaseNoMatch(int increment) {
        this.noMatch += increment;
    }

    public void increaseNotApplicable(int increment) {
        this.notApplicable += increment;
    }

    public int getNumberOfPayments() {
        return this.match + this.closeMatch + this.noMatch + this.notApplicable;
    }

    public int getMatch() {
        return this.match;
    }

    public int getCloseMatch() {
        return this.closeMatch;
    }

    public int getNoMatch() {
        return this.noMatch;
    }

    public int getNotApplicable() {
        return this.notApplicable;
    }

    void append(AbstractDisplayMessage message) {
        message.calculateKeyWidth("VOP_TOTAL_TX", "VOP_MTCH_TX", "VOP_CMTC_TX", "VOP_NMTC_TX", "VOP_NOAP_TX");
        message.minorSeparator();
        message.writeLine("VOP_RESULT");
        message.writeKeyValue("VOP_TOTAL_TX", Integer.toString(this.getNumberOfPayments()));
        message.writeKeyValue("VOP_MTCH_TX", Integer.toString(this.getMatch()));
        message.writeKeyValue("VOP_CMTC_TX", Integer.toString(this.getCloseMatch()));
        message.writeKeyValue("VOP_NMTC_TX", Integer.toString(this.getNoMatch()));
        message.writeKeyValue("VOP_NOAP_TX", Integer.toString(this.getNotApplicable()));
        if (this.getNumberOfPayments() != this.getMatch()) {
            String disclaimer = DISCLAIMERS.get(message.locale);
            if (disclaimer == null) {
                ResourceBundle rb;
                try {
                    rb = ResourceBundle.getBundle("vop", message.locale);
                }
                catch (MissingResourceException mre) {
                    rb = message.bundle;
                }
                disclaimer = rb.getString(VOP_DISCLAIMER);
                StringBuilder myBuffer = new StringBuilder(disclaimer);
                AdditionalInfoResult.format(myBuffer, 63);
                for (int i = 0; i < myBuffer.length(); ++i) {
                    char c = myBuffer.charAt(i);
                    if (c != '\r' || (i += 2) >= myBuffer.length()) continue;
                    myBuffer.insert(i, "     ");
                }
                disclaimer = myBuffer.toString();
                DISCLAIMERS.put(message.locale, disclaimer);
            }
            message.buffer.append("     ").append(disclaimer).append("\r\n");
        }
    }
}

